/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.rabbitmq;

import com.chdu.ai.model.ChatMessage;
import com.chdu.ai.service.ChatService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Service;

@Service
public class RabbitMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQConsumer.class);
    private final ChatService chatService;

    public RabbitMQConsumer(ChatService chatService) {
        this.chatService = chatService;
    }

    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="medical_queue", durable="true"), exchange=@Exchange(value="medical_exchange", type="direct"), key={"medical_routing_key"})})
    public void receiveMedicalQuery(String message) {
        log.info("\u6536\u5230\u533b\u751f\u52a9\u7406\u67e5\u8be2\u8bf7\u6c42: {}", (Object)message);
    }

    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="chat_queue", durable="true"), exchange=@Exchange(value="chat_exchange", type="direct"), key={"chat.send"})})
    public void handleChatMessage(ChatMessage chatMessage) {
        try {
            log.info("\u6536\u5230\u804a\u5929\u6d88\u606f: {}", (Object)chatMessage);
            this.chatService.saveMessage(chatMessage);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u804a\u5929\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

