/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.ChatSessionMapper;
import com.chdu.ai.model.ChatSession;
import com.chdu.ai.service.ChatSessionService;
import com.chdu.ai.service.DifyUserMappingService;
import com.chdu.ai.util.NumericIdGenerator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChatSessionServiceImpl
implements ChatSessionService {
    private static final Logger logger = LoggerFactory.getLogger(ChatSessionServiceImpl.class);
    private final ChatSessionMapper sessionMapper;
    private final DifyUserMappingService mappingService;

    public ChatSessionServiceImpl(ChatSessionMapper sessionMapper, DifyUserMappingService mappingService) {
        this.sessionMapper = sessionMapper;
        this.mappingService = mappingService;
    }

    @Transactional
    public ChatSession createOrGetSession(String userId, String hospitalId, String difyConversationId) {
        try {
            ChatSession existingSession;
            if (difyConversationId != null && !difyConversationId.trim().isEmpty() && (existingSession = this.sessionMapper.getSessionByDifyConversationId(difyConversationId)) != null) {
                logger.debug("\u627e\u5230\u73b0\u6709\u4f1a\u8bdd: sessionId={}, difyConversationId={}", (Object)existingSession.getId(), (Object)difyConversationId);
                return existingSession;
            }
            String difyUserId = this.mappingService.getDifyUserId(userId, hospitalId);
            ChatSession newSession = new ChatSession(userId, hospitalId, difyConversationId, difyUserId);
            newSession.setId(NumericIdGenerator.generate9NumericId());
            newSession.setViewId(NumericIdGenerator.generateViewId());
            newSession.setSessionTitle("\u65b0\u5bf9\u8bdd");
            this.sessionMapper.insertChatSession(newSession);
            logger.info("\u521b\u5efa\u65b0\u804a\u5929\u4f1a\u8bdd: sessionId={}, userId={}, hospitalId={}, difyConversationId={}", new Object[]{newSession.getId(), userId, hospitalId, difyConversationId});
            return newSession;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u6216\u83b7\u53d6\u4f1a\u8bdd\u5931\u8d25: userId={}, hospitalId={}, difyConversationId={}", new Object[]{userId, hospitalId, difyConversationId, e});
            throw new RuntimeException("\u521b\u5efa\u4f1a\u8bdd\u5931\u8d25: " + e.getMessage());
        }
    }

    public ChatSession getSessionByDifyConversationId(String difyConversationId) {
        try {
            return this.sessionMapper.getSessionByDifyConversationId(difyConversationId);
        }
        catch (Exception e) {
            logger.error("\u6839\u636eDify\u5bf9\u8bddID\u83b7\u53d6\u4f1a\u8bdd\u5931\u8d25: difyConversationId={}", (Object)difyConversationId, (Object)e);
            return null;
        }
    }

    public List<ChatSession> getSessionsByUser(String userId, String hospitalId, int page, int size) {
        try {
            int offset = page * size;
            List sessions = this.sessionMapper.getSessionsByUserAndHospital(userId, hospitalId, size, offset);
            logger.info("\u83b7\u53d6\u7528\u6237\u4f1a\u8bdd\u5217\u8868\u6210\u529f: userId={}, hospitalId={}, page={}, size={}, count={}", new Object[]{userId, hospitalId, page, size, sessions.size()});
            return sessions;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7528\u6237\u4f1a\u8bdd\u5217\u8868\u5931\u8d25: userId={}, hospitalId={}", new Object[]{userId, hospitalId, e});
            throw new RuntimeException("\u83b7\u53d6\u4f1a\u8bdd\u5217\u8868\u5931\u8d25: " + e.getMessage());
        }
    }

    public List<ChatSession> getSessionsByHospital(String hospitalId, int page, int size) {
        try {
            int offset = page * size;
            List sessions = this.sessionMapper.getSessionsByHospital(hospitalId, size, offset);
            logger.info("\u83b7\u53d6\u533b\u9662\u4f1a\u8bdd\u5217\u8868\u6210\u529f: hospitalId={}, page={}, size={}, count={}", new Object[]{hospitalId, page, size, sessions.size()});
            return sessions;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u533b\u9662\u4f1a\u8bdd\u5217\u8868\u5931\u8d25: hospitalId={}", (Object)hospitalId, (Object)e);
            throw new RuntimeException("\u83b7\u53d6\u533b\u9662\u4f1a\u8bdd\u5217\u8868\u5931\u8d25: " + e.getMessage());
        }
    }

    @Transactional
    public void updateLastMessage(String sessionId, String message, String messageType) {
        try {
            ChatSession session = this.sessionMapper.getSessionById(sessionId);
            if (session == null) {
                logger.warn("\u4f1a\u8bdd\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u66f4\u65b0\u6700\u540e\u6d88\u606f: sessionId={}", (Object)sessionId);
                return;
            }
            Integer newCount = (session.getMessageCount() == null ? 0 : session.getMessageCount()) + 1;
            if (newCount == 1 && "user".equals(messageType)) {
                String title = this.mappingService.generateSessionTitle(message);
                session.setSessionTitle(title);
                session.updateLastMessage(message, messageType);
                this.sessionMapper.updateSession(session);
            } else {
                this.sessionMapper.updateLastMessage(sessionId, message, messageType, newCount);
            }
            logger.debug("\u66f4\u65b0\u4f1a\u8bdd\u6700\u540e\u6d88\u606f\u6210\u529f: sessionId={}, messageType={}, count={}", new Object[]{sessionId, messageType, newCount});
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4f1a\u8bdd\u6700\u540e\u6d88\u606f\u5931\u8d25: sessionId={}", (Object)sessionId, (Object)e);
        }
    }

    @Transactional
    public boolean updateSessionTitle(String sessionId, String title) {
        try {
            ChatSession session = this.sessionMapper.getSessionById(sessionId);
            if (session == null) {
                logger.warn("\u4f1a\u8bdd\u4e0d\u5b58\u5728: sessionId={}", (Object)sessionId);
                return false;
            }
            session.setSessionTitle(title);
            int result = this.sessionMapper.updateSession(session);
            if (result > 0) {
                logger.info("\u66f4\u65b0\u4f1a\u8bdd\u6807\u9898\u6210\u529f: sessionId={}, title={}", (Object)sessionId, (Object)title);
                return true;
            }
            logger.warn("\u66f4\u65b0\u4f1a\u8bdd\u6807\u9898\u5931\u8d25: sessionId={}", (Object)sessionId);
            return false;
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4f1a\u8bdd\u6807\u9898\u5f02\u5e38: sessionId={}, title={}", new Object[]{sessionId, title, e});
            return false;
        }
    }

    @Transactional
    public boolean archiveSession(String sessionId) {
        try {
            int result = this.sessionMapper.updateSessionStatus(sessionId, Integer.valueOf(1));
            if (result > 0) {
                logger.info("\u5f52\u6863\u4f1a\u8bdd\u6210\u529f: sessionId={}", (Object)sessionId);
                return true;
            }
            logger.warn("\u5f52\u6863\u4f1a\u8bdd\u5931\u8d25\uff0c\u4f1a\u8bdd\u4e0d\u5b58\u5728: sessionId={}", (Object)sessionId);
            return false;
        }
        catch (Exception e) {
            logger.error("\u5f52\u6863\u4f1a\u8bdd\u5f02\u5e38: sessionId={}", (Object)sessionId, (Object)e);
            return false;
        }
    }

    @Transactional
    public boolean deleteSession(String sessionId) {
        try {
            int result = this.sessionMapper.updateSessionStatus(sessionId, Integer.valueOf(2));
            if (result > 0) {
                logger.info("\u5220\u9664\u4f1a\u8bdd\u6210\u529f: sessionId={}", (Object)sessionId);
                return true;
            }
            logger.warn("\u5220\u9664\u4f1a\u8bdd\u5931\u8d25\uff0c\u4f1a\u8bdd\u4e0d\u5b58\u5728: sessionId={}", (Object)sessionId);
            return false;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u4f1a\u8bdd\u5f02\u5e38: sessionId={}", (Object)sessionId, (Object)e);
            return false;
        }
    }

    public int countUserSessions(String userId, String hospitalId) {
        try {
            return this.sessionMapper.countSessionsByUserAndHospital(userId, hospitalId);
        }
        catch (Exception e) {
            logger.error("\u7edf\u8ba1\u7528\u6237\u4f1a\u8bdd\u6570\u91cf\u5931\u8d25: userId={}, hospitalId={}", new Object[]{userId, hospitalId, e});
            return 0;
        }
    }

    public int countHospitalSessions(String hospitalId) {
        try {
            return this.sessionMapper.countSessionsByHospital(hospitalId);
        }
        catch (Exception e) {
            logger.error("\u7edf\u8ba1\u533b\u9662\u4f1a\u8bdd\u6570\u91cf\u5931\u8d25: hospitalId={}", (Object)hospitalId, (Object)e);
            return 0;
        }
    }
}

