/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.model.DifyChatRequest;
import com.chdu.ai.model.HospitalWorkflow;
import com.chdu.ai.model.PatientSession;
import com.chdu.ai.model.TTSAudioCache;
import com.chdu.ai.service.HospitalWorkflowService;
import com.chdu.ai.service.MultiWorkflowDifyService;
import com.chdu.ai.service.PatientSessionService;
import com.chdu.ai.service.TTSCacheService;
import com.chdu.ai.util.DifyResponseProcessor;
import com.chdu.ai.util.UltraSafeMessageSender;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import org.springframework.web.socket.WebSocketSession;

@Service
public class MultiWorkflowDifyServiceImpl
implements MultiWorkflowDifyService {
    private static final Logger logger = LoggerFactory.getLogger(MultiWorkflowDifyServiceImpl.class);
    @Autowired
    private HospitalWorkflowService hospitalWorkflowService;
    @Autowired
    private PatientSessionService patientSessionService;
    @Autowired
    private TTSCacheService ttsCacheService;
    private final RestTemplate restTemplate = new RestTemplate();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void chatWithDify(DifyChatRequest request, WebSocketSession session) {
        CompletableFuture.runAsync(() -> {
            try {
                if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                    this.sendErrorMessage(session, "\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
                if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                    this.sendErrorMessage(session, "\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
                HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(request.getHospitalId(), request.getWorkflowType());
                if (workflow == null) {
                    this.sendErrorMessage(session, "\u672a\u627e\u5230\u533b\u9662\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e");
                    return;
                }
                Long sessionId = (Long)session.getAttributes().get("sessionId");
                this.streamChatRequest(request, workflow, null, session, sessionId);
            }
            catch (Exception e) {
                logger.error("\u591a\u5de5\u4f5c\u6d41WebSocket\u804a\u5929\u8bf7\u6c42\u5931\u8d25: hospitalId={}", (Object)request.getHospitalId(), (Object)e);
                this.sendErrorMessage(session, "\u804a\u5929\u8bf7\u6c42\u5931\u8d25: " + e.getMessage());
            }
        });
    }

    public SseEmitter chatWithDify(DifyChatRequest request) {
        SseEmitter emitter = new SseEmitter(Long.valueOf(60000L));
        CompletableFuture.runAsync(() -> {
            try {
                if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                    emitter.completeWithError((Throwable)new RuntimeException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a"));
                    return;
                }
                if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                    emitter.completeWithError((Throwable)new RuntimeException("\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                    return;
                }
                HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(request.getHospitalId(), request.getWorkflowType());
                if (workflow == null) {
                    emitter.completeWithError((Throwable)new RuntimeException("\u672a\u627e\u5230\u533b\u9662\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e"));
                    return;
                }
                this.streamChatRequest(request, workflow, emitter, null, null);
            }
            catch (Exception e) {
                logger.error("\u591a\u5de5\u4f5c\u6d41SSE\u804a\u5929\u8bf7\u6c42\u5931\u8d25: hospitalId={}", (Object)request.getHospitalId(), (Object)e);
                emitter.completeWithError((Throwable)e);
            }
        });
        return emitter;
    }

    public String chatWithDifyBlocking(DifyChatRequest request) {
        try {
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                throw new RuntimeException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                throw new RuntimeException("\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(request.getHospitalId(), request.getWorkflowType());
            if (workflow == null) {
                throw new RuntimeException("\u672a\u627e\u5230\u533b\u9662\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e");
            }
            return this.blockingChatRequest(request, workflow);
        }
        catch (Exception e) {
            logger.error("\u591a\u5de5\u4f5c\u6d41\u963b\u585e\u804a\u5929\u8bf7\u6c42\u5931\u8d25: hospitalId={}", (Object)request.getHospitalId(), (Object)e);
            throw new RuntimeException("\u804a\u5929\u8bf7\u6c42\u5931\u8d25: " + e.getMessage());
        }
    }

    public boolean hasWorkflowConfig(String hospitalId) {
        return this.hospitalWorkflowService.hasWorkflowConfig(hospitalId);
    }

    public String getWorkflowInfo(String hospitalId) {
        List workflows = this.hospitalWorkflowService.getWorkflowsByHospitalId(hospitalId);
        if (workflows.isEmpty()) {
            return "\u65e0\u53ef\u7528\u5de5\u4f5c\u6d41";
        }
        StringBuilder info = new StringBuilder();
        for (HospitalWorkflow workflow : workflows) {
            if (info.length() > 0) {
                info.append(", ");
            }
            info.append(workflow.getWorkflowName()).append("(").append(workflow.getWorkflowType()).append(")");
        }
        return info.toString();
    }

    public String getConversationHistory(String conversationId, String user) {
        try {
            logger.info("\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\uff08\u6700\u65b0\u6d88\u606f\uff09: conversationId={}, user={}", (Object)conversationId, (Object)user);
            PatientSession patientSession = this.patientSessionService.findByDifyConversationId(conversationId);
            if (patientSession == null) {
                logger.warn("\u672a\u627e\u5230conversationId\u5bf9\u5e94\u7684\u60a3\u8005\u4f1a\u8bdd: conversationId={}", (Object)conversationId);
                return "{}";
            }
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(patientSession.getHospitalId(), patientSession.getWorkflowType());
            if (workflow == null) {
                logger.warn("\u672a\u627e\u5230\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}, workflowType={}", (Object)patientSession.getHospitalId(), (Object)patientSession.getWorkflowType());
                return "{}";
            }
            return this.getConversationHistoryPage(conversationId, user, workflow, null);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\u5931\u8d25: conversationId={}, user={}", new Object[]{conversationId, user, e});
            return "{}";
        }
    }

    public String getConversationHistoryMore(String conversationId, String user, String firstMessageId) {
        try {
            logger.info("\u83b7\u53d6\u66f4\u591a\u5bf9\u8bdd\u5386\u53f2: conversationId={}, user={}, firstMessageId={}", new Object[]{conversationId, user, firstMessageId});
            PatientSession patientSession = this.patientSessionService.findByDifyConversationId(conversationId);
            if (patientSession == null) {
                logger.warn("\u672a\u627e\u5230conversationId\u5bf9\u5e94\u7684\u60a3\u8005\u4f1a\u8bdd: conversationId={}", (Object)conversationId);
                return "{}";
            }
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(patientSession.getHospitalId(), patientSession.getWorkflowType());
            if (workflow == null) {
                logger.warn("\u672a\u627e\u5230\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}, workflowType={}", (Object)patientSession.getHospitalId(), (Object)patientSession.getWorkflowType());
                return "{}";
            }
            return this.getConversationHistoryPage(conversationId, user, workflow, firstMessageId);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u66f4\u591a\u5bf9\u8bdd\u5386\u53f2\u5931\u8d25: conversationId={}, user={}, firstMessageId={}", new Object[]{conversationId, user, firstMessageId, e});
            return "{}";
        }
    }

    private String getConversationHistoryFromDify(String conversationId, String user, HospitalWorkflow workflow) {
        try {
            ArrayList<JsonNode> allMessages = new ArrayList<JsonNode>();
            String firstMessageId = null;
            boolean hasMore = true;
            int pageCount = 0;
            int maxPages = 50;
            while (hasMore && pageCount < 50) {
                JsonNode lastMessage;
                JsonNode responseJson;
                logger.info("\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\u7b2c{}\u9875: conversationId={}", (Object)(++pageCount), (Object)conversationId);
                String pageResponse = this.getConversationHistoryPage(conversationId, user, workflow, firstMessageId);
                if (pageResponse == null || "{}".equals(pageResponse) || !(responseJson = this.objectMapper.readTree(pageResponse)).has("data") || !responseJson.get("data").isArray()) break;
                JsonNode messagesArray = responseJson.get("data");
                if (messagesArray.size() == 0) {
                    hasMore = false;
                    break;
                }
                for (JsonNode message : messagesArray) {
                    allMessages.add(message);
                }
                if (responseJson.has("has_more")) {
                    hasMore = responseJson.get("has_more").asBoolean();
                } else {
                    boolean bl = hasMore = messagesArray.size() >= 20;
                }
                if (!hasMore || messagesArray.size() <= 0 || !(lastMessage = messagesArray.get(messagesArray.size() - 1)).has("id")) continue;
                firstMessageId = lastMessage.get("id").asText();
            }
            HashMap<String, Serializable> completeResponse = new HashMap<String, Serializable>();
            completeResponse.put("data", allMessages);
            completeResponse.put("total", Integer.valueOf(allMessages.size()));
            completeResponse.put("pages", Integer.valueOf(pageCount));
            completeResponse.put("has_more", Boolean.valueOf(false));
            String result = this.objectMapper.writeValueAsString(completeResponse);
            logger.info("\u6210\u529f\u83b7\u53d6\u5b8c\u6574\u5bf9\u8bdd\u5386\u53f2: conversationId={}, \u603b\u6d88\u606f\u6570={}, \u603b\u9875\u6570={}", new Object[]{conversationId, allMessages.size(), pageCount});
            return result;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528Dify API\u83b7\u53d6\u5b8c\u6574\u5bf9\u8bdd\u5386\u53f2\u5931\u8d25: conversationId={}, user={}", new Object[]{conversationId, user, e});
            return "{}";
        }
    }

    private String getConversationHistoryPage(String conversationId, String user, HospitalWorkflow workflow, String firstMessageId) {
        try {
            String url = workflow.getDifyApiUrl() + "/messages";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Bearer " + workflow.getDifyApiKey());
            headers.setContentType(MediaType.APPLICATION_JSON);
            StringBuilder urlWithParams = new StringBuilder(url);
            urlWithParams.append("?conversation_id=").append(conversationId);
            urlWithParams.append("&user=").append(user);
            urlWithParams.append("&limit=20");
            if (firstMessageId != null && !firstMessageId.trim().isEmpty()) {
                urlWithParams.append("&first_id=").append(firstMessageId);
            }
            logger.debug("\u8c03\u7528Dify API\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2: URL={}", (Object)urlWithParams.toString());
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(urlWithParams.toString(), HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                String responseBody = (String)response.getBody();
                logger.debug("Dify API\u8fd4\u56de\u5bf9\u8bdd\u5386\u53f2\u6210\u529f: conversationId={}, firstMessageId={}", (Object)conversationId, (Object)firstMessageId);
                return responseBody;
            }
            logger.warn("\u83b7\u53d6Dify\u5bf9\u8bdd\u5386\u53f2\u9875\u5931\u8d25: HTTP {}, conversationId={}, firstMessageId={}", new Object[]{response.getStatusCode(), conversationId, firstMessageId});
            return "{}";
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528Dify API\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\u9875\u5931\u8d25: conversationId={}, user={}, firstMessageId={}", new Object[]{conversationId, user, firstMessageId, e});
            return "{}";
        }
    }

    public boolean deleteConversation(String conversationId, String user) {
        try {
            logger.info("\u5220\u9664\u5bf9\u8bdd: conversationId={}, user={}", (Object)conversationId, (Object)user);
            PatientSession patientSession = this.patientSessionService.findByDifyConversationId(conversationId);
            if (patientSession == null) {
                logger.warn("\u672a\u627e\u5230conversationId\u5bf9\u5e94\u7684\u60a3\u8005\u4f1a\u8bdd: conversationId={}", (Object)conversationId);
                return false;
            }
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(patientSession.getHospitalId(), patientSession.getWorkflowType());
            if (workflow == null) {
                logger.warn("\u672a\u627e\u5230\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}, workflowType={}", (Object)patientSession.getHospitalId(), (Object)patientSession.getWorkflowType());
                return false;
            }
            boolean success = this.deleteConversationFromDify(conversationId, user, workflow);
            if (success) {
                this.patientSessionService.endSession(patientSession.getId());
                logger.info("\u5df2\u7ed3\u675f\u672c\u5730\u60a3\u8005\u4f1a\u8bdd: sessionId={}", (Object)patientSession.getId());
            }
            return success;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5bf9\u8bdd\u5931\u8d25: conversationId={}, user={}", new Object[]{conversationId, user, e});
            return false;
        }
    }

    private boolean deleteConversationFromDify(String conversationId, String user, HospitalWorkflow workflow) {
        try {
            String url = workflow.getDifyApiUrl() + "/conversations/" + conversationId;
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Bearer " + workflow.getDifyApiKey());
            headers.setContentType(MediaType.APPLICATION_JSON);
            StringBuilder urlWithParams = new StringBuilder(url);
            urlWithParams.append("?user=").append(user);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(urlWithParams.toString(), HttpMethod.DELETE, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK || response.getStatusCode() == HttpStatus.NO_CONTENT) {
                logger.info("\u6210\u529f\u5220\u9664Dify\u5bf9\u8bdd: conversationId={}, user={}", (Object)conversationId, (Object)user);
                return true;
            }
            logger.warn("\u5220\u9664Dify\u5bf9\u8bdd\u5931\u8d25: HTTP {}, conversationId={}", (Object)response.getStatusCode(), (Object)conversationId);
            return false;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528Dify API\u5220\u9664\u5bf9\u8bdd\u5931\u8d25: conversationId={}, user={}", new Object[]{conversationId, user, e});
            return false;
        }
    }

    private void streamChatRequest(DifyChatRequest request, HospitalWorkflow workflow, SseEmitter emitter, WebSocketSession session, Long sessionId) throws Exception {
        String url = workflow.getDifyApiUrl() + "/chat-messages";
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Authorization", "Bearer " + workflow.getDifyApiKey());
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("inputs", new HashMap());
        requestBody.put("query", request.getQuery());
        requestBody.put("response_mode", "streaming");
        if (request.getConversationId() != null && !request.getConversationId().trim().isEmpty()) {
            requestBody.put("conversation_id", request.getConversationId());
        }
        requestBody.put("user", request.getUser());
        if (request.getFiles() != null && !request.getFiles().isEmpty()) {
            requestBody.put("files", request.getFiles());
        }
        String jsonBody = this.objectMapper.writeValueAsString(requestBody);
        connection.getOutputStream().write(jsonBody.getBytes(StandardCharsets.UTF_8));
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            String errorResponse = "";
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder errorBuilder = new StringBuilder();
                while ((line = errorReader.readLine()) != null) {
                    errorBuilder.append(line);
                }
                errorResponse = errorBuilder.toString();
            }
            catch (Exception e) {
                errorResponse = "\u65e0\u6cd5\u8bfb\u53d6\u9519\u8bef\u8be6\u60c5";
            }
            String errorMsg = String.format("Dify API\u8bf7\u6c42\u5931\u8d25: HTTP %d, URL: %s, \u54cd\u5e94: %s", responseCode, url, errorResponse);
            logger.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            int messageCount = 0;
            boolean conversationIdUpdated = false;
            logger.info("\u5f00\u59cb\u8bfb\u53d6Dify\u6d41\u5f0f\u54cd\u5e94");
            while ((line = reader.readLine()) != null) {
                int dataSize;
                String data;
                block55: {
                    if (!line.startsWith("data: ")) continue;
                    data = line.substring(6);
                    if ("[DONE]".equals(data.trim())) {
                        logger.info("Dify\u6d41\u5f0f\u54cd\u5e94\u7ed3\u675f\uff0c\u5171\u5904\u7406{}\u6761\u6d88\u606f", (Object)messageCount);
                        break;
                    }
                    dataSize = data.getBytes(StandardCharsets.UTF_8).length;
                    logger.info("\u6536\u5230Dify\u54cd\u5e94\u6570\u636e #{}: \u957f\u5ea6={} bytes", (Object)(++messageCount), (Object)dataSize);
                    if (dataSize > 8192) {
                        String preview = data.length() > 200 ? data.substring(0, 200) + "..." : data;
                        logger.warn("\u68c0\u6d4b\u5230\u5927\u6d88\u606f #{}: \u524d200\u5b57\u7b26\u5185\u5bb9={}", (Object)messageCount, (Object)preview);
                    }
                    if (!conversationIdUpdated && sessionId != null && (request.getConversationId() == null || request.getConversationId().trim().isEmpty())) {
                        logger.debug("\u68c0\u67e5conversation_id\u66f4\u65b0\u6761\u4ef6: conversationIdUpdated={}, sessionId={}, requestConversationId={}", new Object[]{conversationIdUpdated, sessionId, request.getConversationId()});
                        try {
                            JsonNode responseJson = this.objectMapper.readTree(data);
                            logger.debug("\u89e3\u6790Dify\u54cd\u5e94JSON\u6210\u529f\uff0c\u68c0\u67e5conversation_id\u5b57\u6bb5");
                            if (responseJson.has("conversation_id")) {
                                String newConversationId = responseJson.get("conversation_id").asText();
                                logger.info("\u4eceDify\u54cd\u5e94\u4e2d\u63d0\u53d6\u5230conversation_id: {}", (Object)newConversationId);
                                if (newConversationId != null && !newConversationId.trim().isEmpty()) {
                                    logger.info("\u68c0\u6d4b\u5230\u65b0\u7684conversation_id: {}, \u5f00\u59cb\u66f4\u65b0sessionId: {}", (Object)newConversationId, (Object)sessionId);
                                    this.patientSessionService.updateDifyConversationId(sessionId, newConversationId);
                                    if (session != null) {
                                        session.getAttributes().put("difyConversationId", newConversationId);
                                        logger.info("WebSocket\u4f1a\u8bdd\u5c5e\u6027\u5df2\u66f4\u65b0: difyConversationId={}", (Object)newConversationId);
                                    }
                                    conversationIdUpdated = true;
                                    logger.info("conversation_id\u66f4\u65b0\u5b8c\u6210: sessionId={}, conversationId={}", (Object)sessionId, (Object)newConversationId);
                                } else {
                                    logger.warn("conversation_id\u4e3a\u7a7a\u6216null: '{}'", (Object)newConversationId);
                                }
                                break block55;
                            }
                            logger.debug("Dify\u54cd\u5e94\u4e2d\u672a\u5305\u542bconversation_id\u5b57\u6bb5\uff0c\u54cd\u5e94\u5185\u5bb9\u524d100\u5b57\u7b26: {}", (Object)(data.length() > 100 ? data.substring(0, 100) : data));
                        }
                        catch (Exception e) {
                            logger.error("\u89e3\u6790conversation_id\u5931\u8d25: sessionId={}, \u54cd\u5e94\u6570\u636e: {}", new Object[]{sessionId, data.length() > 200 ? data.substring(0, 200) + "..." : data, e});
                        }
                    } else if (conversationIdUpdated) {
                        logger.debug("conversation_id\u5df2\u66f4\u65b0\uff0c\u8df3\u8fc7\u68c0\u67e5");
                    } else if (sessionId == null) {
                        logger.warn("sessionId\u4e3anull\uff0c\u65e0\u6cd5\u66f4\u65b0conversation_id");
                    } else if (request.getConversationId() != null && !request.getConversationId().trim().isEmpty()) {
                        logger.debug("\u8bf7\u6c42\u5df2\u5305\u542bconversationId: {}\uff0c\u8df3\u8fc7\u66f4\u65b0", (Object)request.getConversationId());
                    } else {
                        logger.warn("\u672a\u77e5\u539f\u56e0\u8df3\u8fc7conversation_id\u66f4\u65b0: conversationIdUpdated={}, sessionId={}, requestConversationId='{}'", new Object[]{conversationIdUpdated, sessionId, request.getConversationId()});
                    }
                }
                String processedData = DifyResponseProcessor.processDifyResponse((String)data, (int)messageCount);
                int processedSize = processedData.getBytes(StandardCharsets.UTF_8).length;
                if (processedSize != dataSize) {
                    logger.info("Dify\u54cd\u5e94 #{} \u9884\u5904\u7406\u5b8c\u6210: {}bytes -> {}bytes", new Object[]{messageCount, dataSize, processedSize});
                }
                if (emitter != null) {
                    emitter.send(SseEmitter.event().data((Object)processedData));
                }
                if (session != null && session.isOpen()) {
                    boolean sendSuccess = UltraSafeMessageSender.ultraSafeSend((WebSocketSession)session, (String)processedData, (String)("dify_" + messageCount));
                    if (sendSuccess) continue;
                    logger.error("\u6d88\u606f #{} \u53d1\u9001\u5931\u8d25\uff0c\u505c\u6b62\u540e\u7eed\u6d88\u606f\u53d1\u9001", (Object)messageCount);
                    break;
                }
                if (session == null) continue;
                logger.warn("WebSocket\u4f1a\u8bdd\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f #{}", (Object)messageCount);
                break;
            }
            if (emitter != null) {
                emitter.complete();
            }
        }
        catch (Exception e) {
            logger.error("\u6d41\u5f0f\u54cd\u5e94\u5904\u7406\u5931\u8d25", (Throwable)e);
            if (emitter != null) {
                emitter.completeWithError((Throwable)e);
            }
            throw e;
        }
    }

    private String blockingChatRequest(DifyChatRequest request, HospitalWorkflow workflow) throws Exception {
        HttpEntity entity;
        ResponseEntity response;
        String url = workflow.getDifyApiUrl() + "/chat-messages";
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + workflow.getDifyApiKey());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("inputs", new HashMap());
        requestBody.put("query", request.getQuery());
        requestBody.put("response_mode", "blocking");
        if (request.getConversationId() != null && !request.getConversationId().trim().isEmpty()) {
            requestBody.put("conversation_id", request.getConversationId());
        }
        requestBody.put("user", request.getUser());
        if (request.getFiles() != null && !request.getFiles().isEmpty()) {
            requestBody.put("files", request.getFiles());
        }
        if ((response = this.restTemplate.postForEntity(url, (Object)(entity = new HttpEntity(requestBody, (MultiValueMap)headers)), String.class, new Object[0])).getStatusCode() == HttpStatus.OK) {
            JsonNode jsonNode = this.objectMapper.readTree((String)response.getBody());
            return jsonNode.get("answer").asText();
        }
        throw new RuntimeException("Dify API\u8bf7\u6c42\u5931\u8d25: " + response.getStatusCode());
    }

    private void sendErrorMessage(WebSocketSession session, String message) {
        UltraSafeMessageSender.sendError((WebSocketSession)session, (String)message);
    }

    public String getConversationHistoryWithTTS(String conversationId, String user, String hospitalId, String workflowType) {
        try {
            logger.info("\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\u5e76\u5408\u5e76TTS\u7f13\u5b58: conversationId={}, user={}, hospitalId={}, workflowType={}", new Object[]{conversationId, user, hospitalId, workflowType});
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(hospitalId, workflowType);
            if (workflow == null) {
                logger.warn("\u672a\u627e\u5230\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}, workflowType={}", (Object)hospitalId, (Object)workflowType);
                return "{}";
            }
            String historyResponse = this.getConversationHistoryPage(conversationId, user, workflow, null);
            return this.mergeHistoryWithTTS(historyResponse, hospitalId, workflowType);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\u5e76\u5408\u5e76TTS\u7f13\u5b58\u5931\u8d25: conversationId={}, user={}, hospitalId={}, workflowType={}", new Object[]{conversationId, user, hospitalId, workflowType, e});
            return "{}";
        }
    }

    public String getConversationHistoryMoreWithTTS(String conversationId, String user, String firstMessageId, String hospitalId, String workflowType) {
        try {
            logger.info("\u83b7\u53d6\u66f4\u591a\u5bf9\u8bdd\u5386\u53f2\u5e76\u5408\u5e76TTS\u7f13\u5b58: conversationId={}, user={}, firstMessageId={}, hospitalId={}, workflowType={}", new Object[]{conversationId, user, firstMessageId, hospitalId, workflowType});
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(hospitalId, workflowType);
            if (workflow == null) {
                logger.warn("\u672a\u627e\u5230\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}, workflowType={}", (Object)hospitalId, (Object)workflowType);
                return "{}";
            }
            String historyResponse = this.getConversationHistoryPage(conversationId, user, workflow, firstMessageId);
            return this.mergeHistoryWithTTS(historyResponse, hospitalId, workflowType);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u66f4\u591a\u5bf9\u8bdd\u5386\u53f2\u5e76\u5408\u5e76TTS\u7f13\u5b58\u5931\u8d25: conversationId={}, user={}, firstMessageId={}, hospitalId={}, workflowType={}", new Object[]{conversationId, user, firstMessageId, hospitalId, workflowType, e});
            return "{}";
        }
    }

    private String mergeHistoryWithTTS(String historyResponse, String hospitalId, String workflowType) {
        try {
            if (historyResponse == null || "{}".equals(historyResponse)) {
                return historyResponse;
            }
            JsonNode responseJson = this.objectMapper.readTree(historyResponse);
            if (!responseJson.has("data") || !responseJson.get("data").isArray()) {
                return historyResponse;
            }
            JsonNode messagesArray = responseJson.get("data");
            ArrayList<JsonNode> updatedMessages = new ArrayList<JsonNode>();
            for (JsonNode message : messagesArray) {
                JsonNode updatedMessage = message.deepCopy();
                if (message.has("id") && message.has("answer")) {
                    String answerText;
                    String messageId = message.get("id").asText();
                    TTSAudioCache cachedAudio = this.ttsCacheService.findCachedAudio(messageId, answerText = message.get("answer").asText(), hospitalId, workflowType);
                    if (cachedAudio != null) {
                        ((ObjectNode)updatedMessage).put("audioUrl", cachedAudio.getOssUrl());
                        ((ObjectNode)updatedMessage).put("duration", cachedAudio.getDuration());
                        ((ObjectNode)updatedMessage).put("hasAudio", true);
                        logger.debug("\u4e3a\u6d88\u606f {} \u6dfb\u52a0\u97f3\u9891URL: {}, \u65f6\u957f: {}s", new Object[]{messageId, cachedAudio.getOssUrl(), cachedAudio.getDuration()});
                    } else {
                        ((ObjectNode)updatedMessage).put("hasAudio", false);
                    }
                } else {
                    ((ObjectNode)updatedMessage).put("hasAudio", false);
                }
                updatedMessages.add(updatedMessage);
            }
            ObjectNode newResponse = this.objectMapper.createObjectNode();
            newResponse.set("data", this.objectMapper.valueToTree(updatedMessages));
            if (responseJson.has("has_more")) {
                newResponse.put("has_more", responseJson.get("has_more").asBoolean());
            }
            if (responseJson.has("limit")) {
                newResponse.put("limit", responseJson.get("limit").asInt());
            }
            String result = this.objectMapper.writeValueAsString((Object)newResponse);
            logger.info("TTS\u7f13\u5b58\u5408\u5e76\u5b8c\u6210: \u5904\u7406\u4e86 {} \u6761\u6d88\u606f", (Object)updatedMessages.size());
            return result;
        }
        catch (Exception e) {
            logger.error("\u5408\u5e76TTS\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            return historyResponse;
        }
    }
}

