/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.chdu.ai.service.OSSService;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OSSServiceImpl
implements OSSService {
    private static final Logger logger = LoggerFactory.getLogger(OSSServiceImpl.class);
    @Value(value="${aliyun.oss.endpoint:oss-cn-beijing.aliyuncs.com}")
    private String endpoint;
    @Value(value="${aliyun.accessKeyId:}")
    private String accessKeyId;
    @Value(value="${aliyun.accessKeySecret:}")
    private String accessKeySecret;
    @Value(value="${aliyun.oss.bucketName:byh-im-file}")
    private String defaultBucketName;

    public String uploadFile(String bucketName, String objectKey, InputStream inputStream, long contentLength, String contentType) {
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(contentLength);
            metadata.setContentType(contentType);
            metadata.setCacheControl("public, max-age=31536000");
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, objectKey, inputStream, metadata);
            ossClient.putObject(putObjectRequest);
            String fileUrl = this.getFileUrl(bucketName, objectKey);
            logger.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f: bucket={}, objectKey={}, url={}", new Object[]{bucketName, objectKey, fileUrl});
            String string = fileUrl;
            return string;
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: bucket={}, objectKey={}", new Object[]{bucketName, objectKey, e});
            throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: " + e.getMessage());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public InputStream downloadFile(String bucketName, String objectKey) {
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
            InputStream inputStream = ossClient.getObject(bucketName, objectKey).getObjectContent();
            return inputStream;
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25: bucket={}, objectKey={}", new Object[]{bucketName, objectKey, e});
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25: " + e.getMessage());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(String bucketName, String objectKey) {
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
            ossClient.deleteObject(bucketName, objectKey);
            logger.info("\u6587\u4ef6\u5220\u9664\u6210\u529f: bucket={}, objectKey={}", (Object)bucketName, (Object)objectKey);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25: bucket={}, objectKey={}", new Object[]{bucketName, objectKey, e});
            boolean bl = false;
            return bl;
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fileExists(String bucketName, String objectKey) {
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
            boolean bl = ossClient.doesObjectExist(bucketName, objectKey);
            return bl;
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u6587\u4ef6\u5b58\u5728\u6027\u5931\u8d25: bucket={}, objectKey={}", new Object[]{bucketName, objectKey, e});
            boolean bl = false;
            return bl;
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public String getFileUrl(String bucketName, String objectKey) {
        if (this.endpoint.startsWith("http://")) {
            return String.format("http://%s.%s/%s", bucketName, this.endpoint.substring(7), objectKey);
        }
        if (this.endpoint.startsWith("https://")) {
            return String.format("https://%s.%s/%s", bucketName, this.endpoint.substring(8), objectKey);
        }
        return String.format("https://%s.%s/%s", bucketName, this.endpoint, objectKey);
    }

    public String generatePresignedUrl(String bucketName, String objectKey, int expireSeconds) {
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
            Date expiration = new Date(System.currentTimeMillis() + (long)expireSeconds * 1000L);
            URL url = ossClient.generatePresignedUrl(bucketName, objectKey, expiration);
            String string = url.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u9884\u7b7e\u540dURL\u5931\u8d25: bucket={}, objectKey={}", new Object[]{bucketName, objectKey, e});
            throw new RuntimeException("\u751f\u6210\u9884\u7b7e\u540dURL\u5931\u8d25: " + e.getMessage());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public String getDefaultBucketName() {
        return this.defaultBucketName;
    }
}

