/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.config;

import javax.servlet.ServletContext;
import javax.websocket.server.ServerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;

@Component
public class WebSocketConfigValidator
implements CommandLineRunner,
ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketConfigValidator.class);
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void run(String ... args) throws Exception {
        logger.info("\u5f00\u59cb\u9a8c\u8bc1WebSocket\u914d\u7f6e...");
        try {
            if (this.servletContext != null) {
                ServerContainer serverContainer = (ServerContainer)this.servletContext.getAttribute("javax.websocket.server.ServerContainer");
                if (serverContainer != null) {
                    int textBufferSize = serverContainer.getDefaultMaxTextMessageBufferSize();
                    int binaryBufferSize = serverContainer.getDefaultMaxBinaryMessageBufferSize();
                    long sessionTimeout = serverContainer.getDefaultMaxSessionIdleTimeout();
                    logger.info("WebSocket\u914d\u7f6e\u9a8c\u8bc1\u7ed3\u679c:");
                    logger.info("  - \u6587\u672c\u6d88\u606f\u7f13\u51b2\u533a\u5927\u5c0f: {} bytes ({} KB)", (Object)textBufferSize, (Object)(textBufferSize / 1024));
                    logger.info("  - \u4e8c\u8fdb\u5236\u6d88\u606f\u7f13\u51b2\u533a\u5927\u5c0f: {} bytes ({} KB)", (Object)binaryBufferSize, (Object)(binaryBufferSize / 1024));
                    logger.info("  - \u4f1a\u8bdd\u8d85\u65f6\u65f6\u95f4: {} ms ({} \u5206\u949f)", (Object)sessionTimeout, (Object)(sessionTimeout / 60000L));
                    if (textBufferSize >= 0x100000) {
                        logger.info("\u2705 WebSocket\u7f13\u51b2\u533a\u914d\u7f6e\u6b63\u5e38\uff0c\u5e94\u8be5\u80fd\u591f\u5904\u7406\u5927\u6d88\u606f");
                    } else {
                        logger.warn("\u26a0\ufe0f  WebSocket\u7f13\u51b2\u533a\u53ef\u80fd\u8fc7\u5c0f ({}KB)\uff0c\u5efa\u8bae\u589e\u52a0\u5230\u81f3\u5c111MB", (Object)(textBufferSize / 1024));
                        logger.warn("   \u5982\u679c\u4ecd\u7136\u51fa\u73b01009\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5Tomcat\u914d\u7f6e\u6216\u8003\u8651\u4f7f\u7528\u6d88\u606f\u5206\u7247");
                    }
                } else {
                    logger.warn("\u26a0\ufe0f  \u65e0\u6cd5\u83b7\u53d6ServerContainer\uff0cWebSocket\u914d\u7f6e\u9a8c\u8bc1\u5931\u8d25");
                    logger.warn("   \u8fd9\u53ef\u80fd\u610f\u5473\u7740WebSocket\u914d\u7f6e\u6ca1\u6709\u6b63\u786e\u52a0\u8f7d");
                }
            } else {
                logger.warn("\u26a0\ufe0f  ServletContext\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u9a8c\u8bc1WebSocket\u914d\u7f6e");
            }
        }
        catch (Exception e) {
            logger.error("WebSocket\u914d\u7f6e\u9a8c\u8bc1\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        logger.info("WebSocket\u914d\u7f6e\u9a8c\u8bc1\u5b8c\u6210");
    }
}

