/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.model.BatchOperationRequest;
import com.chdu.ai.model.BatchSegmentRequest;
import com.chdu.ai.model.DifyChildChunk;
import com.chdu.ai.model.DifyDocument;
import com.chdu.ai.model.DifyDocumentRequest;
import com.chdu.ai.model.DifySegment;
import com.chdu.ai.model.DocumentSearchRequest;
import com.chdu.ai.model.HospitalWorkflow;
import com.chdu.ai.model.SegmentRequest;
import com.chdu.ai.model.SegmentSearchRequest;
import com.chdu.ai.service.DifyKnowledgeService;
import com.chdu.ai.service.HospitalWorkflowService;
import com.chdu.ai.service.impl.DifyKnowledgeServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DifyKnowledgeServiceImpl
implements DifyKnowledgeService {
    private static final Logger logger = LoggerFactory.getLogger(DifyKnowledgeServiceImpl.class);
    @Autowired
    private HospitalWorkflowService hospitalWorkflowService;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public DifyKnowledgeServiceImpl() {
        this.restTemplate = new RestTemplate();
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
    }

    public DifyDocument uploadDocument(DifyDocumentRequest request, String hospitalId, String uploadedBy, String workflowType) {
        logger.info("\u4e0a\u4f20\u6587\u6863: hospitalId={}, uploadedBy={}", (Object)hospitalId, (Object)uploadedBy);
        try {
            this.validateUploadDocumentRequest(request, hospitalId, uploadedBy);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/document/create-by-file";
            HttpHeaders headers = this.createMultipartHeaders(workflow);
            MultiValueMap requestBody = this.buildUploadDocumentRequestBody(request);
            HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                DifyDocument document = this.parseDocumentFromResponse(jsonResponse, uploadedBy);
                logger.info("\u4e0a\u4f20\u6587\u6863\u6210\u529f: id={}, name={}", (Object)document.getId(), (Object)document.getName());
                return document;
            }
            logger.error("\u4e0a\u4f20\u6587\u6863\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("\u4e0a\u4f20\u6587\u6863\u5931\u8d25: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u6863\u5f02\u5e38: hospitalId={}", (Object)hospitalId, (Object)e);
            throw new RuntimeException("\u4e0a\u4f20\u6587\u6863\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public List<DifyDocument> getDocuments(String hospitalId, int page, int limit, String workflowType) {
        logger.info("\u83b7\u53d6\u6587\u6863\u5217\u8868: hospitalId={}, page={}, limit={}", new Object[]{hospitalId, page, limit});
        try {
            this.validatePaginationParams(page, limit);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents?page=" + page + "&limit=" + limit;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                List documents = this.parseDocumentListFromResponse(jsonResponse);
                logger.info("\u83b7\u53d6\u6587\u6863\u5217\u8868\u6210\u529f: hospitalId={}, count={}", (Object)hospitalId, (Object)documents.size());
                return documents;
            }
            logger.error("\u83b7\u53d6\u6587\u6863\u5217\u8868\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            return new ArrayList<DifyDocument>();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u6863\u5217\u8868\u5f02\u5e38: hospitalId={}", (Object)hospitalId, (Object)e);
            return new ArrayList<DifyDocument>();
        }
    }

    public DifyDocument getDocumentById(String documentId, String hospitalId, String workflowType) {
        logger.info("\u83b7\u53d6\u6587\u6863\u8be6\u60c5: documentId={}, hospitalId={}", (Object)documentId, (Object)hospitalId);
        try {
            this.validateDocumentId(documentId);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/" + documentId;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                DifyDocument document = this.parseDocumentFromResponse(jsonResponse, null);
                logger.info("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u6210\u529f: id={}, name={}", (Object)document.getId(), (Object)document.getName());
                return document;
            }
            logger.error("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            return null;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u5f02\u5e38: documentId={}, hospitalId={}", new Object[]{documentId, hospitalId, e});
            return null;
        }
    }

    public DifyDocument updateDocument(String documentId, DifyDocumentRequest request, String hospitalId, String updatedBy, String workflowType) {
        logger.info("\u66f4\u65b0\u6587\u6863: documentId={}, hospitalId={}, updatedBy={}", new Object[]{documentId, hospitalId, updatedBy});
        try {
            this.validateDocumentId(documentId);
            this.validateUpdateDocumentRequest(request, hospitalId, updatedBy);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/" + documentId + "/update_by_file";
            HttpHeaders headers = this.createMultipartHeaders(workflow);
            MultiValueMap requestBody = this.buildUpdateDocumentRequestBody(request);
            HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                DifyDocument document = this.parseDocumentFromResponse(jsonResponse, updatedBy);
                logger.info("\u66f4\u65b0\u6587\u6863\u6210\u529f: id={}, name={}", (Object)document.getId(), (Object)document.getName());
                return document;
            }
            logger.error("\u66f4\u65b0\u6587\u6863\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("\u66f4\u65b0\u6587\u6863\u5931\u8d25: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6587\u6863\u5f02\u5e38: documentId={}, hospitalId={}", new Object[]{documentId, hospitalId, e});
            throw new RuntimeException("\u66f4\u65b0\u6587\u6863\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public boolean deleteDocument(String documentId, String hospitalId, String workflowType) {
        logger.info("\u5220\u9664\u6587\u6863: documentId={}, hospitalId={}", (Object)documentId, (Object)hospitalId);
        try {
            boolean success;
            this.validateDocumentId(documentId);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/" + documentId;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.DELETE, entity, String.class, new Object[0]);
            boolean bl = success = response.getStatusCode() == HttpStatus.OK;
            if (success) {
                logger.info("\u5220\u9664\u6587\u6863\u6210\u529f: documentId={}", (Object)documentId);
            } else {
                logger.error("\u5220\u9664\u6587\u6863\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            }
            return success;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6587\u6863\u5f02\u5e38: documentId={}, hospitalId={}", new Object[]{documentId, hospitalId, e});
            return false;
        }
    }

    public boolean toggleDocumentStatus(String documentId, boolean enabled, String hospitalId, String operatedBy, String workflowType) {
        logger.info("\u5207\u6362\u6587\u6863\u72b6\u6001: documentId={}, enabled={}, hospitalId={}, operatedBy={}", new Object[]{documentId, enabled, hospitalId, operatedBy});
        try {
            this.validateDocumentId(documentId);
            String action = enabled ? "enable" : "disable";
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/status/" + action;
            HttpHeaders headers = this.createHeaders(workflow);
            HashMap<String, List<String>> requestBody = new HashMap<String, List<String>>();
            requestBody.put("document_ids", Arrays.asList(documentId));
            HttpEntity entity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PATCH, entity, String.class, new Object[0]);
            boolean success = response.getStatusCode().is2xxSuccessful();
            if (success) {
                logger.info("\u5207\u6362\u6587\u6863\u72b6\u6001\u6210\u529f: documentId={}, enabled={}", (Object)documentId, (Object)enabled);
            } else {
                logger.error("\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            }
            return success;
        }
        catch (Exception e) {
            logger.error("\u5207\u6362\u6587\u6863\u72b6\u6001\u5f02\u5e38: documentId={}, hospitalId={}", new Object[]{documentId, hospitalId, e});
            return false;
        }
    }

    public Map<String, Object> retrieveKnowledge(String query, int topK, double scoreThreshold, String hospitalId, String workflowType) {
        logger.info("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9: query={}, topK={}, scoreThreshold={}, hospitalId={}", new Object[]{query, topK, scoreThreshold, hospitalId});
        try {
            this.validateRetrieveKnowledgeParams(query, topK, scoreThreshold);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/retrieve";
            HttpHeaders headers = this.createHeaders(workflow);
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("query", query);
            HashMap<String, Number> retrievalSetting = new HashMap<String, Number>();
            retrievalSetting.put("top_k", topK);
            retrievalSetting.put("score_threshold", scoreThreshold);
            requestBody.put("retrieval_setting", retrievalSetting);
            HttpEntity entity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                Map result = (Map)this.objectMapper.convertValue((Object)jsonResponse, Map.class);
                logger.info("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u6210\u529f: hospitalId={}, resultCount={}", (Object)hospitalId, (Object)(jsonResponse.get("query_result") != null ? jsonResponse.get("query_result").size() : 0));
                return result;
            }
            logger.error("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            return new HashMap<String, Object>();
        }
        catch (Exception e) {
            logger.error("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u5f02\u5e38: query={}, hospitalId={}", new Object[]{query, hospitalId, e});
            return new HashMap<String, Object>();
        }
    }

    public Map<String, Object> getDocumentStatus(String documentId, String hospitalId, String workflowType) {
        logger.info("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001: documentId={}, hospitalId={}", (Object)documentId, (Object)hospitalId);
        try {
            this.validateDocumentId(documentId);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/" + documentId;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                Map status = (Map)this.objectMapper.convertValue((Object)jsonResponse, Map.class);
                logger.info("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u6210\u529f: documentId={}, status={}", (Object)documentId, (Object)jsonResponse.get("indexing_status"));
                return status;
            }
            logger.error("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            return new HashMap<String, Object>();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u5f02\u5e38: documentId={}, hospitalId={}", new Object[]{documentId, hospitalId, e});
            return new HashMap<String, Object>();
        }
    }

    public boolean reindexDocument(String documentId, String hospitalId, String operatedBy, String workflowType) {
        logger.info("\u91cd\u65b0\u7d22\u5f15\u6587\u6863: documentId={}, hospitalId={}, operatedBy={}", new Object[]{documentId, hospitalId, operatedBy});
        try {
            boolean success;
            this.validateDocumentId(documentId);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/" + documentId + "/processing";
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            boolean bl = success = response.getStatusCode() == HttpStatus.OK;
            if (success) {
                logger.info("\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u6210\u529f: documentId={}", (Object)documentId);
            } else {
                logger.error("\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            }
            return success;
        }
        catch (Exception e) {
            logger.error("\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u5f02\u5e38: documentId={}, hospitalId={}", new Object[]{documentId, hospitalId, e});
            return false;
        }
    }

    private HospitalWorkflow getWorkflowConfig(String hospitalId, String workflowType) {
        if (hospitalId == null || hospitalId.trim().isEmpty()) {
            throw new IllegalArgumentException("hospitalId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (workflowType == null || workflowType.trim().isEmpty()) {
            throw new IllegalArgumentException("workflowType \u4e0d\u80fd\u4e3a\u7a7a");
        }
        HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(hospitalId, workflowType);
        if (workflow != null) {
            logger.debug("\u4f7f\u7528\u6307\u5b9a\u5de5\u4f5c\u6d41: hospitalId={}, workflowType={}", (Object)hospitalId, (Object)workflowType);
            return workflow;
        }
        workflow = this.hospitalWorkflowService.getWorkflowByHospitalId(hospitalId);
        if (workflow == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId=" + hospitalId);
        }
        logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u5de5\u4f5c\u6d41: hospitalId={}, workflowType={}", (Object)hospitalId, (Object)workflow.getWorkflowType());
        return workflow;
    }

    private String getApiUrl(HospitalWorkflow workflow) {
        if (workflow == null || workflow.getDifyApiUrl() == null) {
            throw new RuntimeException("\u5de5\u4f5c\u6d41\u914d\u7f6e\u4e2d\u7f3a\u5c11 Dify API URL");
        }
        return workflow.getDifyApiUrl();
    }

    private String getApiKey(HospitalWorkflow workflow) {
        if (workflow == null || workflow.getDifyApiKey() == null) {
            throw new RuntimeException("\u5de5\u4f5c\u6d41\u914d\u7f6e\u4e2d\u7f3a\u5c11 Dify API Key");
        }
        return workflow.getDifyApiKey();
    }

    private HttpHeaders createHeaders(HospitalWorkflow workflow) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.getApiKey(workflow));
        return headers;
    }

    private HttpHeaders createMultipartHeaders(HospitalWorkflow workflow) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.set("Authorization", "Bearer " + this.getApiKey(workflow));
        return headers;
    }

    private void validateUploadDocumentRequest(DifyDocumentRequest request, String hospitalId, String uploadedBy) {
        if (request == null) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u6587\u6863\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getFile() == null || request.getFile().isEmpty()) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)hospitalId)) {
            throw new IllegalArgumentException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)uploadedBy)) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateUpdateDocumentRequest(DifyDocumentRequest request, String hospitalId, String updatedBy) {
        if (request == null) {
            throw new IllegalArgumentException("\u66f4\u65b0\u6587\u6863\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)hospitalId)) {
            throw new IllegalArgumentException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)updatedBy)) {
            throw new IllegalArgumentException("\u66f4\u65b0\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateDocumentId(String documentId) {
        if (!StringUtils.hasText((String)documentId)) {
            throw new IllegalArgumentException("\u6587\u6863ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validatePaginationParams(int page, int limit) {
        if (page < 1) {
            throw new IllegalArgumentException("\u9875\u7801\u5fc5\u987b\u5927\u4e8e0");
        }
        if (limit < 1 || limit > 100) {
            throw new IllegalArgumentException("\u6bcf\u9875\u6570\u91cf\u5fc5\u987b\u57281-100\u4e4b\u95f4");
        }
    }

    private void validateRetrieveKnowledgeParams(String query, int topK, double scoreThreshold) {
        if (!StringUtils.hasText((String)query)) {
            throw new IllegalArgumentException("\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (topK < 1 || topK > 50) {
            throw new IllegalArgumentException("\u8fd4\u56de\u7ed3\u679c\u6570\u91cf\u5fc5\u987b\u57281-50\u4e4b\u95f4");
        }
        if (scoreThreshold < 0.0 || scoreThreshold > 1.0) {
            throw new IllegalArgumentException("\u76f8\u4f3c\u5ea6\u9608\u503c\u5fc5\u987b\u57280.0-1.0\u4e4b\u95f4");
        }
    }

    private MultiValueMap<String, Object> buildUploadDocumentRequestBody(DifyDocumentRequest request) throws Exception {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        MultipartFile file = request.getFile();
        1 fileResource = new /* Unavailable Anonymous Inner Class!! */;
        requestBody.add((Object)"file", (Object)fileResource);
        if (StringUtils.hasText((String)request.getIndexingTechnique())) {
            requestBody.add((Object)"indexing_technique", (Object)request.getIndexingTechnique());
        }
        if (StringUtils.hasText((String)request.getProcessRule())) {
            requestBody.add((Object)"process_rule", (Object)request.getProcessRule());
        }
        if (StringUtils.hasText((String)request.getDuplicateCheck())) {
            requestBody.add((Object)"duplicate_check", (Object)request.getDuplicateCheck());
        }
        if (request.getMaxTokens() != null || request.getChunkOverlap() != null || StringUtils.hasText((String)request.getSeparator())) {
            HashMap<String, Object> rules = new HashMap<String, Object>();
            if (request.getMaxTokens() != null) {
                rules.put("max_tokens", request.getMaxTokens());
            }
            if (request.getChunkOverlap() != null) {
                rules.put("chunk_overlap", request.getChunkOverlap());
            }
            if (StringUtils.hasText((String)request.getSeparator())) {
                rules.put("separator", request.getSeparator());
            }
            requestBody.add((Object)"rules", (Object)this.objectMapper.writeValueAsString(rules));
        }
        return requestBody;
    }

    private MultiValueMap<String, Object> buildUpdateDocumentRequestBody(DifyDocumentRequest request) throws Exception {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        if (request.getFile() != null && !request.getFile().isEmpty()) {
            MultipartFile file = request.getFile();
            2 fileResource = new /* Unavailable Anonymous Inner Class!! */;
            requestBody.add((Object)"file", (Object)fileResource);
        }
        if (StringUtils.hasText((String)request.getIndexingTechnique())) {
            requestBody.add((Object)"indexing_technique", (Object)request.getIndexingTechnique());
        }
        if (StringUtils.hasText((String)request.getProcessRule())) {
            requestBody.add((Object)"process_rule", (Object)request.getProcessRule());
        }
        return requestBody;
    }

    private DifyDocument parseDocumentFromResponse(JsonNode jsonResponse, String operatedBy) {
        long timestamp;
        DifyDocument document = new DifyDocument();
        if (jsonResponse.has("id")) {
            document.setId(jsonResponse.get("id").asText());
        }
        if (jsonResponse.has("name")) {
            document.setName(jsonResponse.get("name").asText());
        }
        if (jsonResponse.has("file_name")) {
            document.setFileName(jsonResponse.get("file_name").asText());
        }
        if (jsonResponse.has("data_source_type")) {
            document.setDataSourceType(jsonResponse.get("data_source_type").asText());
        }
        if (jsonResponse.has("data_source_info")) {
            document.setDataSourceInfo(jsonResponse.get("data_source_info").toString());
        }
        if (jsonResponse.has("position")) {
            document.setPosition(Integer.valueOf(jsonResponse.get("position").asInt()));
        }
        if (jsonResponse.has("indexing_status")) {
            document.setStatus(jsonResponse.get("indexing_status").asText());
        }
        if (jsonResponse.has("error")) {
            document.setError(jsonResponse.get("error").asText());
        }
        if (jsonResponse.has("enabled")) {
            document.setEnabled(Boolean.valueOf(jsonResponse.get("enabled").asBoolean()));
        }
        if (jsonResponse.has("archived")) {
            document.setArchived(Boolean.valueOf(jsonResponse.get("archived").asBoolean()));
        }
        if (jsonResponse.has("word_count")) {
            document.setWordCount(Integer.valueOf(jsonResponse.get("word_count").asInt()));
        }
        if (jsonResponse.has("token_count")) {
            document.setTokenCount(Integer.valueOf(jsonResponse.get("token_count").asInt()));
        }
        if (jsonResponse.has("indexing_latency")) {
            document.setIndexingLatency(jsonResponse.get("indexing_latency").asText());
        }
        if (jsonResponse.has("created_at")) {
            try {
                timestamp = jsonResponse.get("created_at").asLong();
                document.setCreatedAt(new Date(timestamp * 1000L));
            }
            catch (Exception e) {
                logger.warn("\u89e3\u6790\u521b\u5efa\u65f6\u95f4\u5931\u8d25", (Throwable)e);
            }
        }
        if (jsonResponse.has("updated_at")) {
            try {
                timestamp = jsonResponse.get("updated_at").asLong();
                document.setUpdatedAt(new Date(timestamp * 1000L));
            }
            catch (Exception e) {
                logger.warn("\u89e3\u6790\u66f4\u65b0\u65f6\u95f4\u5931\u8d25", (Throwable)e);
            }
        }
        if (operatedBy != null) {
            document.setCreatedBy(operatedBy);
            document.setUpdatedBy(operatedBy);
        }
        return document;
    }

    private List<DifyDocument> parseDocumentListFromResponse(JsonNode jsonResponse) {
        ArrayList<DifyDocument> documents = new ArrayList<DifyDocument>();
        if (jsonResponse.has("data") && jsonResponse.get("data").isArray()) {
            for (JsonNode documentNode : jsonResponse.get("data")) {
                DifyDocument document = this.parseDocumentFromResponse(documentNode, null);
                documents.add(document);
            }
        }
        return documents;
    }

    public List<DifyDocument> searchDocuments(DocumentSearchRequest request, String workflowType) {
        logger.info("\u9ad8\u7ea7\u6587\u6863\u641c\u7d22: {}", (Object)request);
        try {
            List allDocuments = this.getDocuments(request.getHospitalId(), 1, 200, workflowType);
            List filteredDocuments = this.filterDocuments(allDocuments, request);
            this.sortDocuments(filteredDocuments, request.getSortBy(), request.getSortOrder());
            int startIndex = (request.getPage() - 1) * request.getLimit();
            int endIndex = Math.min(startIndex + request.getLimit(), filteredDocuments.size());
            if (startIndex >= filteredDocuments.size()) {
                return new ArrayList<DifyDocument>();
            }
            return filteredDocuments.subList(startIndex, endIndex);
        }
        catch (Exception e) {
            logger.error("\u9ad8\u7ea7\u6587\u6863\u641c\u7d22\u5931\u8d25: {}", (Object)request, (Object)e);
            throw new RuntimeException("\u9ad8\u7ea7\u6587\u6863\u641c\u7d22\u5931\u8d25: " + e.getMessage());
        }
    }

    public Map<String, Object> batchDeleteDocuments(BatchOperationRequest request, String workflowType) {
        logger.info("\u6279\u91cf\u5220\u9664\u6587\u6863: {}", (Object)request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> successIds = new ArrayList<String>();
        ArrayList<String> failedIds = new ArrayList<String>();
        HashMap<String, String> errors = new HashMap<String, String>();
        try {
            for (String documentId : request.getDocumentIds()) {
                try {
                    boolean success = this.deleteDocument(documentId, request.getHospitalId(), workflowType);
                    if (success) {
                        successIds.add(documentId);
                        continue;
                    }
                    failedIds.add(documentId);
                    errors.put(documentId, "\u5220\u9664\u5931\u8d25");
                }
                catch (Exception e) {
                    failedIds.add(documentId);
                    errors.put(documentId, e.getMessage());
                    logger.error("\u5220\u9664\u6587\u6863\u5931\u8d25: documentId={}", (Object)documentId, (Object)e);
                }
            }
            result.put("total", request.getDocumentIds().size());
            result.put("success", successIds.size());
            result.put("failed", failedIds.size());
            result.put("successIds", successIds);
            result.put("failedIds", failedIds);
            result.put("errors", errors);
            logger.info("\u6279\u91cf\u5220\u9664\u6587\u6863\u5b8c\u6210: \u603b\u6570={}, \u6210\u529f={}, \u5931\u8d25={}", new Object[]{request.getDocumentIds().size(), successIds.size(), failedIds.size()});
            return result;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5220\u9664\u6587\u6863\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u6279\u91cf\u5220\u9664\u6587\u6863\u5931\u8d25: " + e.getMessage());
        }
    }

    public Map<String, Object> batchToggleDocuments(BatchOperationRequest request, String workflowType) {
        logger.info("\u6279\u91cf\u5207\u6362\u6587\u6863\u72b6\u6001: {}", (Object)request);
        try {
            HospitalWorkflow workflow = this.getWorkflowConfig(request.getHospitalId(), workflowType);
            String datasetId = this.getDatasetId(workflow);
            String action = request.getEnabled() != false ? "enable" : "disable";
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/status/" + action;
            HttpHeaders headers = this.createHeaders(workflow);
            HashMap<String, List> requestBody = new HashMap<String, List>();
            requestBody.put("document_ids", request.getDocumentIds());
            HttpEntity entity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PATCH, entity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("total", request.getDocumentIds().size());
                result.put("success", request.getDocumentIds().size());
                result.put("failed", 0);
                result.put("successIds", request.getDocumentIds());
                result.put("failedIds", new ArrayList());
                result.put("errors", new HashMap());
                result.put("enabled", request.getEnabled());
                logger.info("\u6279\u91cf\u5207\u6362\u6587\u6863\u72b6\u6001\u6210\u529f: \u603b\u6570={}, \u72b6\u6001={}", (Object)request.getDocumentIds().size(), (Object)request.getEnabled());
                return result;
            }
            throw new RuntimeException("\u6279\u91cf\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25\uff0cHTTP\u72b6\u6001\u7801: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u6279\u91cf\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25: " + e.getMessage());
        }
    }

    public Map<String, Object> getKnowledgeStatistics(String hospitalId, String workflowType) {
        logger.info("\u83b7\u53d6\u77e5\u8bc6\u5e93\u7edf\u8ba1\u4fe1\u606f: hospitalId={}", (Object)hospitalId);
        try {
            HashMap<String, Object> statistics = new HashMap<String, Object>();
            List documents = this.getDocuments(hospitalId, 1, 200, workflowType);
            int totalDocumentCount = documents.size();
            int totalWordCount = 0;
            HashMap<String, Integer> statusCount = new HashMap<String, Integer>();
            statusCount.put("queuing", 0);
            statusCount.put("indexing", 0);
            statusCount.put("completed", 0);
            statusCount.put("error", 0);
            statusCount.put("paused", 0);
            for (DifyDocument document : documents) {
                String status = document.getStatus();
                if (status != null && statusCount.containsKey(status)) {
                    statusCount.put(status, (Integer)statusCount.get(status) + 1);
                }
                if (document.getWordCount() == null) continue;
                totalWordCount += document.getWordCount().intValue();
            }
            statistics.put("totalDatasets", 0);
            statistics.put("totalDocuments", totalDocumentCount);
            statistics.put("totalWordCount", totalWordCount);
            statistics.put("documentStatusCount", statusCount);
            statistics.put("hospitalId", hospitalId);
            statistics.put("timestamp", System.currentTimeMillis());
            int totalProcessed = (Integer)statusCount.get("completed") + (Integer)statusCount.get("error");
            double processingProgress = totalDocumentCount > 0 ? (double)totalProcessed / (double)totalDocumentCount * 100.0 : 100.0;
            statistics.put("processingProgress", (double)Math.round(processingProgress * 100.0) / 100.0);
            return statistics;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u77e5\u8bc6\u5e93\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25: hospitalId={}", (Object)hospitalId, (Object)e);
            throw new RuntimeException("\u83b7\u53d6\u77e5\u8bc6\u5e93\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25: " + e.getMessage());
        }
    }

    private List<DifyDocument> filterDocuments(List<DifyDocument> documents, DocumentSearchRequest request) {
        ArrayList<DifyDocument> filtered = new ArrayList<DifyDocument>();
        for (DifyDocument document : documents) {
            boolean matches = true;
            if (request.getKeyword() != null && !request.getKeyword().trim().isEmpty()) {
                String keyword = request.getKeyword().toLowerCase();
                boolean keywordMatch = false;
                if (document.getName() != null && document.getName().toLowerCase().contains(keyword)) {
                    keywordMatch = true;
                }
                if (document.getFileName() != null && document.getFileName().toLowerCase().contains(keyword)) {
                    keywordMatch = true;
                }
                if (!keywordMatch) {
                    matches = false;
                }
            }
            if (request.getStatuses() != null && !request.getStatuses().isEmpty() && !request.getStatuses().contains(document.getStatus())) {
                matches = false;
            }
            if (request.getDataSourceTypes() != null && !request.getDataSourceTypes().isEmpty() && !request.getDataSourceTypes().contains(document.getDataSourceType())) {
                matches = false;
            }
            if (request.getEnabled() != null && !request.getEnabled().equals(document.getEnabled())) {
                matches = false;
            }
            if (request.getArchived() != null && !request.getArchived().equals(document.getArchived())) {
                matches = false;
            }
            if (request.getCreatedBy() != null && !request.getCreatedBy().trim().isEmpty() && !request.getCreatedBy().equals(document.getCreatedBy())) {
                matches = false;
            }
            if (!matches) continue;
            filtered.add(document);
        }
        return filtered;
    }

    private void sortDocuments(List<DifyDocument> documents, String sortBy, String sortOrder) {
        String finalSortBy = sortBy == null || sortBy.trim().isEmpty() ? "created_at" : sortBy;
        String finalSortOrder = sortOrder == null || sortOrder.trim().isEmpty() ? "desc" : sortOrder;
        boolean ascending = "asc".equalsIgnoreCase(finalSortOrder);
        documents.sort((d1, d2) -> {
            int result = 0;
            switch (finalSortBy.toLowerCase()) {
                case "name": {
                    result = this.compareStrings(d1.getName(), d2.getName());
                    break;
                }
                case "updated_at": {
                    result = this.compareDates(d1.getUpdatedAt(), d2.getUpdatedAt());
                    break;
                }
                case "word_count": {
                    result = this.compareIntegers(d1.getWordCount(), d2.getWordCount());
                    break;
                }
                default: {
                    result = this.compareDates(d1.getCreatedAt(), d2.getCreatedAt());
                }
            }
            return ascending ? result : -result;
        });
    }

    private int compareStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    private int compareDates(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return 0;
        }
        if (d1 == null) {
            return -1;
        }
        if (d2 == null) {
            return 1;
        }
        return d1.compareTo(d2);
    }

    private int compareIntegers(Integer i1, Integer i2) {
        if (i1 == null && i2 == null) {
            return 0;
        }
        if (i1 == null) {
            return -1;
        }
        if (i2 == null) {
            return 1;
        }
        return i1.compareTo(i2);
    }

    public List<DifySegment> addDocumentSegments(String documentId, BatchSegmentRequest request, String hospitalId, String workflowType) {
        logger.info("\u65b0\u589e\u6587\u6863\u5206\u6bb5: documentId={}, hospitalId={}, segmentCount={}", new Object[]{documentId, hospitalId, request.getSegments().size()});
        try {
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/" + documentId + "/segments";
            HttpHeaders headers = this.createHeaders(workflow);
            HashMap<String, List> requestBody = new HashMap<String, List>();
            requestBody.put("segments", request.getSegments());
            HttpEntity entity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                List segments = this.parseSegmentListFromResponse(jsonResponse);
                logger.info("\u65b0\u589e\u6587\u6863\u5206\u6bb5\u6210\u529f: documentId={}, segmentCount={}", (Object)documentId, (Object)segments.size());
                return segments;
            }
            throw new RuntimeException("\u65b0\u589e\u6587\u6863\u5206\u6bb5\u5931\u8d25\uff0cHTTP\u72b6\u6001\u7801: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6587\u6863\u5206\u6bb5\u5f02\u5e38: documentId={}, hospitalId={}", new Object[]{documentId, hospitalId, e});
            throw new RuntimeException("\u65b0\u589e\u6587\u6863\u5206\u6bb5\u5931\u8d25: " + e.getMessage());
        }
    }

    public List<DifySegment> getDocumentSegments(SegmentSearchRequest request) {
        logger.info("\u67e5\u8be2\u6587\u6863\u5206\u6bb5\u5217\u8868: {}", (Object)request);
        try {
            HospitalWorkflow workflow = this.getWorkflowConfig(request.getHospitalId(), request.getWorkflowType());
            String datasetId = this.getDatasetId(workflow);
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(this.getApiUrl(workflow)).append("/datasets/").append(datasetId).append("/documents/").append(request.getDocumentId()).append("/segments");
            ArrayList<String> params = new ArrayList<String>();
            if (request.getKeyword() != null && !request.getKeyword().trim().isEmpty()) {
                params.add("keyword=" + request.getKeyword());
            }
            if (request.getStatus() != null && !request.getStatus().trim().isEmpty()) {
                params.add("status=" + request.getStatus());
            }
            params.add("page=" + request.getPage());
            params.add("limit=" + request.getLimit());
            if (!params.isEmpty()) {
                urlBuilder.append("?").append(String.join((CharSequence)"&", params));
            }
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(urlBuilder.toString(), HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                List segments = this.parseSegmentListFromResponse(jsonResponse);
                logger.info("\u67e5\u8be2\u6587\u6863\u5206\u6bb5\u5217\u8868\u6210\u529f: documentId={}, segmentCount={}", (Object)request.getDocumentId(), (Object)segments.size());
                return segments;
            }
            throw new RuntimeException("\u67e5\u8be2\u6587\u6863\u5206\u6bb5\u5217\u8868\u5931\u8d25\uff0cHTTP\u72b6\u6001\u7801: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6587\u6863\u5206\u6bb5\u5217\u8868\u5f02\u5e38: {}", (Object)request, (Object)e);
            throw new RuntimeException("\u67e5\u8be2\u6587\u6863\u5206\u6bb5\u5217\u8868\u5931\u8d25: " + e.getMessage());
        }
    }

    public DifySegment getSegmentDetail(String documentId, String segmentId, String hospitalId, String workflowType) {
        logger.info("\u83b7\u53d6\u5206\u6bb5\u8be6\u60c5: documentId={}, segmentId={}, hospitalId={}", new Object[]{documentId, segmentId, hospitalId});
        try {
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/" + documentId + "/segments/" + segmentId;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                DifySegment segment = this.parseSegmentFromResponse(jsonResponse.get("data"));
                logger.info("\u83b7\u53d6\u5206\u6bb5\u8be6\u60c5\u6210\u529f: segmentId={}", (Object)segmentId);
                return segment;
            }
            throw new RuntimeException("\u83b7\u53d6\u5206\u6bb5\u8be6\u60c5\u5931\u8d25\uff0cHTTP\u72b6\u6001\u7801: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5206\u6bb5\u8be6\u60c5\u5f02\u5e38: documentId={}, segmentId={}", new Object[]{documentId, segmentId, e});
            throw new RuntimeException("\u83b7\u53d6\u5206\u6bb5\u8be6\u60c5\u5931\u8d25: " + e.getMessage());
        }
    }

    public DifySegment updateDocumentSegment(String documentId, String segmentId, SegmentRequest request, String hospitalId, String workflowType) {
        logger.info("\u66f4\u65b0\u6587\u6863\u5206\u6bb5: documentId={}, segmentId={}, hospitalId={}", new Object[]{documentId, segmentId, hospitalId});
        try {
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/" + documentId + "/segments/" + segmentId;
            HttpHeaders headers = this.createHeaders(workflow);
            HashMap<String, SegmentRequest> requestBody = new HashMap<String, SegmentRequest>();
            requestBody.put("segment", request);
            HttpEntity entity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                DifySegment segment = this.parseSegmentFromResponse(jsonResponse.get("data"));
                logger.info("\u66f4\u65b0\u6587\u6863\u5206\u6bb5\u6210\u529f: segmentId={}", (Object)segmentId);
                return segment;
            }
            throw new RuntimeException("\u66f4\u65b0\u6587\u6863\u5206\u6bb5\u5931\u8d25\uff0cHTTP\u72b6\u6001\u7801: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6587\u6863\u5206\u6bb5\u5f02\u5e38: documentId={}, segmentId={}", new Object[]{documentId, segmentId, e});
            throw new RuntimeException("\u66f4\u65b0\u6587\u6863\u5206\u6bb5\u5931\u8d25: " + e.getMessage());
        }
    }

    public boolean deleteDocumentSegment(String documentId, String segmentId, String hospitalId, String workflowType) {
        logger.info("\u5220\u9664\u6587\u6863\u5206\u6bb5: documentId={}, segmentId={}, hospitalId={}", new Object[]{documentId, segmentId, hospitalId});
        try {
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/" + documentId + "/segments/" + segmentId;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.DELETE, entity, String.class, new Object[0]);
            boolean success = response.getStatusCode().is2xxSuccessful();
            if (success) {
                logger.info("\u5220\u9664\u6587\u6863\u5206\u6bb5\u6210\u529f: segmentId={}", (Object)segmentId);
            } else {
                logger.error("\u5220\u9664\u6587\u6863\u5206\u6bb5\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}", (Object)response.getStatusCode());
            }
            return success;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6587\u6863\u5206\u6bb5\u5f02\u5e38: documentId={}, segmentId={}", new Object[]{documentId, segmentId, e});
            return false;
        }
    }

    public DifyChildChunk addChildChunk(String documentId, String segmentId, String content, String hospitalId, String workflowType) {
        logger.info("\u65b0\u589e\u5b50\u5206\u6bb5: documentId={}, segmentId={}, hospitalId={}", new Object[]{documentId, segmentId, hospitalId});
        try {
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/" + documentId + "/segments/" + segmentId + "/child_chunks";
            HttpHeaders headers = this.createHeaders(workflow);
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("content", content);
            HttpEntity entity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                DifyChildChunk childChunk = this.parseChildChunkFromResponse(jsonResponse.get("data"));
                logger.info("\u65b0\u589e\u5b50\u5206\u6bb5\u6210\u529f: segmentId={}", (Object)segmentId);
                return childChunk;
            }
            throw new RuntimeException("\u65b0\u589e\u5b50\u5206\u6bb5\u5931\u8d25\uff0cHTTP\u72b6\u6001\u7801: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u5b50\u5206\u6bb5\u5f02\u5e38: documentId={}, segmentId={}", new Object[]{documentId, segmentId, e});
            throw new RuntimeException("\u65b0\u589e\u5b50\u5206\u6bb5\u5931\u8d25: " + e.getMessage());
        }
    }

    public List<DifyChildChunk> getChildChunks(String documentId, String segmentId, String keyword, Integer page, Integer limit, String hospitalId, String workflowType) {
        logger.info("\u67e5\u8be2\u5b50\u5206\u6bb5\u5217\u8868: documentId={}, segmentId={}, hospitalId={}", new Object[]{documentId, segmentId, hospitalId});
        try {
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(this.getApiUrl(workflow)).append("/datasets/").append(datasetId).append("/documents/").append(documentId).append("/segments/").append(segmentId).append("/child_chunks");
            ArrayList<String> params = new ArrayList<String>();
            if (keyword != null && !keyword.trim().isEmpty()) {
                params.add("keyword=" + keyword);
            }
            if (page != null) {
                params.add("page=" + page);
            }
            if (limit != null) {
                params.add("limit=" + limit);
            }
            if (!params.isEmpty()) {
                urlBuilder.append("?").append(String.join((CharSequence)"&", params));
            }
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(urlBuilder.toString(), HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                List childChunks = this.parseChildChunkListFromResponse(jsonResponse);
                logger.info("\u67e5\u8be2\u5b50\u5206\u6bb5\u5217\u8868\u6210\u529f: segmentId={}, childChunkCount={}", (Object)segmentId, (Object)childChunks.size());
                return childChunks;
            }
            throw new RuntimeException("\u67e5\u8be2\u5b50\u5206\u6bb5\u5217\u8868\u5931\u8d25\uff0cHTTP\u72b6\u6001\u7801: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5b50\u5206\u6bb5\u5217\u8868\u5f02\u5e38: documentId={}, segmentId={}", new Object[]{documentId, segmentId, e});
            throw new RuntimeException("\u67e5\u8be2\u5b50\u5206\u6bb5\u5217\u8868\u5931\u8d25: " + e.getMessage());
        }
    }

    public DifyChildChunk updateChildChunk(String documentId, String segmentId, String childChunkId, String content, String hospitalId, String workflowType) {
        logger.info("\u66f4\u65b0\u5b50\u5206\u6bb5: documentId={}, segmentId={}, childChunkId={}, hospitalId={}", new Object[]{documentId, segmentId, childChunkId, hospitalId});
        try {
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/" + documentId + "/segments/" + segmentId + "/child_chunks/" + childChunkId;
            HttpHeaders headers = this.createHeaders(workflow);
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("content", content);
            headers.set("X-HTTP-Method-Override", "PATCH");
            HttpEntity entity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                DifyChildChunk childChunk = this.parseChildChunkFromResponse(jsonResponse.get("data"));
                logger.info("\u66f4\u65b0\u5b50\u5206\u6bb5\u6210\u529f: childChunkId={}", (Object)childChunkId);
                return childChunk;
            }
            throw new RuntimeException("\u66f4\u65b0\u5b50\u5206\u6bb5\u5931\u8d25\uff0cHTTP\u72b6\u6001\u7801: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5b50\u5206\u6bb5\u5f02\u5e38: documentId={}, segmentId={}, childChunkId={}", new Object[]{documentId, segmentId, childChunkId, e});
            throw new RuntimeException("\u66f4\u65b0\u5b50\u5206\u6bb5\u5931\u8d25: " + e.getMessage());
        }
    }

    public boolean deleteChildChunk(String documentId, String segmentId, String childChunkId, String hospitalId, String workflowType) {
        logger.info("\u5220\u9664\u5b50\u5206\u6bb5: documentId={}, segmentId={}, childChunkId={}, hospitalId={}", new Object[]{documentId, segmentId, childChunkId, hospitalId});
        try {
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId, workflowType);
            String datasetId = this.getDatasetId(workflow);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents/" + documentId + "/segments/" + segmentId + "/child_chunks/" + childChunkId;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.DELETE, entity, String.class, new Object[0]);
            boolean success = response.getStatusCode().is2xxSuccessful();
            if (success) {
                logger.info("\u5220\u9664\u5b50\u5206\u6bb5\u6210\u529f: childChunkId={}", (Object)childChunkId);
            } else {
                logger.error("\u5220\u9664\u5b50\u5206\u6bb5\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}", (Object)response.getStatusCode());
            }
            return success;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5b50\u5206\u6bb5\u5f02\u5e38: documentId={}, segmentId={}, childChunkId={}", new Object[]{documentId, segmentId, childChunkId, e});
            return false;
        }
    }

    private List<DifySegment> parseSegmentListFromResponse(JsonNode jsonResponse) {
        ArrayList<DifySegment> segments = new ArrayList<DifySegment>();
        JsonNode dataNode = jsonResponse.get("data");
        if (dataNode != null && dataNode.isArray()) {
            for (JsonNode segmentNode : dataNode) {
                DifySegment segment = this.parseSegmentFromResponse(segmentNode);
                if (segment == null) continue;
                segments.add(segment);
            }
        }
        return segments;
    }

    private DifySegment parseSegmentFromResponse(JsonNode segmentNode) {
        if (segmentNode == null) {
            return null;
        }
        DifySegment segment = new DifySegment();
        if (segmentNode.has("id")) {
            segment.setId(segmentNode.get("id").asText());
        }
        if (segmentNode.has("position")) {
            segment.setPosition(Integer.valueOf(segmentNode.get("position").asInt()));
        }
        if (segmentNode.has("document_id")) {
            segment.setDocumentId(segmentNode.get("document_id").asText());
        }
        if (segmentNode.has("content")) {
            segment.setContent(segmentNode.get("content").asText());
        }
        if (segmentNode.has("answer")) {
            segment.setAnswer(segmentNode.get("answer").asText());
        }
        if (segmentNode.has("word_count")) {
            segment.setWordCount(Integer.valueOf(segmentNode.get("word_count").asInt()));
        }
        if (segmentNode.has("tokens")) {
            segment.setTokens(Integer.valueOf(segmentNode.get("tokens").asInt()));
        }
        if (segmentNode.has("enabled")) {
            segment.setEnabled(Boolean.valueOf(segmentNode.get("enabled").asBoolean()));
        }
        if (segmentNode.has("status")) {
            segment.setStatus(segmentNode.get("status").asText());
        }
        if (segmentNode.has("created_at")) {
            segment.setCreatedAt(new Date(segmentNode.get("created_at").asLong() * 1000L));
        }
        if (segmentNode.has("keywords") && segmentNode.get("keywords").isArray()) {
            ArrayList<String> keywords = new ArrayList<String>();
            for (JsonNode keywordNode : segmentNode.get("keywords")) {
                keywords.add(keywordNode.asText());
            }
            segment.setKeywords(keywords);
        }
        return segment;
    }

    private List<DifyChildChunk> parseChildChunkListFromResponse(JsonNode jsonResponse) {
        ArrayList<DifyChildChunk> childChunks = new ArrayList<DifyChildChunk>();
        JsonNode dataNode = jsonResponse.get("data");
        if (dataNode != null && dataNode.isArray()) {
            for (JsonNode chunkNode : dataNode) {
                DifyChildChunk childChunk = this.parseChildChunkFromResponse(chunkNode);
                if (childChunk == null) continue;
                childChunks.add(childChunk);
            }
        }
        return childChunks;
    }

    private DifyChildChunk parseChildChunkFromResponse(JsonNode chunkNode) {
        if (chunkNode == null) {
            return null;
        }
        DifyChildChunk childChunk = new DifyChildChunk();
        if (chunkNode.has("id")) {
            childChunk.setId(chunkNode.get("id").asText());
        }
        if (chunkNode.has("segment_id")) {
            childChunk.setSegmentId(chunkNode.get("segment_id").asText());
        }
        if (chunkNode.has("content")) {
            childChunk.setContent(chunkNode.get("content").asText());
        }
        if (chunkNode.has("word_count")) {
            childChunk.setWordCount(Integer.valueOf(chunkNode.get("word_count").asInt()));
        }
        if (chunkNode.has("tokens")) {
            childChunk.setTokens(Integer.valueOf(chunkNode.get("tokens").asInt()));
        }
        if (chunkNode.has("status")) {
            childChunk.setStatus(chunkNode.get("status").asText());
        }
        if (chunkNode.has("created_at")) {
            childChunk.setCreatedAt(new Date(chunkNode.get("created_at").asLong() * 1000L));
        }
        return childChunk;
    }

    private String getDatasetId(HospitalWorkflow workflow) {
        return workflow.getDifyAppId();
    }
}

