/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.HospitalWorkflowMapper;
import com.chdu.ai.model.HospitalWorkflow;
import com.chdu.ai.service.HospitalWorkflowService;
import com.chdu.ai.util.NumericIdGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HospitalWorkflowServiceImpl
implements HospitalWorkflowService {
    private static final Logger logger = LoggerFactory.getLogger(HospitalWorkflowServiceImpl.class);
    private final HospitalWorkflowMapper workflowMapper;

    public HospitalWorkflowServiceImpl(HospitalWorkflowMapper workflowMapper) {
        this.workflowMapper = workflowMapper;
    }

    @Transactional
    public HospitalWorkflow createWorkflow(HospitalWorkflow workflow) {
        try {
            HospitalWorkflow existingWorkflow;
            if (workflow.getWorkflowType() != null && (existingWorkflow = this.workflowMapper.getWorkflowByHospitalIdAndType(workflow.getHospitalId(), workflow.getWorkflowType())) != null) {
                logger.warn("\u533b\u9662\u5df2\u5b58\u5728\u8be5\u7c7b\u578b\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}, workflowType={}", (Object)workflow.getHospitalId(), (Object)workflow.getWorkflowType());
                throw new RuntimeException("\u8be5\u533b\u9662\u5df2\u5b58\u5728" + workflow.getWorkflowType() + "\u7c7b\u578b\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e");
            }
            workflow.setId(NumericIdGenerator.generate9NumericId());
            workflow.setViewId(NumericIdGenerator.generateViewId());
            workflow.setCreateTime(new Date());
            workflow.setUpdateTime(new Date());
            if (workflow.getStatus() == null) {
                workflow.setStatus(Integer.valueOf(1));
            }
            if (workflow.getWorkflowType() == null || workflow.getWorkflowType().trim().isEmpty()) {
                workflow.setWorkflowType("general");
            }
            if (workflow.getPriority() == null) {
                workflow.setPriority(Integer.valueOf(100));
            }
            if (workflow.getDifyApiUrl() == null || workflow.getDifyApiUrl().trim().isEmpty()) {
                workflow.setDifyApiUrl("");
            }
            this.workflowMapper.insertHospitalWorkflow(workflow);
            logger.info("\u521b\u5efa\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: hospitalId={}, workflowName={}", (Object)workflow.getHospitalId(), (Object)workflow.getWorkflowName());
            return workflow;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: hospitalId={}", (Object)workflow.getHospitalId(), (Object)e);
            throw new RuntimeException("\u521b\u5efa\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: " + e.getMessage());
        }
    }

    public HospitalWorkflow getWorkflowByHospitalId(String hospitalId) {
        try {
            HospitalWorkflow workflow = this.workflowMapper.getWorkflowByHospitalId(hospitalId);
            if (workflow != null) {
                logger.debug("\u83b7\u53d6\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: hospitalId={}, workflowName={}", (Object)hospitalId, (Object)workflow.getWorkflowName());
            } else {
                logger.warn("\u672a\u627e\u5230\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}", (Object)hospitalId);
            }
            return workflow;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: hospitalId={}", (Object)hospitalId, (Object)e);
            return null;
        }
    }

    public List<HospitalWorkflow> getWorkflowsByHospitalId(String hospitalId) {
        try {
            List workflows = this.workflowMapper.getWorkflowsByHospitalId(hospitalId);
            logger.debug("\u83b7\u53d6\u533b\u9662\u6240\u6709\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: hospitalId={}, count={}", (Object)hospitalId, (Object)workflows.size());
            return workflows;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u533b\u9662\u6240\u6709\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: hospitalId={}", (Object)hospitalId, (Object)e);
            return new ArrayList<HospitalWorkflow>();
        }
    }

    public HospitalWorkflow getWorkflowByHospitalIdAndType(String hospitalId, String workflowType) {
        try {
            HospitalWorkflow workflow = this.workflowMapper.getWorkflowByHospitalIdAndType(hospitalId, workflowType);
            if (workflow != null) {
                logger.debug("\u83b7\u53d6\u533b\u9662\u6307\u5b9a\u7c7b\u578b\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: hospitalId={}, workflowType={}, workflowName={}", new Object[]{hospitalId, workflowType, workflow.getWorkflowName()});
            } else {
                logger.warn("\u672a\u627e\u5230\u533b\u9662\u6307\u5b9a\u7c7b\u578b\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}, workflowType={}", (Object)hospitalId, (Object)workflowType);
            }
            return workflow;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u533b\u9662\u6307\u5b9a\u7c7b\u578b\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: hospitalId={}, workflowType={}", new Object[]{hospitalId, workflowType, e});
            return null;
        }
    }

    public HospitalWorkflow getWorkflowById(String id) {
        try {
            return this.workflowMapper.getWorkflowById(id);
        }
        catch (Exception e) {
            logger.error("\u6839\u636eID\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: id={}", (Object)id, (Object)e);
            return null;
        }
    }

    public List<HospitalWorkflow> getEnabledWorkflows() {
        try {
            List workflows = this.workflowMapper.getEnabledWorkflows();
            logger.info("\u83b7\u53d6\u542f\u7528\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f\uff0c\u6570\u91cf: {}", (Object)workflows.size());
            return workflows;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u542f\u7528\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: " + e.getMessage());
        }
    }

    public List<HospitalWorkflow> getAllWorkflows(int page, int size) {
        try {
            int offset = page * size;
            List workflows = this.workflowMapper.getAllWorkflows(size, offset);
            logger.info("\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e\u5217\u8868\u6210\u529f: page={}, size={}, count={}", new Object[]{page, size, workflows.size()});
            return workflows;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e\u5217\u8868\u5931\u8d25: page={}, size={}", new Object[]{page, size, e});
            throw new RuntimeException("\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e\u5217\u8868\u5931\u8d25: " + e.getMessage());
        }
    }

    @Transactional
    public boolean updateWorkflow(HospitalWorkflow workflow) {
        try {
            workflow.setUpdateTime(new Date());
            int result = this.workflowMapper.updateWorkflow(workflow);
            if (result > 0) {
                logger.info("\u66f4\u65b0\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: id={}, hospitalId={}", (Object)workflow.getId(), (Object)workflow.getHospitalId());
                return true;
            }
            logger.warn("\u66f4\u65b0\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25\uff0c\u672a\u627e\u5230\u8bb0\u5f55: id={}", (Object)workflow.getId());
            return false;
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5de5\u4f5c\u6d41\u914d\u7f6e\u5f02\u5e38: id={}", (Object)workflow.getId(), (Object)e);
            return false;
        }
    }

    @Transactional
    public boolean updateWorkflowStatus(String id, Integer status) {
        try {
            int result = this.workflowMapper.updateWorkflowStatus(id, status);
            if (result > 0) {
                logger.info("\u66f4\u65b0\u5de5\u4f5c\u6d41\u72b6\u6001\u6210\u529f: id={}, status={}", (Object)id, (Object)status);
                return true;
            }
            logger.warn("\u66f4\u65b0\u5de5\u4f5c\u6d41\u72b6\u6001\u5931\u8d25\uff0c\u672a\u627e\u5230\u8bb0\u5f55: id={}", (Object)id);
            return false;
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5de5\u4f5c\u6d41\u72b6\u6001\u5f02\u5e38: id={}, status={}", new Object[]{id, status, e});
            return false;
        }
    }

    @Transactional
    public boolean deleteWorkflow(String id) {
        try {
            int result = this.workflowMapper.deleteWorkflow(id);
            if (result > 0) {
                logger.info("\u5220\u9664\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: id={}", (Object)id);
                return true;
            }
            logger.warn("\u5220\u9664\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25\uff0c\u672a\u627e\u5230\u8bb0\u5f55: id={}", (Object)id);
            return false;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5de5\u4f5c\u6d41\u914d\u7f6e\u5f02\u5e38: id={}", (Object)id, (Object)e);
            return false;
        }
    }

    public boolean hasWorkflowConfig(String hospitalId) {
        try {
            int count = this.workflowMapper.countByHospitalId(hospitalId);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: hospitalId={}", (Object)hospitalId, (Object)e);
            return false;
        }
    }
}

