/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.config;

import io.lettuce.core.ReadFrom;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class RedisClusterConfig {
    @Value(value="${spring.redis.cluster.nodes}")
    private String clusterNodes;
    @Value(value="${spring.redis.cluster.max-redirects}")
    private int maxRedirects;
    @Value(value="${spring.redis.timeout}")
    private long timeout;

    @Bean
    public LettuceConnectionFactory redisConnectionFactory() {
        List<String> nodeList = Arrays.asList(this.clusterNodes.split(","));
        RedisClusterConfiguration clusterConfiguration = new RedisClusterConfiguration(nodeList);
        clusterConfiguration.setMaxRedirects(this.maxRedirects);
        LettuceClientConfiguration clientConfig = LettuceClientConfiguration.builder().readFrom(ReadFrom.REPLICA_PREFERRED).commandTimeout(Duration.ofMillis(this.timeout)).build();
        return new LettuceConnectionFactory(clusterConfiguration, clientConfig);
    }

    @Bean
    public StringRedisTemplate redisTemplate(LettuceConnectionFactory redisConnectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate((RedisConnectionFactory)redisConnectionFactory);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)new StringRedisSerializer());
        return template;
    }
}

