/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

/*
 * Exception performing whole class analysis ignored.
 */
public class MessageSizeLimiter {
    private static final Logger logger = LoggerFactory.getLogger(MessageSizeLimiter.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final int SAFE_MESSAGE_SIZE = 4096;

    public static boolean safeSendMessage(WebSocketSession session, String message) {
        return MessageSizeLimiter.safeSendMessage((WebSocketSession)session, (String)message, (String)"data");
    }

    public static boolean safeSendMessage(WebSocketSession session, String message, String messageType) {
        if (session == null || !session.isOpen()) {
            logger.warn("WebSocket\u4f1a\u8bdd\u65e0\u6548\u6216\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f");
            return false;
        }
        try {
            byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
            int messageSize = messageBytes.length;
            logger.debug("\u51c6\u5907\u53d1\u9001{}\u6d88\u606f: \u5927\u5c0f={}bytes", (Object)messageType, (Object)messageSize);
            if (messageSize <= 4096) {
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
                logger.debug("\u76f4\u63a5\u53d1\u9001{}\u6d88\u606f\u6210\u529f: {}bytes", (Object)messageType, (Object)messageSize);
                return true;
            }
            logger.warn("{}\u6d88\u606f\u8fc7\u5927({}bytes)\uff0c\u5f00\u59cb\u5206\u7247\u53d1\u9001", (Object)messageType, (Object)messageSize);
            return MessageSizeLimiter.sendChunkedMessage((WebSocketSession)session, (String)message, (String)messageType);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001{}\u6d88\u606f\u5931\u8d25", (Object)messageType, (Object)e);
            return false;
        }
    }

    private static boolean sendChunkedMessage(WebSocketSession session, String message, String messageType) {
        try {
            byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
            int chunkSize = 2048;
            int totalChunks = (int)Math.ceil((double)messageBytes.length / (double)chunkSize);
            String chunkId = System.currentTimeMillis() + "_" + messageType;
            logger.info("\u5f00\u59cb\u5206\u7247\u53d1\u9001{}\u6d88\u606f: \u603b\u5927\u5c0f={}bytes, \u5206\u7247\u6570={}", new Object[]{messageType, messageBytes.length, totalChunks});
            for (int i = 0; i < totalChunks; ++i) {
                int start = i * chunkSize;
                int end = Math.min(start + chunkSize, messageBytes.length);
                byte[] chunkBytes = new byte[end - start];
                System.arraycopy(messageBytes, start, chunkBytes, 0, end - start);
                String chunkData = new String(chunkBytes, StandardCharsets.UTF_8);
                HashMap<String, Object> chunkMessage = new HashMap<String, Object>();
                chunkMessage.put("type", "message_chunk");
                chunkMessage.put("messageType", messageType);
                chunkMessage.put("chunkId", chunkId);
                chunkMessage.put("chunkIndex", i);
                chunkMessage.put("totalChunks", totalChunks);
                chunkMessage.put("data", chunkData);
                chunkMessage.put("isLast", i == totalChunks - 1);
                chunkMessage.put("timestamp", System.currentTimeMillis());
                String chunkJson = objectMapper.writeValueAsString(chunkMessage);
                if (!session.isOpen()) {
                    logger.warn("WebSocket\u8fde\u63a5\u5df2\u5173\u95ed\uff0c\u505c\u6b62\u53d1\u9001\u5206\u7247 {}/{}", (Object)(i + 1), (Object)totalChunks);
                    return false;
                }
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)chunkJson));
                logger.debug("\u53d1\u9001\u5206\u7247 {}/{}: \u5927\u5c0f={}bytes", new Object[]{i + 1, totalChunks, chunkJson.getBytes(StandardCharsets.UTF_8).length});
                Thread.sleep(50L);
            }
            logger.info("\u5206\u7247\u53d1\u9001\u5b8c\u6210: chunkId={}, \u603b\u5206\u7247\u6570={}", (Object)chunkId, (Object)totalChunks);
            return true;
        }
        catch (Exception e) {
            logger.error("\u5206\u7247\u53d1\u9001{}\u6d88\u606f\u5931\u8d25", (Object)messageType, (Object)e);
            return false;
        }
    }

    public static void sendErrorMessage(WebSocketSession session, String errorMessage) {
        try {
            if (session != null && session.isOpen()) {
                HashMap<String, Object> errorResponse = new HashMap<String, Object>();
                errorResponse.put("type", "error");
                errorResponse.put("message", errorMessage);
                errorResponse.put("timestamp", System.currentTimeMillis());
                String errorJson = objectMapper.writeValueAsString(errorResponse);
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)errorJson));
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u9519\u8bef\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

