/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.DifyChatRequest;
import com.chdu.ai.model.DifySTTRequest;
import com.chdu.ai.model.DifyTTSRequest;
import com.chdu.ai.model.PatientSession;
import com.chdu.ai.model.STTVoiceCache;
import com.chdu.ai.model.TTSAudioCache;
import com.chdu.ai.service.DifyService;
import com.chdu.ai.service.DifyTTSService;
import com.chdu.ai.service.OSSService;
import com.chdu.ai.service.PatientSessionService;
import com.chdu.ai.service.STTVoiceCacheService;
import com.chdu.ai.service.TTSCacheService;
import com.chdu.ai.util.AudioDurationUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/api/dify"})
@CrossOrigin(origins={"*"})
public class DifyController {
    private static final Logger logger = LoggerFactory.getLogger(DifyController.class);
    @Autowired
    private DifyService difyService;
    @Autowired
    private DifyTTSService difyTTSService;
    @Autowired
    private TTSCacheService ttsCacheService;
    @Autowired
    private OSSService ossService;
    @Autowired
    private PatientSessionService patientSessionService;
    @Autowired
    private STTVoiceCacheService sttVoiceCacheService;

    @PostMapping(value={"/chat/stream"}, produces={"text/event-stream"})
    public SseEmitter chatStream(@RequestBody DifyChatRequest request, HttpServletRequest httpRequest) {
        try {
            logger.info("\u6536\u5230Dify\u6d41\u5f0f\u804a\u5929\u8bf7\u6c42: \u7528\u6237={}, \u533b\u9662ID={}, \u5de5\u4f5c\u6d41\u7c7b\u578b={}, \u67e5\u8be2={}", new Object[]{request.getUser(), request.getHospitalId(), request.getWorkflowType(), request.getQuery()});
            if (request.getQuery() == null || request.getQuery().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            if (request.getUser() == null || request.getUser().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            return this.difyService.chatWithDify(request);
        }
        catch (Exception e) {
            logger.error("Dify\u6d41\u5f0f\u804a\u5929\u8bf7\u6c42\u5904\u7406\u5931\u8d25", (Throwable)e);
            SseEmitter emitter = new SseEmitter();
            emitter.completeWithError((Throwable)e);
            return emitter;
        }
    }

    @PostMapping(value={"/chat/blocking"})
    public BaseResponse<Map<String, Object>> chatBlocking(@RequestBody DifyChatRequest request) {
        try {
            logger.info("\u6536\u5230Dify\u963b\u585e\u5f0f\u804a\u5929\u8bf7\u6c42: \u7528\u6237={}, \u533b\u9662ID={}, \u5de5\u4f5c\u6d41\u7c7b\u578b={}, \u67e5\u8be2={}", new Object[]{request.getUser(), request.getHospitalId(), request.getWorkflowType(), request.getQuery()});
            if (request.getQuery() == null || request.getQuery().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getUser() == null || request.getUser().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String answer = this.difyService.chatWithDifyBlocking(request);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("answer", answer);
            result.put("conversation_id", request.getConversationId());
            result.put("user", request.getUser());
            return BaseResponse.success(result);
        }
        catch (Exception e) {
            logger.error("Dify\u963b\u585e\u5f0f\u804a\u5929\u8bf7\u6c42\u5904\u7406\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u5904\u7406\u804a\u5929\u8bf7\u6c42\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/conversations/active/messages"})
    public BaseResponse<String> getActiveConversationHistory(@RequestParam String patientId, @RequestParam String hospitalId, @RequestParam(defaultValue="general") String workflowType) {
        try {
            logger.info("\u83b7\u53d6\u60a3\u8005\u6d3b\u8dc3\u4f1a\u8bdd\u5bf9\u8bdd\u5386\u53f2\uff08\u6700\u65b0\u6d88\u606f\uff09: patientId={}, hospitalId={}, workflowType={}", new Object[]{patientId, hospitalId, workflowType});
            PatientSession activeSession = this.patientSessionService.findActiveSession(patientId, hospitalId, workflowType);
            if (activeSession == null) {
                logger.info("\u672a\u627e\u5230\u60a3\u8005\u6d3b\u8dc3\u4f1a\u8bdd: patientId={}, hospitalId={}, workflowType={}", new Object[]{patientId, hospitalId, workflowType});
                return BaseResponse.success((Object)"{}");
            }
            String conversationId = activeSession.getDifyConversationId();
            if (conversationId == null || conversationId.trim().isEmpty()) {
                logger.warn("\u6d3b\u8dc3\u4f1a\u8bdd\u7684conversationId\u4e3a\u7a7a: patientId={}, sessionId={}", (Object)patientId, (Object)activeSession.getId());
                return BaseResponse.success((Object)"{}");
            }
            logger.info("\u627e\u5230\u6d3b\u8dc3\u4f1a\u8bdd: patientId={}, sessionId={}, conversationId={}", new Object[]{patientId, activeSession.getId(), conversationId});
            String difyUserId = activeSession.getDifyUserId();
            String history = this.difyService.getConversationHistoryWithTTS(conversationId, difyUserId, hospitalId, workflowType);
            if (history != null) {
                return BaseResponse.success((Object)history);
            }
            return BaseResponse.error((String)"104", (String)"\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u60a3\u8005\u6d3b\u8dc3\u4f1a\u8bdd\u5bf9\u8bdd\u5386\u53f2\u5931\u8d25: patientId={}, hospitalId={}", new Object[]{patientId, hospitalId, e});
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/conversations/active/messages/more"})
    public BaseResponse<String> getMoreConversationHistory(@RequestParam String patientId, @RequestParam String hospitalId, @RequestParam String firstMessageId, @RequestParam(defaultValue="general") String workflowType) {
        try {
            logger.info("\u83b7\u53d6\u66f4\u591a\u5bf9\u8bdd\u5386\u53f2: patientId={}, hospitalId={}, firstMessageId={}, workflowType={}", new Object[]{patientId, hospitalId, firstMessageId, workflowType});
            PatientSession activeSession = this.patientSessionService.findActiveSession(patientId, hospitalId, workflowType);
            if (activeSession == null) {
                logger.info("\u672a\u627e\u5230\u60a3\u8005\u6d3b\u8dc3\u4f1a\u8bdd: patientId={}, hospitalId={}, workflowType={}", new Object[]{patientId, hospitalId, workflowType});
                return BaseResponse.success((Object)"{}");
            }
            String conversationId = activeSession.getDifyConversationId();
            if (conversationId == null || conversationId.trim().isEmpty()) {
                logger.warn("\u6d3b\u8dc3\u4f1a\u8bdd\u7684conversationId\u4e3a\u7a7a: patientId={}, sessionId={}", (Object)patientId, (Object)activeSession.getId());
                return BaseResponse.error((String)"404", (String)"\u4f1a\u8bdd\u5c1a\u672a\u5efa\u7acb\u5bf9\u8bdd\u5386\u53f2");
            }
            if (firstMessageId == null || firstMessageId.trim().isEmpty()) {
                logger.warn("firstMessageId\u53c2\u6570\u4e3a\u7a7a: patientId={}", (Object)patientId);
                return BaseResponse.error((String)"400", (String)"firstMessageId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            logger.info("\u83b7\u53d6\u66f4\u591a\u5386\u53f2\u6d88\u606f: patientId={}, sessionId={}, conversationId={}, firstMessageId={}", new Object[]{patientId, activeSession.getId(), conversationId, firstMessageId});
            String difyUserId = activeSession.getDifyUserId();
            String history = this.difyService.getConversationHistoryMoreWithTTS(conversationId, difyUserId, firstMessageId, hospitalId, workflowType);
            if (history != null) {
                return BaseResponse.success((Object)history);
            }
            return BaseResponse.error((String)"404", (String)"\u83b7\u53d6\u66f4\u591a\u5bf9\u8bdd\u5386\u53f2\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u66f4\u591a\u5bf9\u8bdd\u5386\u53f2\u5931\u8d25: patientId={}, hospitalId={}, firstMessageId={}", new Object[]{patientId, hospitalId, firstMessageId, e});
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u66f4\u591a\u5bf9\u8bdd\u5386\u53f2\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/conversations/delete"})
    public BaseResponse<String> deleteConversation(@RequestParam String conversationId, @RequestParam String user) {
        try {
            logger.info("\u5220\u9664\u5bf9\u8bdd: \u5bf9\u8bddID={}, \u7528\u6237={}", (Object)conversationId, (Object)user);
            boolean success = this.difyService.deleteConversation(conversationId, user);
            if (success) {
                return BaseResponse.success((Object)"\u5bf9\u8bdd\u5220\u9664\u6210\u529f");
            }
            return BaseResponse.error((String)"404", (String)"\u5bf9\u8bdd\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5bf9\u8bdd\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u5220\u9664\u5bf9\u8bdd\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/sessions/end"})
    public BaseResponse<String> endSession(@RequestParam Long sessionId) {
        try {
            logger.info("\u7ed3\u675f\u60a3\u8005\u4f1a\u8bdd: sessionId={}", (Object)sessionId);
            if (sessionId == null) {
                return BaseResponse.error((String)"400", (String)"\u4f1a\u8bddID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.patientSessionService.endSession(sessionId);
            logger.info("\u60a3\u8005\u4f1a\u8bdd\u7ed3\u675f\u6210\u529f: sessionId={}", (Object)sessionId);
            return BaseResponse.success((Object)"\u4f1a\u8bdd\u7ed3\u675f\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u7ed3\u675f\u60a3\u8005\u4f1a\u8bdd\u5931\u8d25: sessionId={}", (Object)sessionId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u7ed3\u675f\u4f1a\u8bdd\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/sessions/end-active"})
    public BaseResponse<String> endActiveSession(@RequestParam String patientId, @RequestParam String hospitalId, @RequestParam(required=false) String workflowType) {
        try {
            logger.info("\u7ed3\u675f\u6d3b\u8dc3\u4f1a\u8bdd: patientId={}, hospitalId={}, workflowType={}", new Object[]{patientId, hospitalId, workflowType});
            if (patientId == null || patientId.trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u60a3\u8005ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (hospitalId == null || hospitalId.trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            PatientSession activeSession = this.patientSessionService.findActiveSession(patientId, hospitalId, workflowType != null ? workflowType : "general");
            if (activeSession == null || activeSession.getId() == null) {
                logger.warn("\u672a\u627e\u5230\u6d3b\u8dc3\u4f1a\u8bdd: patientId={}, hospitalId={}, workflowType={}", new Object[]{patientId, hospitalId, workflowType});
                return BaseResponse.error((String)"404", (String)"\u672a\u627e\u5230\u6d3b\u8dc3\u4f1a\u8bdd");
            }
            this.patientSessionService.endSession(activeSession.getId());
            logger.info("\u6d3b\u8dc3\u4f1a\u8bdd\u7ed3\u675f\u6210\u529f: sessionId={}, patientId={}, hospitalId={}", new Object[]{activeSession.getId(), patientId, hospitalId});
            return BaseResponse.success((Object)"\u4f1a\u8bdd\u7ed3\u675f\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u7ed3\u675f\u6d3b\u8dc3\u4f1a\u8bdd\u5931\u8d25: patientId={}, hospitalId={}", new Object[]{patientId, hospitalId, e});
            return BaseResponse.error((String)"500", (String)("\u7ed3\u675f\u4f1a\u8bdd\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/parameters"})
    public BaseResponse<String> getApplicationParameters(@RequestParam String user) {
        try {
            logger.info("\u83b7\u53d6\u5e94\u7528\u53c2\u6570: \u7528\u6237={}", (Object)user);
            String parameters = this.difyService.getApplicationParameters(user);
            if (parameters != null) {
                return BaseResponse.success((Object)parameters);
            }
            return BaseResponse.error((String)"404", (String)"\u83b7\u53d6\u5e94\u7528\u53c2\u6570\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5e94\u7528\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5e94\u7528\u53c2\u6570\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/tts"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> textToSpeech(@RequestBody DifyTTSRequest request) {
        try {
            TTSAudioCache cachedAudio;
            logger.info("\u6536\u5230Dify TTS\u8bf7\u6c42: \u7528\u6237={}, \u533b\u9662ID={}, \u5de5\u4f5c\u6d41\u7c7b\u578b={}, messageId={}, \u6587\u672c\u957f\u5ea6={}, \u662f\u5426\u5b8c\u6574={}", new Object[]{request.getUser(), request.getHospitalId(), request.getWorkflowType(), request.getMessageId(), request.getText() != null ? request.getText().length() : 0, request.getIsComplete()});
            if ((request.getMessageId() == null || request.getMessageId().trim().isEmpty()) && (request.getText() == null || request.getText().trim().isEmpty())) {
                return ResponseEntity.badRequest().body((Object)BaseResponse.error((String)"400", (String)"message_id\u548ctext\u81f3\u5c11\u9700\u8981\u63d0\u4f9b\u4e00\u4e2a"));
            }
            if (request.getUser() == null || request.getUser().trim().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)BaseResponse.error((String)"400", (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)BaseResponse.error((String)"400", (String)"\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)BaseResponse.error((String)"400", (String)"\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (!this.difyTTSService.isTTSAvailable(request.getHospitalId(), request.getWorkflowType())) {
                return ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).body((Object)BaseResponse.error((String)"503", (String)"TTS\u670d\u52a1\u4e0d\u53ef\u7528"));
            }
            boolean isComplete = Boolean.TRUE.equals(request.getIsComplete());
            if (isComplete && (cachedAudio = this.ttsCacheService.findCachedAudio(request.getMessageId(), request.getText(), request.getHospitalId(), request.getWorkflowType())) != null) {
                logger.info("\u627e\u5230\u5b8c\u6574\u5185\u5bb9TTS\u7f13\u5b58\uff0c\u76f4\u63a5\u8fd4\u56deOSS\u5730\u5740: {}", (Object)cachedAudio.getOssUrl());
                this.ttsCacheService.updateHitCount(cachedAudio.getId());
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("audioUrl", cachedAudio.getOssUrl());
                result.put("duration", cachedAudio.getDuration());
                result.put("cached", true);
                result.put("isComplete", true);
                return ResponseEntity.ok((Object)BaseResponse.success(result));
            }
            InputStream audioStream = this.difyTTSService.textToSpeech(request);
            if (isComplete) {
                TTSAudioCache newCache = this.ttsCacheService.cacheAudioFile(request.getMessageId(), request.getText(), request.getHospitalId(), request.getWorkflowType(), request.getUser(), audioStream, -1L, null);
                logger.info("\u5b8c\u6574\u5185\u5bb9TTS\u97f3\u9891\u7f13\u5b58\u6210\u529f\uff0cOSS\u5730\u5740: {}", (Object)newCache.getOssUrl());
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("audioUrl", newCache.getOssUrl());
                result.put("duration", newCache.getDuration());
                result.put("cached", false);
                result.put("isComplete", true);
                return ResponseEntity.ok((Object)BaseResponse.success(result));
            }
            String fileName = "tts_fragment/" + request.getHospitalId() + "/" + request.getWorkflowType() + "/" + System.currentTimeMillis() + "_fragment.wav";
            String audioUrl = this.ossService.uploadFile("byh-im-file", fileName, audioStream, -1L, "audio/wav");
            logger.info("\u7247\u6bb5\u5185\u5bb9TTS\u97f3\u9891\u4e0a\u4f20\u6210\u529f\uff0cOSS\u5730\u5740: {}", (Object)audioUrl);
            Object fragmentDuration = null;
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("audioUrl", audioUrl);
            result.put("duration", fragmentDuration);
            result.put("cached", false);
            result.put("isComplete", false);
            return ResponseEntity.ok((Object)BaseResponse.success(result));
        }
        catch (Exception e) {
            logger.error("Dify TTS\u8bf7\u6c42\u5904\u7406\u5931\u8d25", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)BaseResponse.error((String)"500", (String)("TTS\u5904\u7406\u5931\u8d25: " + e.getMessage())));
        }
    }

    @GetMapping(value={"/tts/audio/{messageId}"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> getAudioByMessageId(@PathVariable String messageId, @RequestParam String hospitalId, @RequestParam String workflowType, @RequestParam String userId) {
        try {
            logger.info("\u83b7\u53d6\u5386\u53f2\u6d88\u606f\u97f3\u9891: messageId={}, hospitalId={}, workflowType={}", new Object[]{messageId, hospitalId, workflowType});
            TTSAudioCache cachedAudio = this.ttsCacheService.findCachedAudio(messageId, null, hospitalId, workflowType);
            if (cachedAudio != null) {
                logger.info("\u627e\u5230\u5386\u53f2\u6d88\u606fTTS\u7f13\u5b58: messageId={}, ossUrl={}", (Object)messageId, (Object)cachedAudio.getOssUrl());
                this.ttsCacheService.updateHitCount(cachedAudio.getId());
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("audioUrl", cachedAudio.getOssUrl());
                result.put("duration", cachedAudio.getDuration());
                result.put("cached", true);
                return ResponseEntity.ok((Object)BaseResponse.success(result));
            }
            logger.info("\u672a\u627e\u5230\u5386\u53f2\u6d88\u606fTTS\u7f13\u5b58: messageId={}", (Object)messageId);
            return ResponseEntity.ok((Object)BaseResponse.error((String)"404", (String)"\u8be5\u6d88\u606f\u6682\u65e0\u97f3\u9891\u7f13\u5b58\uff0c\u8bf7\u91cd\u65b0\u751f\u6210"));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5386\u53f2\u6d88\u606f\u97f3\u9891\u5931\u8d25: messageId={}", (Object)messageId, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u97f3\u9891\u5931\u8d25: " + e.getMessage())));
        }
    }

    @PostMapping(value={"/stt/cache"})
    public BaseResponse<Map<String, Object>> cacheSTTVoice(@RequestBody Map<String, Object> request) {
        try {
            String difyMessageId = (String)request.get("difyMessageId");
            String audioUrl = (String)request.get("audioUrl");
            String fileName = (String)request.get("fileName");
            String contentType = (String)request.get("contentType");
            Long fileSize = request.get("fileSize") != null ? Long.valueOf(request.get("fileSize").toString()) : null;
            Double duration = request.get("duration") != null ? Double.valueOf(request.get("duration").toString()) : null;
            String language = (String)request.get("language");
            String recognizedText = (String)request.get("recognizedText");
            String userId = (String)request.get("user");
            String hospitalId = (String)request.get("hospitalId");
            String workflowType = (String)request.get("workflowType");
            String conversationId = (String)request.get("conversationId");
            if (difyMessageId == null || difyMessageId.trim().isEmpty()) {
                return BaseResponse.error((String)"501", (String)"Dify\u6d88\u606fID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (audioUrl == null || audioUrl.trim().isEmpty()) {
                return BaseResponse.error((String)"502", (String)"\u97f3\u9891\u6587\u4ef6URL\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (userId == null || userId.trim().isEmpty()) {
                return BaseResponse.error((String)"503", (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (hospitalId == null || hospitalId.trim().isEmpty()) {
                return BaseResponse.error((String)"504", (String)"\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (workflowType == null || workflowType.trim().isEmpty()) {
                return BaseResponse.error((String)"505", (String)"\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (conversationId == null || conversationId.trim().isEmpty()) {
                return BaseResponse.error((String)"506", (String)"\u5bf9\u8bddID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            STTVoiceCache cache = this.sttVoiceCacheService.cacheSTTVoice(difyMessageId, userId, hospitalId, workflowType, conversationId, audioUrl, fileName, contentType, fileSize, duration, language, recognizedText);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("success", true);
            result.put("cacheId", cache.getId());
            result.put("difyMessageId", difyMessageId);
            result.put("audioUrl", audioUrl);
            result.put("duration", duration);
            logger.info("STT\u8bed\u97f3\u6d88\u606f\u7f13\u5b58\u6210\u529f: difyMessageId={}, audioUrl={}, duration={}s", new Object[]{difyMessageId, audioUrl, duration});
            return BaseResponse.success(result);
        }
        catch (Exception e) {
            logger.error("\u7f13\u5b58STT\u8bed\u97f3\u6d88\u606f\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u7f13\u5b58STT\u8bed\u97f3\u6d88\u606f\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/stt"})
    public BaseResponse<Map<String, Object>> speechToText(@RequestBody DifySTTRequest request) {
        try {
            logger.info("\u6536\u5230Dify STT\u8bf7\u6c42: \u7528\u6237={}, \u533b\u9662ID={}, \u5de5\u4f5c\u6d41\u7c7b\u578b={}, \u6587\u4ef6\u540d={}", new Object[]{request.getUser(), request.getHospitalId(), request.getWorkflowType(), request.getFileName()});
            if (request.getAudioBase64() == null || request.getAudioBase64().trim().isEmpty()) {
                return BaseResponse.error((String)"501", (String)"\u97f3\u9891\u6587\u4ef6base64\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getUser() == null || request.getUser().trim().isEmpty()) {
                return BaseResponse.error((String)"502", (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                return BaseResponse.error((String)"503", (String)"\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                return BaseResponse.error((String)"504", (String)"\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String contentType = request.getContentType();
            if (contentType == null || !contentType.startsWith("audio/")) {
                return BaseResponse.error((String)"505", (String)"\u8bf7\u4e0a\u4f20\u97f3\u9891\u6587\u4ef6");
            }
            if (!this.difyTTSService.isSTTAvailable(request.getHospitalId(), request.getWorkflowType())) {
                return BaseResponse.error((String)"503", (String)"STT\u670d\u52a1\u4e0d\u53ef\u7528");
            }
            byte[] audioBytes = Base64.getDecoder().decode(request.getAudioBase64());
            String fileName = "voice/" + request.getHospitalId() + "/" + request.getWorkflowType() + "/" + System.currentTimeMillis() + "_" + request.getFileName();
            String audioUrl = this.ossService.uploadFile("byh-im-file", fileName, (InputStream)new ByteArrayInputStream(audioBytes), (long)audioBytes.length, contentType);
            logger.info("\u8bed\u97f3\u6587\u4ef6\u4e0a\u4f20\u6210\u529f: audioUrl={}", (Object)audioUrl);
            Double audioDuration = AudioDurationUtil.calculateDurationSmart((byte[])audioBytes, (String)contentType);
            if (audioDuration != null) {
                logger.debug("\u8ba1\u7b97STT\u97f3\u9891\u65f6\u957f: {} \u79d2", (Object)audioDuration);
            } else {
                logger.warn("\u65e0\u6cd5\u8ba1\u7b97STT\u97f3\u9891\u65f6\u957f\uff0c\u683c\u5f0f: {}", (Object)contentType);
            }
            String recognizedText = this.difyTTSService.speechToText(request);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("audioUrl", audioUrl);
            result.put("text", recognizedText);
            result.put("duration", audioDuration);
            result.put("user", request.getUser());
            result.put("hospitalId", request.getHospitalId());
            result.put("workflowType", request.getWorkflowType());
            result.put("language", request.getLanguage());
            result.put("fileName", request.getFileName());
            result.put("fileSize", request.getFileSize());
            result.put("contentType", contentType);
            return BaseResponse.success(result);
        }
        catch (Exception e) {
            logger.error("Dify STT\u8bf7\u6c42\u5904\u7406\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("STT\u5904\u7406\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/tts/status"})
    public BaseResponse<Map<String, Object>> getTTSStatus(@RequestParam String hospitalId, @RequestParam String workflowType) {
        try {
            boolean available = this.difyTTSService.isTTSAvailable(hospitalId, workflowType);
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("available", available);
            status.put("service", "Dify TTS");
            status.put("hospitalId", hospitalId);
            status.put("workflowType", workflowType);
            status.put("timestamp", System.currentTimeMillis());
            return BaseResponse.success(status);
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5TTS\u670d\u52a1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u68c0\u67e5\u670d\u52a1\u72b6\u6001\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/stt/status"})
    public BaseResponse<Map<String, Object>> getSTTStatus(@RequestParam String hospitalId, @RequestParam String workflowType) {
        try {
            boolean available = this.difyTTSService.isSTTAvailable(hospitalId, workflowType);
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("available", available);
            status.put("service", "Dify STT");
            status.put("hospitalId", hospitalId);
            status.put("workflowType", workflowType);
            status.put("timestamp", System.currentTimeMillis());
            return BaseResponse.success(status);
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5STT\u670d\u52a1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u68c0\u67e5\u670d\u52a1\u72b6\u6001\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/health"})
    public BaseResponse<Map<String, Object>> health() {
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("status", "UP");
        status.put("service", "Dify AI Service");
        status.put("timestamp", System.currentTimeMillis());
        return BaseResponse.success(status);
    }
}

