/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.HospitalWorkflow;
import com.chdu.ai.service.HospitalWorkflowService;
import com.chdu.ai.service.MultiWorkflowDifyService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/hospital-workflow"})
@CrossOrigin(origins={"*"})
public class HospitalWorkflowController {
    private static final Logger logger = LoggerFactory.getLogger(HospitalWorkflowController.class);
    @Autowired
    private HospitalWorkflowService hospitalWorkflowService;
    @Autowired
    private MultiWorkflowDifyService multiWorkflowDifyService;

    @PostMapping(value={"/create"})
    public BaseResponse<HospitalWorkflow> createWorkflow(@RequestBody HospitalWorkflow workflow) {
        try {
            logger.info("\u521b\u5efa\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}, workflowName={}, workflowType={}", new Object[]{workflow.getHospitalId(), workflow.getWorkflowName(), workflow.getWorkflowType()});
            HospitalWorkflow createdWorkflow = this.hospitalWorkflowService.createWorkflow(workflow);
            logger.info("\u521b\u5efa\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: id={}", (Object)createdWorkflow.getId());
            return BaseResponse.success((Object)createdWorkflow);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u521b\u5efa\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/hospital/{hospitalId}"})
    public BaseResponse<List<HospitalWorkflow>> getWorkflowsByHospitalId(@PathVariable String hospitalId) {
        try {
            logger.info("\u83b7\u53d6\u533b\u9662\u6240\u6709\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}", (Object)hospitalId);
            List workflows = this.hospitalWorkflowService.getWorkflowsByHospitalId(hospitalId);
            logger.info("\u83b7\u53d6\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: hospitalId={}, count={}", (Object)hospitalId, (Object)workflows.size());
            return BaseResponse.success((Object)workflows);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: hospitalId={}", (Object)hospitalId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/hospital/{hospitalId}/default"})
    public BaseResponse<HospitalWorkflow> getDefaultWorkflowByHospitalId(@PathVariable String hospitalId) {
        try {
            logger.info("\u83b7\u53d6\u533b\u9662\u9ed8\u8ba4\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}", (Object)hospitalId);
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalId(hospitalId);
            if (workflow != null) {
                logger.info("\u83b7\u53d6\u533b\u9662\u9ed8\u8ba4\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: hospitalId={}, workflowName={}", (Object)hospitalId, (Object)workflow.getWorkflowName());
                return BaseResponse.success((Object)workflow);
            }
            logger.warn("\u672a\u627e\u5230\u533b\u9662\u9ed8\u8ba4\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}", (Object)hospitalId);
            return BaseResponse.error((String)"404", (String)"\u672a\u627e\u5230\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u533b\u9662\u9ed8\u8ba4\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: hospitalId={}", (Object)hospitalId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/hospital/{hospitalId}/type/{workflowType}"})
    public BaseResponse<HospitalWorkflow> getWorkflowByHospitalIdAndType(@PathVariable String hospitalId, @PathVariable String workflowType) {
        try {
            logger.info("\u83b7\u53d6\u533b\u9662\u6307\u5b9a\u7c7b\u578b\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}, workflowType={}", (Object)hospitalId, (Object)workflowType);
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(hospitalId, workflowType);
            if (workflow != null) {
                logger.info("\u83b7\u53d6\u533b\u9662\u6307\u5b9a\u7c7b\u578b\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: hospitalId={}, workflowType={}, workflowName={}", new Object[]{hospitalId, workflowType, workflow.getWorkflowName()});
                return BaseResponse.success((Object)workflow);
            }
            logger.warn("\u672a\u627e\u5230\u533b\u9662\u6307\u5b9a\u7c7b\u578b\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}, workflowType={}", (Object)hospitalId, (Object)workflowType);
            return BaseResponse.error((String)"404", (String)"\u672a\u627e\u5230\u6307\u5b9a\u7c7b\u578b\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u533b\u9662\u6307\u5b9a\u7c7b\u578b\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: hospitalId={}, workflowType={}", new Object[]{hospitalId, workflowType, e});
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/{id}"})
    public BaseResponse<HospitalWorkflow> getWorkflowById(@PathVariable String id) {
        try {
            logger.info("\u6839\u636eID\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e: id={}", (Object)id);
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowById(id);
            if (workflow != null) {
                logger.info("\u6839\u636eID\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: id={}, workflowName={}", (Object)id, (Object)workflow.getWorkflowName());
                return BaseResponse.success((Object)workflow);
            }
            logger.warn("\u672a\u627e\u5230\u5de5\u4f5c\u6d41\u914d\u7f6e: id={}", (Object)id);
            return BaseResponse.error((String)"404", (String)"\u672a\u627e\u5230\u5de5\u4f5c\u6d41\u914d\u7f6e");
        }
        catch (Exception e) {
            logger.error("\u6839\u636eID\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: id={}", (Object)id, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/enabled"})
    public BaseResponse<List<HospitalWorkflow>> getEnabledWorkflows() {
        try {
            logger.info("\u83b7\u53d6\u6240\u6709\u542f\u7528\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e");
            List workflows = this.hospitalWorkflowService.getEnabledWorkflows();
            logger.info("\u83b7\u53d6\u542f\u7528\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: count={}", (Object)workflows.size());
            return BaseResponse.success((Object)workflows);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u542f\u7528\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/all"})
    public BaseResponse<List<HospitalWorkflow>> getAllWorkflows(@RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="20") int size) {
        try {
            logger.info("\u83b7\u53d6\u6240\u6709\u5de5\u4f5c\u6d41\u914d\u7f6e: page={}, size={}", (Object)page, (Object)size);
            List workflows = this.hospitalWorkflowService.getAllWorkflows(page, size);
            logger.info("\u83b7\u53d6\u6240\u6709\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: page={}, size={}, count={}", new Object[]{page, size, workflows.size()});
            return BaseResponse.success((Object)workflows);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6240\u6709\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: page={}, size={}", new Object[]{page, size, e});
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PutMapping(value={"/update"})
    public BaseResponse<String> updateWorkflow(@RequestBody HospitalWorkflow workflow) {
        try {
            logger.info("\u66f4\u65b0\u5de5\u4f5c\u6d41\u914d\u7f6e: id={}, workflowName={}", (Object)workflow.getId(), (Object)workflow.getWorkflowName());
            boolean success = this.hospitalWorkflowService.updateWorkflow(workflow);
            if (success) {
                logger.info("\u66f4\u65b0\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: id={}", (Object)workflow.getId());
                return BaseResponse.success((Object)"\u5de5\u4f5c\u6d41\u914d\u7f6e\u66f4\u65b0\u6210\u529f");
            }
            logger.warn("\u66f4\u65b0\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: id={}", (Object)workflow.getId());
            return BaseResponse.error((String)"400", (String)"\u5de5\u4f5c\u6d41\u914d\u7f6e\u66f4\u65b0\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5de5\u4f5c\u6d41\u914d\u7f6e\u5f02\u5e38: id={}", (Object)workflow.getId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u5de5\u4f5c\u6d41\u914d\u7f6e\u66f4\u65b0\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PutMapping(value={"/{id}/status"})
    public BaseResponse<String> updateWorkflowStatus(@PathVariable String id, @RequestParam Integer status) {
        try {
            logger.info("\u66f4\u65b0\u5de5\u4f5c\u6d41\u72b6\u6001: id={}, status={}", (Object)id, (Object)status);
            boolean success = this.hospitalWorkflowService.updateWorkflowStatus(id, status);
            if (success) {
                String statusText = status == 1 ? "\u542f\u7528" : "\u7981\u7528";
                logger.info("\u66f4\u65b0\u5de5\u4f5c\u6d41\u72b6\u6001\u6210\u529f: id={}, status={}", (Object)id, (Object)status);
                return BaseResponse.success((Object)("\u5de5\u4f5c\u6d41" + statusText + "\u6210\u529f"));
            }
            logger.warn("\u66f4\u65b0\u5de5\u4f5c\u6d41\u72b6\u6001\u5931\u8d25: id={}, status={}", (Object)id, (Object)status);
            return BaseResponse.error((String)"400", (String)"\u5de5\u4f5c\u6d41\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5de5\u4f5c\u6d41\u72b6\u6001\u5f02\u5e38: id={}, status={}", new Object[]{id, status, e});
            return BaseResponse.error((String)"500", (String)("\u5de5\u4f5c\u6d41\u72b6\u6001\u66f4\u65b0\u5931\u8d25: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/{id}"})
    public BaseResponse<String> deleteWorkflow(@PathVariable String id) {
        try {
            logger.info("\u5220\u9664\u5de5\u4f5c\u6d41\u914d\u7f6e: id={}", (Object)id);
            boolean success = this.hospitalWorkflowService.deleteWorkflow(id);
            if (success) {
                logger.info("\u5220\u9664\u5de5\u4f5c\u6d41\u914d\u7f6e\u6210\u529f: id={}", (Object)id);
                return BaseResponse.success((Object)"\u5de5\u4f5c\u6d41\u914d\u7f6e\u5220\u9664\u6210\u529f");
            }
            logger.warn("\u5220\u9664\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: id={}", (Object)id);
            return BaseResponse.error((String)"400", (String)"\u5de5\u4f5c\u6d41\u914d\u7f6e\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5de5\u4f5c\u6d41\u914d\u7f6e\u5f02\u5e38: id={}", (Object)id, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u5de5\u4f5c\u6d41\u914d\u7f6e\u5220\u9664\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/hospital/{hospitalId}/check"})
    public BaseResponse<Map<String, Object>> checkWorkflowConfig(@PathVariable String hospitalId) {
        try {
            logger.info("\u68c0\u67e5\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId={}", (Object)hospitalId);
            boolean hasConfig = this.hospitalWorkflowService.hasWorkflowConfig(hospitalId);
            String workflowInfo = this.multiWorkflowDifyService.getWorkflowInfo(hospitalId);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("hasConfig", hasConfig);
            result.put("workflowInfo", workflowInfo);
            logger.info("\u68c0\u67e5\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e\u5b8c\u6210: hospitalId={}, hasConfig={}", (Object)hospitalId, (Object)hasConfig);
            return BaseResponse.success(result);
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: hospitalId={}", (Object)hospitalId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u68c0\u67e5\u5de5\u4f5c\u6d41\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/types"})
    public BaseResponse<List<Map<String, String>>> getWorkflowTypes() {
        try {
            ArrayList types = new ArrayList();
            HashMap<String, String> general = new HashMap<String, String>();
            general.put("value", "general");
            general.put("label", "\u901a\u7528\u54a8\u8be2");
            general.put("description", "\u901a\u7528\u533b\u7597\u54a8\u8be2\u670d\u52a1");
            types.add(general);
            HashMap<String, String> emergency = new HashMap<String, String>();
            emergency.put("value", "emergency");
            emergency.put("label", "\u6025\u8bca\u670d\u52a1");
            emergency.put("description", "\u7d27\u6025\u533b\u7597\u60c5\u51b5\u5904\u7406");
            types.add(emergency);
            HashMap<String, String> specialist = new HashMap<String, String>();
            specialist.put("value", "specialist");
            specialist.put("label", "\u4e13\u79d1\u54a8\u8be2");
            specialist.put("description", "\u4e13\u79d1\u533b\u751f\u54a8\u8be2\u670d\u52a1");
            types.add(specialist);
            HashMap<String, String> appointment = new HashMap<String, String>();
            appointment.put("value", "appointment");
            appointment.put("label", "\u9884\u7ea6\u6302\u53f7");
            appointment.put("description", "\u533b\u9662\u9884\u7ea6\u6302\u53f7\u670d\u52a1");
            types.add(appointment);
            HashMap<String, String> consultation = new HashMap<String, String>();
            consultation.put("value", "consultation");
            consultation.put("label", "\u5728\u7ebf\u95ee\u8bca");
            consultation.put("description", "\u5728\u7ebf\u533b\u7597\u54a8\u8be2\u670d\u52a1");
            types.add(consultation);
            HashMap<String, String> guidance = new HashMap<String, String>();
            guidance.put("value", "guidance");
            guidance.put("label", "\u5c31\u533b\u6307\u5bfc");
            guidance.put("description", "\u5c31\u533b\u6d41\u7a0b\u6307\u5bfc\u670d\u52a1");
            types.add(guidance);
            HashMap<String, String> health = new HashMap<String, String>();
            health.put("value", "health");
            health.put("label", "\u5065\u5eb7\u7ba1\u7406");
            health.put("description", "\u5065\u5eb7\u7ba1\u7406\u54a8\u8be2\u670d\u52a1");
            types.add(health);
            logger.info("\u83b7\u53d6\u5de5\u4f5c\u6d41\u7c7b\u578b\u5217\u8868\u6210\u529f: count={}", (Object)types.size());
            return BaseResponse.success(types);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5de5\u4f5c\u6d41\u7c7b\u578b\u5217\u8868\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5de5\u4f5c\u6d41\u7c7b\u578b\u5931\u8d25: " + e.getMessage()));
        }
    }
}

