/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.model.DifySTTRequest;
import com.chdu.ai.model.DifyTTSRequest;
import com.chdu.ai.model.HospitalWorkflow;
import com.chdu.ai.service.DifyTTSService;
import com.chdu.ai.service.HospitalWorkflowService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DifyTTSServiceImpl
implements DifyTTSService {
    private static final Logger logger = LoggerFactory.getLogger(DifyTTSServiceImpl.class);
    @Autowired
    private HospitalWorkflowService hospitalWorkflowService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public InputStream textToSpeech(DifyTTSRequest request) {
        try {
            logger.info("\u5f00\u59cbDify\u6587\u5b57\u8f6c\u8bed\u97f3: \u7528\u6237={}, \u533b\u9662ID={}, \u5de5\u4f5c\u6d41\u7c7b\u578b={}, messageId={}, \u6587\u672c\u957f\u5ea6={}", new Object[]{request.getUser(), request.getHospitalId(), request.getWorkflowType(), request.getMessageId(), request.getText() != null ? request.getText().length() : 0});
            logger.info("\u8c03\u7528Dify API\u751f\u6210\u97f3\u9891");
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(request.getHospitalId(), request.getWorkflowType());
            if (workflow == null) {
                throw new RuntimeException("\u672a\u627e\u5230\u533b\u9662\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e");
            }
            String ttsUrl = workflow.getDifyApiUrl() + "/text-to-audio";
            HttpURLConnection connection = (HttpURLConnection)new URL(ttsUrl).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", "Bearer " + workflow.getDifyApiKey());
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("user", "patient_" + request.getUser() + "_" + request.getHospitalId());
            if (request.getMessageId() != null && !request.getMessageId().trim().isEmpty()) {
                requestBody.put("message_id", request.getMessageId());
                logger.debug("\u4f7f\u7528message_id\u8fdb\u884cTTS: {}", (Object)request.getMessageId());
            } else if (request.getText() != null && !request.getText().trim().isEmpty()) {
                requestBody.put("text", request.getText());
                logger.debug("\u4f7f\u7528text\u8fdb\u884cTTS: {}\u5b57\u7b26", (Object)request.getText().length());
            } else {
                throw new RuntimeException("message_id\u548ctext\u81f3\u5c11\u9700\u8981\u63d0\u4f9b\u4e00\u4e2a");
            }
            String jsonBody = this.objectMapper.writeValueAsString(requestBody);
            connection.getOutputStream().write(jsonBody.getBytes(StandardCharsets.UTF_8));
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                logger.info("Dify TTS\u8bf7\u6c42\u6210\u529f: \u7528\u6237={}", (Object)request.getUser());
                return connection.getInputStream();
            }
            String errorResponse = this.readErrorResponse(connection);
            String errorMsg = String.format("Dify TTS\u8bf7\u6c42\u5931\u8d25: HTTP %d, \u54cd\u5e94: %s", responseCode, errorResponse);
            logger.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        catch (Exception e) {
            logger.error("Dify\u6587\u5b57\u8f6c\u8bed\u97f3\u5931\u8d25: \u7528\u6237={}", (Object)request.getUser(), (Object)e);
            throw new RuntimeException("\u6587\u5b57\u8f6c\u8bed\u97f3\u5931\u8d25: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String speechToText(DifySTTRequest request) {
        try {
            Object writer;
            logger.info("\u5f00\u59cbDify\u8bed\u97f3\u8f6c\u6587\u5b57: \u7528\u6237={}, \u533b\u9662ID={}, \u5de5\u4f5c\u6d41\u7c7b\u578b={}, \u6587\u4ef6\u540d={}", new Object[]{request.getUser(), request.getHospitalId(), request.getWorkflowType(), request.getFileName()});
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(request.getHospitalId(), request.getWorkflowType());
            if (workflow == null) {
                throw new RuntimeException("\u672a\u627e\u5230\u533b\u9662\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e");
            }
            String sttUrl = workflow.getDifyApiUrl() + "/audio-to-text";
            HttpURLConnection connection = (HttpURLConnection)new URL(sttUrl).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", "Bearer " + workflow.getDifyApiKey());
            connection.setDoOutput(true);
            String boundary = "----WebKitFormBoundary" + System.currentTimeMillis();
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            try (OutputStream outputStream = connection.getOutputStream();){
                writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);
                Throwable throwable = null;
                try {
                    ((PrintWriter)writer).append("--").append(boundary).append("\r\n");
                    ((PrintWriter)writer).append("Content-Disposition: form-data; name=\"user\"").append("\r\n");
                    ((PrintWriter)writer).append("\r\n");
                    ((PrintWriter)writer).append(request.getUser()).append("\r\n");
                    if (request.getLanguage() != null && !request.getLanguage().trim().isEmpty()) {
                        ((PrintWriter)writer).append("--").append(boundary).append("\r\n");
                        ((PrintWriter)writer).append("Content-Disposition: form-data; name=\"language\"").append("\r\n");
                        ((PrintWriter)writer).append("\r\n");
                        ((PrintWriter)writer).append(request.getLanguage()).append("\r\n");
                    }
                    ((PrintWriter)writer).append("--").append(boundary).append("\r\n");
                    ((PrintWriter)writer).append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(request.getFileName()).append("\"").append("\r\n");
                    ((PrintWriter)writer).append("Content-Type: ").append(request.getContentType()).append("\r\n");
                    ((PrintWriter)writer).append("\r\n");
                    ((PrintWriter)writer).flush();
                    byte[] audioBytes = Base64.getDecoder().decode(request.getAudioBase64());
                    outputStream.write(audioBytes);
                    ((PrintWriter)writer).append("\r\n");
                    ((PrintWriter)writer).append("--").append(boundary).append("--").append("\r\n");
                    ((PrintWriter)writer).flush();
                }
                catch (Throwable audioBytes) {
                    throwable = audioBytes;
                    throw audioBytes;
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                ((PrintWriter)writer).close();
                            }
                            catch (Throwable audioBytes) {
                                throwable.addSuppressed(audioBytes);
                            }
                        } else {
                            ((PrintWriter)writer).close();
                        }
                    }
                }
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                String errorResponse = this.readErrorResponse(connection);
                String errorMsg = String.format("Dify STT\u8bf7\u6c42\u5931\u8d25: HTTP %d, \u54cd\u5e94: %s", responseCode, errorResponse);
                logger.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            writer = null;
            try {
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                logger.info("Dify STT\u8bf7\u6c42\u6210\u529f: \u7528\u6237={}", (Object)request.getUser());
                String string = response.toString();
                return string;
            }
            catch (Throwable throwable) {
                writer = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (writer != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)writer).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Dify\u8bed\u97f3\u8f6c\u6587\u5b57\u5931\u8d25: \u7528\u6237={}", (Object)request.getUser(), (Object)e);
            throw new RuntimeException("\u8bed\u97f3\u8f6c\u6587\u5b57\u5931\u8d25: " + e.getMessage());
        }
    }

    public boolean isTTSAvailable(String hospitalId, String workflowType) {
        try {
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(hospitalId, workflowType);
            return workflow != null && workflow.getDifyApiUrl() != null && workflow.getDifyApiKey() != null;
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5TTS\u670d\u52a1\u53ef\u7528\u6027\u5931\u8d25: hospitalId={}, workflowType={}", new Object[]{hospitalId, workflowType, e});
            return false;
        }
    }

    public boolean isSTTAvailable(String hospitalId, String workflowType) {
        try {
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(hospitalId, workflowType);
            return workflow != null && workflow.getDifyApiUrl() != null && workflow.getDifyApiKey() != null;
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5STT\u670d\u52a1\u53ef\u7528\u6027\u5931\u8d25: hospitalId={}, workflowType={}", new Object[]{hospitalId, workflowType, e});
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readErrorResponse(HttpURLConnection connection) {
        try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder errorBuilder = new StringBuilder();
            while ((line = errorReader.readLine()) != null) {
                errorBuilder.append(line);
            }
            String string = errorBuilder.toString();
            return string;
        }
        catch (Exception e) {
            return "\u65e0\u6cd5\u8bfb\u53d6\u9519\u8bef\u8be6\u60c5";
        }
    }
}

