/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.PatientSessionMapper;
import com.chdu.ai.model.PatientSession;
import com.chdu.ai.service.PatientSessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PatientSessionServiceImpl
implements PatientSessionService {
    private static final Logger logger = LoggerFactory.getLogger(PatientSessionServiceImpl.class);
    @Autowired
    private PatientSessionMapper patientSessionMapper;

    public PatientSession getOrCreateSession(String patientId, String hospitalId, String workflowType) {
        try {
            String difyUserId;
            PatientSession existingSession;
            logger.info("\u83b7\u53d6\u6216\u521b\u5efa\u60a3\u8005\u4f1a\u8bdd: patientId={}, hospitalId={}, workflowType={}", new Object[]{patientId, hospitalId, workflowType});
            if (patientId == null || patientId.trim().isEmpty()) {
                throw new IllegalArgumentException("\u60a3\u8005ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (hospitalId == null || hospitalId.trim().isEmpty()) {
                throw new IllegalArgumentException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (workflowType == null || workflowType.trim().isEmpty()) {
                workflowType = "general";
            }
            if ((existingSession = this.patientSessionMapper.findActiveSession(patientId, hospitalId, workflowType)) != null) {
                if (existingSession.getId() == null || existingSession.getDifyUserId() == null) {
                    logger.warn("\u73b0\u6709\u4f1a\u8bdd\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u5c06\u521b\u5efa\u65b0\u4f1a\u8bdd: sessionId={}, difyUserId={}", (Object)existingSession.getId(), (Object)existingSession.getDifyUserId());
                } else {
                    logger.info("\u627e\u5230\u73b0\u6709\u6d3b\u8dc3\u4f1a\u8bdd: sessionId={}, difyUserId={}, difyConversationId={}", new Object[]{existingSession.getId(), existingSession.getDifyUserId(), existingSession.getDifyConversationId()});
                    return existingSession;
                }
            }
            if ((difyUserId = this.generateDifyUserId(patientId, hospitalId)) == null || difyUserId.trim().isEmpty()) {
                throw new RuntimeException("\u751f\u6210DifyUserId\u5931\u8d25");
            }
            PatientSession newSession = new PatientSession(patientId, difyUserId, null, hospitalId, workflowType);
            int insertResult = this.patientSessionMapper.insert(newSession);
            if (insertResult <= 0) {
                throw new RuntimeException("\u63d2\u5165\u60a3\u8005\u4f1a\u8bdd\u8bb0\u5f55\u5931\u8d25");
            }
            if (newSession.getId() == null) {
                throw new RuntimeException("\u63d2\u5165\u540e\u672a\u80fd\u83b7\u53d6\u4f1a\u8bddID");
            }
            logger.info("\u521b\u5efa\u65b0\u7684\u60a3\u8005\u4f1a\u8bdd: sessionId={}, difyUserId={}", (Object)newSession.getId(), (Object)newSession.getDifyUserId());
            return newSession;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6216\u521b\u5efa\u60a3\u8005\u4f1a\u8bdd\u5931\u8d25: patientId={}, hospitalId={}, workflowType={}", new Object[]{patientId, hospitalId, workflowType, e});
            throw new RuntimeException("\u83b7\u53d6\u6216\u521b\u5efa\u60a3\u8005\u4f1a\u8bdd\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public void updateDifyConversationId(Long sessionId, String difyConversationId) {
        try {
            logger.info("\u66f4\u65b0Dify\u4f1a\u8bddID: sessionId={}, difyConversationId={}", (Object)sessionId, (Object)difyConversationId);
            PatientSession session = this.patientSessionMapper.findById(sessionId);
            if (session != null) {
                session.setDifyConversationId(difyConversationId);
                this.patientSessionMapper.updateSession(session);
                logger.info("Dify\u4f1a\u8bddID\u66f4\u65b0\u6210\u529f: sessionId={}", (Object)sessionId);
            } else {
                logger.warn("\u672a\u627e\u5230\u4f1a\u8bdd\u8bb0\u5f55: sessionId={}", (Object)sessionId);
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0Dify\u4f1a\u8bddID\u5931\u8d25: sessionId={}, difyConversationId={}", new Object[]{sessionId, difyConversationId, e});
            throw new RuntimeException("\u66f4\u65b0Dify\u4f1a\u8bddID\u5931\u8d25: " + e.getMessage());
        }
    }

    public void endSession(Long sessionId) {
        try {
            logger.info("\u7ed3\u675f\u60a3\u8005\u4f1a\u8bdd: sessionId={}", (Object)sessionId);
            int updated = this.patientSessionMapper.endSession(sessionId);
            if (updated > 0) {
                logger.info("\u60a3\u8005\u4f1a\u8bdd\u7ed3\u675f\u6210\u529f: sessionId={}", (Object)sessionId);
            } else {
                logger.warn("\u672a\u627e\u5230\u8981\u7ed3\u675f\u7684\u4f1a\u8bdd: sessionId={}", (Object)sessionId);
            }
        }
        catch (Exception e) {
            logger.error("\u7ed3\u675f\u60a3\u8005\u4f1a\u8bdd\u5931\u8d25: sessionId={}", (Object)sessionId, (Object)e);
            throw new RuntimeException("\u7ed3\u675f\u60a3\u8005\u4f1a\u8bdd\u5931\u8d25: " + e.getMessage());
        }
    }

    public PatientSession findActiveSession(String patientId, String hospitalId, String workflowType) {
        try {
            return this.patientSessionMapper.findActiveSession(patientId, hospitalId, workflowType);
        }
        catch (Exception e) {
            logger.error("\u67e5\u627e\u6d3b\u8dc3\u4f1a\u8bdd\u5931\u8d25: patientId={}, hospitalId={}, workflowType={}", new Object[]{patientId, hospitalId, workflowType, e});
            return null;
        }
    }

    public PatientSession findByDifyConversationId(String difyConversationId) {
        try {
            return this.patientSessionMapper.findByDifyConversationId(difyConversationId);
        }
        catch (Exception e) {
            logger.error("\u6839\u636eDify\u4f1a\u8bddID\u67e5\u627e\u4f1a\u8bdd\u5931\u8d25: difyConversationId={}", (Object)difyConversationId, (Object)e);
            return null;
        }
    }

    private String generateDifyUserId(String patientId, String hospitalId) {
        return "patient_" + patientId + "_" + hospitalId;
    }
}

