/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.TTSAudioCacheMapper;
import com.chdu.ai.model.TTSAudioCache;
import com.chdu.ai.service.OSSService;
import com.chdu.ai.service.TTSCacheService;
import com.chdu.ai.util.AudioDurationUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TTSCacheServiceImpl
implements TTSCacheService {
    private static final Logger logger = LoggerFactory.getLogger(TTSCacheServiceImpl.class);
    @Autowired
    private TTSAudioCacheMapper cacheMapper;
    @Autowired
    private OSSService ossService;
    @Value(value="${aliyun.oss.bucketName:byh-im-file}")
    private String ossBucketName;

    public TTSAudioCache findCachedAudio(String messageId, String textContent, String hospitalId, String workflowType) {
        try {
            String textHash;
            List caches;
            TTSAudioCache cache;
            if (messageId != null && !messageId.trim().isEmpty() && (cache = this.cacheMapper.findByMessageId(messageId)) != null) {
                logger.info("\u901a\u8fc7messageId\u627e\u5230\u7f13\u5b58: messageId={}, cacheId={}", (Object)messageId, (Object)cache.getId());
                return cache;
            }
            if (textContent != null && !textContent.trim().isEmpty() && !(caches = this.cacheMapper.findByTextHash(textHash = this.generateTextHash(textContent), hospitalId, workflowType)).isEmpty()) {
                TTSAudioCache cache2 = (TTSAudioCache)caches.get(0);
                logger.info("\u901a\u8fc7\u6587\u672c\u54c8\u5e0c\u627e\u5230\u7f13\u5b58: textHash={}, cacheId={}", (Object)textHash, (Object)cache2.getId());
                return cache2;
            }
            logger.debug("\u672a\u627e\u5230\u7f13\u5b58: messageId={}, hospitalId={}, workflowType={}", new Object[]{messageId, hospitalId, workflowType});
            return null;
        }
        catch (Exception e) {
            logger.error("\u67e5\u627e\u7f13\u5b58\u5931\u8d25: messageId={}, hospitalId={}, workflowType={}", new Object[]{messageId, hospitalId, workflowType, e});
            return null;
        }
    }

    public TTSAudioCache cacheAudioFile(String messageId, String textContent, String hospitalId, String workflowType, String userId, InputStream audioStream, long fileSize, Double duration) {
        try {
            String cacheKey = this.generateCacheKey(messageId, textContent, hospitalId, workflowType);
            String textHash = this.generateTextHash(textContent != null ? textContent : "");
            TTSAudioCache existingCache = this.cacheMapper.findByCacheKey(cacheKey);
            String objectKey = this.generateOSSObjectKey(hospitalId, workflowType, cacheKey);
            byte[] audioBytes = this.readInputStreamToBytes(audioStream);
            Double audioDuration = duration;
            if (audioDuration == null) {
                audioDuration = AudioDurationUtil.calculateDurationSmart((byte[])audioBytes, (String)"audio/wav");
                if (audioDuration != null) {
                    logger.debug("\u8ba1\u7b97\u97f3\u9891\u65f6\u957f: {} \u79d2", (Object)audioDuration);
                } else {
                    logger.warn("\u65e0\u6cd5\u8ba1\u7b97\u97f3\u9891\u65f6\u957f");
                }
            }
            String ossUrl = this.ossService.uploadFile(this.ossBucketName, objectKey, (InputStream)new ByteArrayInputStream(audioBytes), (long)audioBytes.length, "audio/wav");
            if (existingCache != null) {
                existingCache.setOssUrl(ossUrl);
                existingCache.setFileSize(Long.valueOf(audioBytes.length));
                existingCache.setDuration(audioDuration);
                existingCache.setTextContent(textContent);
                existingCache.setTextHash(textHash);
                existingCache.setLastHitTime(new Date());
                existingCache.setUpdateTime(new Date());
                this.cacheMapper.updateById(existingCache);
                logger.info("\u97f3\u9891\u6587\u4ef6\u7f13\u5b58\u66f4\u65b0\u6210\u529f: messageId={}, cacheKey={}, ossUrl={}, fileSize={}, duration={}s", new Object[]{messageId, cacheKey, ossUrl, audioBytes.length, audioDuration});
                return existingCache;
            }
            TTSAudioCache cache = new TTSAudioCache();
            cache.setCacheKey(cacheKey);
            cache.setMessageId(messageId);
            cache.setTextContent(textContent);
            cache.setTextHash(textHash);
            cache.setHospitalId(hospitalId);
            cache.setWorkflowType(workflowType);
            cache.setUserId(userId);
            cache.setOssUrl(ossUrl);
            cache.setFileSize(Long.valueOf(audioBytes.length));
            cache.setDuration(audioDuration);
            cache.setHitCount(Integer.valueOf(1));
            cache.setLastHitTime(new Date());
            cache.setStatus(Integer.valueOf(1));
            this.cacheMapper.insert(cache);
            logger.info("\u97f3\u9891\u6587\u4ef6\u7f13\u5b58\u6210\u529f: messageId={}, cacheKey={}, ossUrl={}, fileSize={}, duration={}s", new Object[]{messageId, cacheKey, ossUrl, audioBytes.length, audioDuration});
            return cache;
        }
        catch (Exception e) {
            logger.error("\u7f13\u5b58\u97f3\u9891\u6587\u4ef6\u5931\u8d25: messageId={}, hospitalId={}, workflowType={}", new Object[]{messageId, hospitalId, workflowType, e});
            throw new RuntimeException("\u7f13\u5b58\u97f3\u9891\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
        }
    }

    public void updateHitCount(Long cacheId) {
        try {
            this.cacheMapper.updateHitInfo(cacheId, null, new Date());
            logger.debug("\u66f4\u65b0\u7f13\u5b58\u547d\u4e2d\u6b21\u6570: cacheId={}", (Object)cacheId);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u7f13\u5b58\u547d\u4e2d\u6b21\u6570\u5931\u8d25: cacheId={}", (Object)cacheId, (Object)e);
        }
    }

    public boolean deleteCache(Long cacheId) {
        try {
            int updated = this.cacheMapper.updateStatus(cacheId, Integer.valueOf(0));
            if (updated > 0) {
                logger.info("\u5220\u9664\u7f13\u5b58\u8bb0\u5f55\u6210\u529f: cacheId={}", (Object)cacheId);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u7f13\u5b58\u8bb0\u5f55\u5931\u8d25: cacheId={}", (Object)cacheId, (Object)e);
            return false;
        }
    }

    public String generateCacheKey(String messageId, String textContent, String hospitalId, String workflowType) {
        try {
            StringBuilder keyBuilder = new StringBuilder();
            if (messageId != null && !messageId.trim().isEmpty()) {
                keyBuilder.append("mid:").append(messageId);
            }
            if (textContent != null && !textContent.trim().isEmpty()) {
                keyBuilder.append("txt:").append(textContent);
            }
            keyBuilder.append("h:").append(hospitalId).append("w:").append(workflowType);
            return this.generateMD5Hash(keyBuilder.toString());
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u7f13\u5b58\u952e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private String generateTextHash(String textContent) {
        return this.generateMD5Hash(textContent != null ? textContent : "");
    }

    private String generateMD5Hash(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hashBytes = md.digest(input.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte b : hashBytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error("\u751f\u6210MD5\u54c8\u5e0c\u5931\u8d25: input={}", (Object)input, (Object)e);
            return String.valueOf(input.hashCode());
        }
    }

    private String generateOSSObjectKey(String hospitalId, String workflowType, String cacheKey) {
        String datePath = new SimpleDateFormat("yyyy/MM/dd").format(new Date());
        return String.format("tts/%s/%s/%s/%s.wav", hospitalId, workflowType, datePath, cacheKey);
    }

    private byte[] readInputStreamToBytes(InputStream inputStream) throws Exception {
        int bytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        return baos.toByteArray();
    }
}

