/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AudioDurationUtil {
    private static final Logger logger = LoggerFactory.getLogger(AudioDurationUtil.class);

    public static Double calculateDuration(InputStream audioStream) {
        try {
            if (audioStream.markSupported()) {
                audioStream.reset();
            }
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(audioStream);
            AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(audioInputStream);
            long frameLength = audioFileFormat.getFrameLength();
            float frameRate = audioFileFormat.getFormat().getFrameRate();
            if (frameLength != -1L && frameRate != -1.0f) {
                double duration = (float)frameLength / frameRate;
                logger.debug("\u97f3\u9891\u65f6\u957f\u8ba1\u7b97\u6210\u529f: {} \u79d2", (Object)duration);
                return duration;
            }
            logger.warn("\u65e0\u6cd5\u83b7\u53d6\u97f3\u9891\u5e27\u4fe1\u606f\u6765\u8ba1\u7b97\u65f6\u957f");
            return null;
        }
        catch (Exception e) {
            logger.warn("\u8ba1\u7b97\u97f3\u9891\u65f6\u957f\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u97f3\u9891\u683c\u5f0f\u4e0d\u652f\u6301: {}", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Double calculateDuration(byte[] audioBytes) {
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(audioBytes);){
            Double d = AudioDurationUtil.calculateDuration((InputStream)byteStream);
            return d;
        }
        catch (Exception e) {
            logger.warn("\u8ba1\u7b97\u5b57\u8282\u6570\u7ec4\u97f3\u9891\u65f6\u957f\u5931\u8d25: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static Double calculateDurationSmart(byte[] audioBytes, String contentType) {
        Double sizeBasedDuration;
        Double duration = AudioDurationUtil.calculateDuration((byte[])audioBytes);
        if (duration != null) {
            return duration;
        }
        if (contentType != null) {
            Double wavDuration;
            double estimatedDuration;
            String lowerContentType = contentType.toLowerCase();
            if (lowerContentType.contains("mp3") && (estimatedDuration = AudioDurationUtil.estimateMP3Duration((long)audioBytes.length)) > 0.0) {
                logger.info("\u4f7f\u7528MP3\u65f6\u957f\u4f30\u7b97: {} \u79d2", (Object)estimatedDuration);
                return estimatedDuration;
            }
            if (lowerContentType.contains("wav") && (wavDuration = AudioDurationUtil.parseWAVDuration((byte[])audioBytes)) != null) {
                logger.info("\u89e3\u6790WAV\u6587\u4ef6\u65f6\u957f: {} \u79d2", (Object)wavDuration);
                return wavDuration;
            }
        }
        if ((sizeBasedDuration = AudioDurationUtil.estimateDurationBySize((long)audioBytes.length, (String)contentType)) != null) {
            return sizeBasedDuration;
        }
        logger.warn("\u65e0\u6cd5\u8ba1\u7b97\u97f3\u9891\u65f6\u957f\uff0c\u683c\u5f0f\u53ef\u80fd\u4e0d\u652f\u6301: {}", (Object)contentType);
        return null;
    }

    private static double estimateMP3Duration(long fileSizeBytes) {
        double bitrateKbps = 128.0;
        double bitrateBytesPerSecond = bitrateKbps * 1000.0 / 8.0;
        double durationSeconds = (double)fileSizeBytes / bitrateBytesPerSecond;
        if (durationSeconds < 1.0 || durationSeconds > 3600.0) {
            return -1.0;
        }
        return durationSeconds;
    }

    private static Double parseWAVDuration(byte[] audioBytes) {
        try {
            int bitsPerSample;
            int channels;
            if (audioBytes.length < 44) {
                return null;
            }
            if (audioBytes[0] != 82 || audioBytes[1] != 73 || audioBytes[2] != 70 || audioBytes[3] != 70) {
                return null;
            }
            int fmtChunkOffset = AudioDurationUtil.findChunk((byte[])audioBytes, (String)"fmt ");
            if (fmtChunkOffset == -1) {
                return null;
            }
            int sampleRate = AudioDurationUtil.readLittleEndianInt((byte[])audioBytes, (int)(fmtChunkOffset + 12));
            int dataChunkOffset = AudioDurationUtil.findChunk((byte[])audioBytes, (String)"data");
            if (dataChunkOffset == -1) {
                return null;
            }
            int dataSize = AudioDurationUtil.readLittleEndianInt((byte[])audioBytes, (int)(dataChunkOffset + 4));
            double duration = (double)dataSize / (double)(sampleRate * (channels = 1) * (bitsPerSample = 16) / 8);
            return duration > 0.0 ? Double.valueOf(duration) : null;
        }
        catch (Exception e) {
            logger.debug("\u89e3\u6790WAV\u6587\u4ef6\u65f6\u957f\u5931\u8d25: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static int findChunk(byte[] audioBytes, String chunkName) {
        byte[] chunkBytes = chunkName.getBytes();
        for (int i = 8; i < audioBytes.length - 8; ++i) {
            boolean found = true;
            for (int j = 0; j < chunkBytes.length; ++j) {
                if (audioBytes[i + j] == chunkBytes[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    private static int readLittleEndianInt(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 24;
    }

    public static String formatDuration(Double durationSeconds) {
        if (durationSeconds == null) {
            return "\u672a\u77e5";
        }
        int minutes = (int)(durationSeconds / 60.0);
        int seconds = (int)(durationSeconds % 60.0);
        return String.format("%d:%02d", minutes, seconds);
    }

    public static boolean isSupportedAudioFormat(String contentType) {
        if (contentType == null) {
            return false;
        }
        String lowerContentType = contentType.toLowerCase();
        return lowerContentType.startsWith("audio/") && (lowerContentType.contains("wav") || lowerContentType.contains("mp3") || lowerContentType.contains("m4a") || lowerContentType.contains("aac"));
    }

    public static Double estimateDurationBySize(long fileSizeBytes, String contentType) {
        if (contentType == null || fileSizeBytes <= 0L) {
            return null;
        }
        String lowerContentType = contentType.toLowerCase();
        double estimatedDuration = -1.0;
        estimatedDuration = lowerContentType.contains("mp3") ? (double)fileSizeBytes / 16000.0 : (lowerContentType.contains("wav") ? (double)(fileSizeBytes / 88200L) : (lowerContentType.contains("m4a") || lowerContentType.contains("aac") ? (double)fileSizeBytes / 16000.0 : (double)fileSizeBytes / 8000.0));
        if (estimatedDuration > 0.0 && estimatedDuration <= 3600.0) {
            logger.info("\u4f7f\u7528\u6587\u4ef6\u5927\u5c0f\u4f30\u7b97\u65f6\u957f: {} \u79d2 (\u683c\u5f0f: {})", (Object)estimatedDuration, (Object)contentType);
            return estimatedDuration;
        }
        return null;
    }
}

