/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.config;

import javax.servlet.MultipartConfigElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;

@Configuration
public class MultipartConfig {
    private static final Logger logger = LoggerFactory.getLogger(MultipartConfig.class);

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(DataSize.ofMegabytes((long)500L));
        factory.setMaxRequestSize(DataSize.ofMegabytes((long)500L));
        factory.setFileSizeThreshold(DataSize.ofKilobytes((long)2L));
        MultipartConfigElement configElement = factory.createMultipartConfig();
        logger.info("\u6587\u4ef6\u4e0a\u4f20\u914d\u7f6e\u5df2\u751f\u6548: maxFileSize=500MB, maxRequestSize=500MB, fileSizeThreshold=2KB");
        return configElement;
    }
}

