/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.ShoppingCart;
import com.chdu.ai.model.ShoppingCartRequest;
import com.chdu.ai.service.ShoppingCartService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/shopping-cart"})
@CrossOrigin(origins={"*"})
public class ShoppingCartController {
    private static final Logger logger = LoggerFactory.getLogger(ShoppingCartController.class);
    @Autowired
    private ShoppingCartService shoppingCartService;

    @PostMapping(value={"/add"})
    public BaseResponse<ShoppingCart> add(@RequestBody ShoppingCartRequest request) {
        try {
            logger.info("\u6dfb\u52a0\u5546\u54c1\u5230\u8d2d\u7269\u8f66: userId={}, productId={}, quantity={}", new Object[]{request.getUserId(), request.getProductId(), request.getQuantity()});
            if (request.getUserId() == null || request.getUserId().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getProductId() == null) {
                return BaseResponse.error((String)"400", (String)"\u4ea7\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getQuantity() == null || request.getQuantity() <= 0) {
                return BaseResponse.error((String)"400", (String)"\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            }
            ShoppingCart cart = new ShoppingCart();
            cart.setUserId(request.getUserId());
            cart.setUserType(request.getUserType());
            cart.setProductId(request.getProductId());
            cart.setQuantity(request.getQuantity());
            cart.setHospitalId(request.getHospitalId());
            ShoppingCart result = this.shoppingCartService.addToCart(cart);
            logger.info("\u6dfb\u52a0\u5546\u54c1\u5230\u8d2d\u7269\u8f66\u6210\u529f: id={}", (Object)result.getId());
            return BaseResponse.success((Object)result);
        }
        catch (RuntimeException e) {
            logger.error("\u6dfb\u52a0\u5546\u54c1\u5230\u8d2d\u7269\u8f66\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"400", (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u5546\u54c1\u5230\u8d2d\u7269\u8f66\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u6dfb\u52a0\u5546\u54c1\u5230\u8d2d\u7269\u8f66\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/{userId}"})
    public BaseResponse<List<ShoppingCart>> getByUserId(@PathVariable String userId) {
        try {
            logger.info("\u67e5\u8be2\u7528\u6237\u8d2d\u7269\u8f66: userId={}", (Object)userId);
            List result = this.shoppingCartService.getByUserId(userId);
            logger.info("\u67e5\u8be2\u7528\u6237\u8d2d\u7269\u8f66\u6210\u529f: userId={}, \u6570\u91cf={}", (Object)userId, (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7528\u6237\u8d2d\u7269\u8f66\u5931\u8d25: userId={}", (Object)userId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u7528\u6237\u8d2d\u7269\u8f66\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public BaseResponse<String> update(@RequestBody ShoppingCartRequest request) {
        try {
            logger.info("\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf: id={}, quantity={}", (Object)request.getId(), (Object)request.getQuantity());
            if (request.getId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getQuantity() == null || request.getQuantity() <= 0) {
                return BaseResponse.error((String)"400", (String)"\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            }
            boolean success = this.shoppingCartService.updateQuantity(request.getId(), request.getQuantity());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8d2d\u7269\u8f66\u8bb0\u5f55\u53ef\u80fd\u4e0d\u5b58\u5728\u6216\u5e93\u5b58\u4e0d\u8db3");
            }
            logger.info("\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf\u6210\u529f: id={}", (Object)request.getId());
            return BaseResponse.success((Object)"\u66f4\u65b0\u6210\u529f");
        }
        catch (RuntimeException e) {
            logger.error("\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"400", (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf\u5931\u8d25: id={}", (Object)request.getId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/delete"})
    public BaseResponse<String> delete(@RequestBody ShoppingCartRequest request) {
        try {
            logger.info("\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1: id={}", (Object)request.getId());
            if (request.getId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.shoppingCartService.deleteById(request.getId());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u5220\u9664\u5931\u8d25\uff0c\u8d2d\u7269\u8f66\u8bb0\u5f55\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            logger.info("\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u6210\u529f: id={}", (Object)request.getId());
            return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u5931\u8d25: id={}", (Object)request.getId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/clear"})
    public BaseResponse<String> clear(@RequestBody ShoppingCartRequest request) {
        try {
            logger.info("\u6e05\u7a7a\u8d2d\u7269\u8f66: userId={}", (Object)request.getUserId());
            if (request.getUserId() == null || request.getUserId().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.shoppingCartService.clearCart(request.getUserId());
            logger.info("\u6e05\u7a7a\u8d2d\u7269\u8f66\u6210\u529f: userId={}", (Object)request.getUserId());
            return BaseResponse.success((Object)"\u6e05\u7a7a\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u6e05\u7a7a\u8d2d\u7269\u8f66\u5931\u8d25: userId={}", (Object)request.getUserId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u6e05\u7a7a\u8d2d\u7269\u8f66\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/batch-delete"})
    public BaseResponse<String> batchDelete(@RequestBody ShoppingCartRequest request) {
        try {
            logger.info("\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1: userId={}, productIds={}", (Object)request.getUserId(), (Object)request.getProductIds());
            if (request.getUserId() == null || request.getUserId().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getProductIds() == null || request.getProductIds().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u4ea7\u54c1ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.shoppingCartService.deleteByUserIdAndProductIds(request.getUserId(), request.getProductIds());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u6279\u91cf\u5220\u9664\u5931\u8d25");
            }
            logger.info("\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u6210\u529f: userId={}", (Object)request.getUserId());
            return BaseResponse.success((Object)"\u6279\u91cf\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u5931\u8d25: userId={}", (Object)request.getUserId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u5931\u8d25: " + e.getMessage()));
        }
    }
}

