/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.ProductCategoryMapper;
import com.chdu.ai.model.ProductCategory;
import com.chdu.ai.service.ProductCategoryService;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductCategoryServiceImpl
implements ProductCategoryService {
    private static final Logger logger = LoggerFactory.getLogger(ProductCategoryServiceImpl.class);
    private static final String CACHE_KEY_PREFIX = "product:category:";
    private static final String CACHE_KEY_ALL = "product:category:all";
    private static final String CACHE_KEY_TYPE = "product:category:type:";
    private static final String CACHE_KEY_PARENT = "product:category:parent:";
    private static final long CACHE_EXPIRE_HOURS = 24L;
    @Autowired
    private ProductCategoryMapper productCategoryMapper;
    @Autowired(required=false)
    private StringRedisTemplate redisTemplate;
    private Gson gson = new Gson();

    @Transactional
    public ProductCategory create(ProductCategory productCategory) {
        if (productCategory.getParentId() == null) {
            productCategory.setParentId(Long.valueOf(0L));
        }
        if (productCategory.getStatus() == null) {
            productCategory.setStatus(Integer.valueOf(1));
        }
        if (productCategory.getSortOrder() == null) {
            productCategory.setSortOrder(Integer.valueOf(0));
        }
        if (productCategory.getCreateTime() == null) {
            productCategory.setCreateTime(new Date());
        }
        if (productCategory.getUpdateTime() == null) {
            productCategory.setUpdateTime(new Date());
        }
        this.productCategoryMapper.insert(productCategory);
        this.clearCache();
        return this.productCategoryMapper.selectById(productCategory.getId());
    }

    public ProductCategory getById(Long id) {
        return this.productCategoryMapper.selectById(id);
    }

    public ProductCategory getByCategoryCode(String categoryCode) {
        return this.productCategoryMapper.selectByCategoryCode(categoryCode);
    }

    public List<ProductCategory> getAll() {
        if (this.redisTemplate != null) {
            try {
                String cached = (String)this.redisTemplate.opsForValue().get((Object)CACHE_KEY_ALL);
                if (cached != null) {
                    Type listType = new /* Unavailable Anonymous Inner Class!! */.getType();
                    List result = (List)this.gson.fromJson(cached, listType);
                    logger.debug("\u4ece\u7f13\u5b58\u83b7\u53d6\u6240\u6709\u5206\u7c7b");
                    return result;
                }
            }
            catch (Exception e) {
                logger.warn("\u4ece\u7f13\u5b58\u83b7\u53d6\u5206\u7c7b\u5931\u8d25", (Throwable)e);
            }
        }
        List result = this.productCategoryMapper.selectAll();
        if (this.redisTemplate != null && result != null) {
            try {
                String json = this.gson.toJson((Object)result);
                this.redisTemplate.opsForValue().set((Object)CACHE_KEY_ALL, (Object)json, 24L, TimeUnit.HOURS);
            }
            catch (Exception e) {
                logger.warn("\u5b58\u5165\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            }
        }
        return result;
    }

    public List<ProductCategory> getByParentId(Long parentId) {
        return this.productCategoryMapper.selectByParentId(parentId);
    }

    public List<ProductCategory> getByCategoryType(String categoryType) {
        if (this.redisTemplate != null) {
            try {
                String cacheKey = CACHE_KEY_TYPE + categoryType;
                String cached = (String)this.redisTemplate.opsForValue().get((Object)cacheKey);
                if (cached != null) {
                    Type listType = new /* Unavailable Anonymous Inner Class!! */.getType();
                    List result = (List)this.gson.fromJson(cached, listType);
                    logger.debug("\u4ece\u7f13\u5b58\u83b7\u53d6\u5206\u7c7b: type={}", (Object)categoryType);
                    return result;
                }
            }
            catch (Exception e) {
                logger.warn("\u4ece\u7f13\u5b58\u83b7\u53d6\u5206\u7c7b\u5931\u8d25: type={}", (Object)categoryType, (Object)e);
            }
        }
        List result = this.productCategoryMapper.selectByCategoryType(categoryType);
        if (this.redisTemplate != null && result != null) {
            try {
                String cacheKey = CACHE_KEY_TYPE + categoryType;
                String json = this.gson.toJson((Object)result);
                this.redisTemplate.opsForValue().set((Object)cacheKey, (Object)json, 24L, TimeUnit.HOURS);
            }
            catch (Exception e) {
                logger.warn("\u5b58\u5165\u7f13\u5b58\u5931\u8d25: type={}", (Object)categoryType, (Object)e);
            }
        }
        return result;
    }

    public List<ProductCategory> getByHospitalId(String hospitalId) {
        return this.productCategoryMapper.selectByHospitalId(hospitalId);
    }

    @Transactional
    public boolean update(ProductCategory productCategory) {
        boolean result;
        boolean bl = result = this.productCategoryMapper.update(productCategory) > 0;
        if (result) {
            this.clearCache();
        }
        return result;
    }

    @Transactional
    public boolean updateStatus(Long id, Integer status) {
        boolean result;
        boolean bl = result = this.productCategoryMapper.updateStatus(id, status) > 0;
        if (result) {
            this.clearCache();
        }
        return result;
    }

    @Transactional
    public boolean deleteById(Long id) {
        boolean result;
        boolean bl = result = this.productCategoryMapper.deleteById(id) > 0;
        if (result) {
            this.clearCache();
        }
        return result;
    }

    private void clearCache() {
        if (this.redisTemplate != null) {
            try {
                this.redisTemplate.delete((Object)CACHE_KEY_ALL);
                this.redisTemplate.delete((Collection)this.redisTemplate.keys((Object)"product:category:type:*"));
                this.redisTemplate.delete((Collection)this.redisTemplate.keys((Object)"product:category:parent:*"));
                logger.debug("\u6e05\u9664\u4ea7\u54c1\u5206\u7c7b\u7f13\u5b58");
            }
            catch (Exception e) {
                logger.warn("\u6e05\u9664\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

