/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.ProductMapper;
import com.chdu.ai.mapper.ProductOrderItemMapper;
import com.chdu.ai.mapper.ProductOrderMapper;
import com.chdu.ai.mapper.ShoppingCartMapper;
import com.chdu.ai.model.Product;
import com.chdu.ai.model.ProductOrder;
import com.chdu.ai.model.ProductOrderItem;
import com.chdu.ai.model.ServiceMerchantConfig;
import com.chdu.ai.model.ShoppingCart;
import com.chdu.ai.service.ProductOrderService;
import com.chdu.ai.service.ProductService;
import com.chdu.ai.service.ServiceMerchantConfigService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductOrderServiceImpl
implements ProductOrderService {
    private static final Logger logger = LoggerFactory.getLogger(ProductOrderServiceImpl.class);
    @Autowired
    private ProductOrderMapper productOrderMapper;
    @Autowired
    private ProductOrderItemMapper productOrderItemMapper;
    @Autowired
    private ShoppingCartMapper shoppingCartMapper;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductMapper productMapper;
    @Autowired(required=false)
    private ServiceMerchantConfigService serviceMerchantConfigService;

    private String generateOrderNo() {
        return "PO" + System.currentTimeMillis() + (int)(Math.random() * 1000.0);
    }

    @Transactional
    public ProductOrder createOrderFromCart(String userId, String userType, List<Long> cartIds, String shippingAddress, String contactName, String contactPhone, String remark, String hospitalId) {
        if (cartIds == null || cartIds.isEmpty()) {
            throw new RuntimeException("\u8d2d\u7269\u8f66\u4e3a\u7a7a");
        }
        ArrayList<ShoppingCart> cartItems = new ArrayList<ShoppingCart>();
        for (Long cartId : cartIds) {
            ShoppingCart cart = this.shoppingCartMapper.selectById(cartId);
            if (cart == null || !cart.getUserId().equals(userId)) {
                throw new RuntimeException("\u8d2d\u7269\u8f66\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237");
            }
            cartItems.add(cart);
        }
        if (cartItems.isEmpty()) {
            throw new RuntimeException("\u8d2d\u7269\u8f66\u4e3a\u7a7a");
        }
        ProductOrder order = new ProductOrder();
        order.setOrderNo(this.generateOrderNo());
        order.setUserId(userId);
        order.setUserType(userType);
        order.setHospitalId(hospitalId);
        order.setOrderStatus("PENDING");
        order.setPaymentStatus("UNPAID");
        order.setShippingAddress(shippingAddress);
        order.setContactName(contactName);
        order.setContactPhone(contactPhone);
        order.setRemark(remark);
        order.setCreateTime(new Date());
        order.setUpdateTime(new Date());
        BigDecimal totalAmount = BigDecimal.ZERO;
        ArrayList<ProductOrderItem> orderItems = new ArrayList<ProductOrderItem>();
        for (ShoppingCart cart : cartItems) {
            Product product = this.productService.getById(cart.getProductId());
            if (product == null || product.getStatus() != 1) {
                throw new RuntimeException("\u4ea7\u54c1\u4e0d\u5b58\u5728\u6216\u5df2\u4e0b\u67b6: " + cart.getProductId());
            }
            if (!this.productService.checkStock(cart.getProductId(), cart.getQuantity())) {
                throw new RuntimeException("\u5e93\u5b58\u4e0d\u8db3: " + product.getProductName());
            }
            ProductOrderItem item = new ProductOrderItem();
            item.setOrderNo(order.getOrderNo());
            item.setProductId(product.getId());
            item.setProductCode(product.getProductCode());
            item.setProductName(product.getProductName());
            item.setProductImageUrl(product.getMainImageUrl());
            item.setPrice(product.getPrice());
            item.setQuantity(cart.getQuantity());
            item.setSubtotal(product.getPrice().multiply(new BigDecimal(cart.getQuantity())));
            item.setCreateTime(new Date());
            orderItems.add(item);
            totalAmount = totalAmount.add(item.getSubtotal());
        }
        order.setTotalAmount(totalAmount);
        order.setDiscountAmount(BigDecimal.ZERO);
        order.setPayAmount(totalAmount);
        this.productOrderMapper.insert(order);
        for (ProductOrderItem item : orderItems) {
            item.setOrderId(order.getId());
        }
        this.productOrderItemMapper.batchInsert(orderItems);
        for (ShoppingCart cart : cartItems) {
            this.productService.decreaseStock(cart.getProductId(), cart.getQuantity());
        }
        for (Long cartId : cartIds) {
            this.shoppingCartMapper.deleteById(cartId);
        }
        ProductOrder result = this.productOrderMapper.selectById(order.getId());
        if (result != null) {
            List items = this.productOrderItemMapper.selectByOrderId(order.getId());
            result.setOrderItems(items);
        }
        return result;
    }

    public ProductOrder getById(Long id) {
        ProductOrder order = this.productOrderMapper.selectById(id);
        if (order != null) {
            List items = this.productOrderItemMapper.selectByOrderId(id);
            order.setOrderItems(items);
        }
        return order;
    }

    public ProductOrder getByOrderNo(String orderNo) {
        ProductOrder order = this.productOrderMapper.selectByOrderNo(orderNo);
        if (order != null) {
            List items = this.productOrderItemMapper.selectByOrderNo(orderNo);
            order.setOrderItems(items);
        }
        return order;
    }

    public List<ProductOrder> getByCondition(String userId, String userType, String hospitalId, String orderStatus, String paymentStatus, String orderNo, int page, int size) {
        int offset = page * size;
        return this.productOrderMapper.selectByCondition(userId, userType, hospitalId, orderStatus, paymentStatus, orderNo, size, offset);
    }

    public List<ProductOrder> getByUserId(String userId) {
        return this.productOrderMapper.selectByUserId(userId);
    }

    public List<ProductOrder> getByOrderStatus(String orderStatus) {
        return this.productOrderMapper.selectByOrderStatus(orderStatus);
    }

    @Transactional
    public boolean cancelOrder(Long id) {
        ProductOrder order = this.productOrderMapper.selectById(id);
        if (order == null) {
            return false;
        }
        if (!"PENDING".equals(order.getOrderStatus())) {
            throw new RuntimeException("\u53ea\u6709\u5f85\u652f\u4ed8\u72b6\u6001\u7684\u8ba2\u5355\u53ef\u4ee5\u53d6\u6d88");
        }
        List items = this.productOrderItemMapper.selectByOrderId(id);
        for (ProductOrderItem item : items) {
            this.productService.increaseStock(item.getProductId(), item.getQuantity());
        }
        return this.productOrderMapper.updateOrderStatus(id, "CANCELLED") > 0;
    }

    @Transactional
    public boolean payOrder(Long id, String paymentMethod) {
        ProductOrder order = this.productOrderMapper.selectById(id);
        if (order == null) {
            return false;
        }
        if (!"PENDING".equals(order.getOrderStatus())) {
            throw new RuntimeException("\u8ba2\u5355\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u652f\u4ed8");
        }
        if (order.getHospitalId() != null && this.serviceMerchantConfigService != null) {
            try {
                Integer organId = Integer.parseInt(order.getHospitalId());
                ServiceMerchantConfig config = this.serviceMerchantConfigService.getByOrganId(organId);
                if (config != null) {
                    logger.info("\u4f7f\u7528\u652f\u4ed8\u914d\u7f6e: organId={}, applyId={}, applyName={}", new Object[]{organId, config.getApplyId(), config.getApplyName()});
                } else {
                    logger.warn("\u533b\u9662\u672a\u914d\u7f6e\u652f\u4ed8\u4fe1\u606f: organId={}", (Object)organId);
                }
            }
            catch (NumberFormatException e) {
                logger.warn("\u533b\u9662ID\u683c\u5f0f\u4e0d\u6b63\u786e: hospitalId={}", (Object)order.getHospitalId());
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u652f\u4ed8\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            }
        }
        this.productOrderMapper.updatePaymentStatus(id, "PAID", paymentMethod, new Date());
        this.productOrderMapper.updateOrderStatus(id, "PAID");
        List items = this.productOrderItemMapper.selectByOrderId(id);
        for (ProductOrderItem item : items) {
            this.productMapper.increaseSalesCount(item.getProductId(), item.getQuantity());
        }
        return true;
    }

    @Transactional
    public boolean shipOrder(Long id) {
        ProductOrder order = this.productOrderMapper.selectById(id);
        if (order == null) {
            return false;
        }
        if (!"PAID".equals(order.getOrderStatus())) {
            throw new RuntimeException("\u53ea\u6709\u5df2\u652f\u4ed8\u72b6\u6001\u7684\u8ba2\u5355\u53ef\u4ee5\u53d1\u8d27");
        }
        return this.productOrderMapper.updateOrderStatus(id, "SHIPPED") > 0;
    }

    @Transactional
    public boolean completeOrder(Long id) {
        ProductOrder order = this.productOrderMapper.selectById(id);
        if (order == null) {
            return false;
        }
        if (!"SHIPPED".equals(order.getOrderStatus()) && !"DELIVERED".equals(order.getOrderStatus())) {
            throw new RuntimeException("\u53ea\u6709\u5df2\u53d1\u8d27\u6216\u5df2\u9001\u8fbe\u72b6\u6001\u7684\u8ba2\u5355\u53ef\u4ee5\u5b8c\u6210");
        }
        return this.productOrderMapper.updateOrderStatus(id, "COMPLETED") > 0;
    }

    @Transactional
    public boolean refundOrder(Long id) {
        ProductOrder order = this.productOrderMapper.selectById(id);
        if (order == null) {
            return false;
        }
        if (!"PAID".equals(order.getOrderStatus())) {
            throw new RuntimeException("\u53ea\u6709\u5df2\u652f\u4ed8\u72b6\u6001\u7684\u8ba2\u5355\u53ef\u4ee5\u9000\u6b3e");
        }
        this.productOrderMapper.updateOrderStatus(id, "CANCELLED");
        this.productOrderMapper.updatePaymentStatus(id, "REFUNDED", order.getPaymentMethod(), new Date());
        List items = this.productOrderItemMapper.selectByOrderId(id);
        for (ProductOrderItem item : items) {
            this.productService.increaseStock(item.getProductId(), item.getQuantity());
        }
        logger.info("\u8ba2\u5355\u9000\u6b3e\u6210\u529f: orderId={}, orderNo={}", (Object)id, (Object)order.getOrderNo());
        return true;
    }

    public long countByCondition(String userId, String userType, String hospitalId, String orderStatus, String paymentStatus, String orderNo) {
        return this.productOrderMapper.countByCondition(userId, userType, hospitalId, orderStatus, paymentStatus, orderNo);
    }
}

