/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.ProductMapper;
import com.chdu.ai.model.Product;
import com.chdu.ai.service.ProductService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductServiceImpl
implements ProductService {
    @Autowired
    private ProductMapper productMapper;

    @Transactional
    public Product create(Product product) {
        if (product.getStatus() == null) {
            product.setStatus(Integer.valueOf(1));
        }
        if (product.getIsRecommended() == null) {
            product.setIsRecommended(Integer.valueOf(0));
        }
        if (product.getSortOrder() == null) {
            product.setSortOrder(Integer.valueOf(0));
        }
        if (product.getStockQuantity() == null) {
            product.setStockQuantity(Integer.valueOf(0));
        }
        if (product.getSalesCount() == null) {
            product.setSalesCount(Integer.valueOf(0));
        }
        if (product.getViewCount() == null) {
            product.setViewCount(Integer.valueOf(0));
        }
        if (product.getUnit() == null || product.getUnit().isEmpty()) {
            product.setUnit("\u4ef6");
        }
        if (product.getCreateTime() == null) {
            product.setCreateTime(new Date());
        }
        if (product.getUpdateTime() == null) {
            product.setUpdateTime(new Date());
        }
        this.productMapper.insert(product);
        return this.productMapper.selectById(product.getId());
    }

    public Product getById(Long id) {
        Product product = this.productMapper.selectById(id);
        if (product != null) {
            this.productMapper.increaseViewCount(id);
        }
        return product;
    }

    public Product getByProductCode(String productCode) {
        return this.productMapper.selectByProductCode(productCode);
    }

    public List<Product> getByCondition(Long categoryId, String productType, Integer status, String hospitalId, String keyword, int page, int size) {
        int offset = page * size;
        return this.productMapper.selectByCondition(categoryId, productType, status, hospitalId, keyword, size, offset);
    }

    public List<Product> getByCategoryId(Long categoryId) {
        return this.productMapper.selectByCategoryId(categoryId);
    }

    public List<Product> getByProductType(String productType) {
        return this.productMapper.selectByProductType(productType);
    }

    @Transactional
    public boolean update(Product product) {
        return this.productMapper.update(product) > 0;
    }

    @Transactional
    public boolean updateStatus(Long id, Integer status) {
        return this.productMapper.updateStatus(id, status) > 0;
    }

    @Transactional
    public boolean updateStock(Long id, Integer quantity) {
        return this.productMapper.updateStock(id, quantity) > 0;
    }

    @Transactional
    public boolean decreaseStock(Long id, Integer quantity) {
        Product product = this.productMapper.selectById(id);
        if (product == null) {
            return false;
        }
        if (product.getStockQuantity() != -1 && product.getStockQuantity() < quantity) {
            return false;
        }
        return this.productMapper.decreaseStock(id, quantity) > 0;
    }

    @Transactional
    public boolean increaseStock(Long id, Integer quantity) {
        return this.productMapper.increaseStock(id, quantity) > 0;
    }

    public boolean checkStock(Long id, Integer quantity) {
        Product product = this.productMapper.selectById(id);
        if (product == null) {
            return false;
        }
        if (product.getStockQuantity() == -1) {
            return true;
        }
        return product.getStockQuantity() >= quantity;
    }

    @Transactional
    public boolean increaseSalesCount(Long id, Integer count) {
        return this.productMapper.increaseSalesCount(id, count) > 0;
    }

    @Transactional
    public boolean increaseViewCount(Long id) {
        return this.productMapper.increaseViewCount(id) > 0;
    }

    @Transactional
    public boolean deleteById(Long id) {
        return this.productMapper.deleteById(id) > 0;
    }

    public long countByCondition(Long categoryId, String productType, Integer status, String hospitalId, String keyword) {
        return this.productMapper.countByCondition(categoryId, productType, status, hospitalId, keyword);
    }
}

