/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.ServiceMerchantConfig;
import com.chdu.ai.model.ServiceMerchantConfigRequest;
import com.chdu.ai.service.ServiceMerchantConfigService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/service-merchant-config"})
@CrossOrigin(origins={"*"})
public class ServiceMerchantConfigController {
    private static final Logger logger = LoggerFactory.getLogger(ServiceMerchantConfigController.class);
    @Autowired
    private ServiceMerchantConfigService serviceMerchantConfigService;

    @PostMapping
    public BaseResponse<ServiceMerchantConfig> create(@RequestBody ServiceMerchantConfigRequest request) {
        try {
            logger.info("\u521b\u5efa\u670d\u52a1\u5546\u6237\u914d\u7f6e: organId={}, appCode={}", (Object)request.getOrganId(), (Object)request.getAppCode());
            if (request.getOrganId() == null) {
                return BaseResponse.error((String)"400", (String)"\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ServiceMerchantConfig config = new ServiceMerchantConfig();
            config.setXRemark(request.getXRemark());
            config.setStatus(request.getStatus());
            config.setMerchantSeq(request.getMerchantSeq());
            config.setAppCode(request.getAppCode());
            config.setOrganName(request.getOrganName());
            config.setBizSysSeq(request.getBizSysSeq());
            config.setApplyId(request.getApplyId());
            config.setApplyKey(request.getApplyKey());
            config.setApplyName(request.getApplyName());
            config.setOrganId(request.getOrganId());
            ServiceMerchantConfig result = this.serviceMerchantConfigService.create(config);
            logger.info("\u521b\u5efa\u670d\u52a1\u5546\u6237\u914d\u7f6e\u6210\u529f: xId={}", (Object)result.getXId());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u521b\u5efa\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/{id}"})
    public BaseResponse<ServiceMerchantConfig> getById(@PathVariable Long id) {
        try {
            logger.info("\u6839\u636eID\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e: id={}", (Object)id);
            ServiceMerchantConfig result = this.serviceMerchantConfigService.getById(id);
            if (result == null) {
                return BaseResponse.error((String)"404", (String)"\u914d\u7f6e\u4e0d\u5b58\u5728");
            }
            logger.info("\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e\u6210\u529f: id={}", (Object)id);
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25: id={}", (Object)id, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/organ/{organId}"})
    public BaseResponse<ServiceMerchantConfig> getByOrganId(@PathVariable Integer organId) {
        try {
            logger.info("\u6839\u636e\u533b\u9662ID\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e: organId={}", (Object)organId);
            ServiceMerchantConfig result = this.serviceMerchantConfigService.getByOrganId(organId);
            if (result == null) {
                return BaseResponse.error((String)"404", (String)"\u8be5\u533b\u9662\u672a\u914d\u7f6e\u652f\u4ed8\u4fe1\u606f");
            }
            logger.info("\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e\u6210\u529f: organId={}", (Object)organId);
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25: organId={}", (Object)organId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/app/{appCode}"})
    public BaseResponse<ServiceMerchantConfig> getByAppCode(@PathVariable String appCode) {
        try {
            logger.info("\u6839\u636e\u5e94\u7528code\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e: appCode={}", (Object)appCode);
            ServiceMerchantConfig result = this.serviceMerchantConfigService.getByAppCode(appCode);
            if (result == null) {
                return BaseResponse.error((String)"404", (String)"\u914d\u7f6e\u4e0d\u5b58\u5728");
            }
            logger.info("\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e\u6210\u529f: appCode={}", (Object)appCode);
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25: appCode={}", (Object)appCode, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping
    public BaseResponse<List<ServiceMerchantConfig>> getAll() {
        try {
            logger.info("\u67e5\u8be2\u6240\u6709\u670d\u52a1\u5546\u6237\u914d\u7f6e");
            List result = this.serviceMerchantConfigService.getAll();
            logger.info("\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e\u6210\u529f: \u6570\u91cf={}", (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public BaseResponse<ServiceMerchantConfig> update(@RequestBody ServiceMerchantConfigRequest request) {
        try {
            logger.info("\u66f4\u65b0\u670d\u52a1\u5546\u6237\u914d\u7f6e: xId={}", (Object)request.getXId());
            if (request.getXId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ServiceMerchantConfig config = new ServiceMerchantConfig();
            config.setXId(request.getXId());
            config.setXRemark(request.getXRemark());
            config.setStatus(request.getStatus());
            config.setMerchantSeq(request.getMerchantSeq());
            config.setAppCode(request.getAppCode());
            config.setOrganName(request.getOrganName());
            config.setBizSysSeq(request.getBizSysSeq());
            config.setApplyId(request.getApplyId());
            config.setApplyKey(request.getApplyKey());
            config.setApplyName(request.getApplyName());
            config.setOrganId(request.getOrganId());
            boolean success = this.serviceMerchantConfigService.update(config);
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u66f4\u65b0\u5931\u8d25\uff0c\u914d\u7f6e\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            ServiceMerchantConfig result = this.serviceMerchantConfigService.getById(request.getXId());
            logger.info("\u66f4\u65b0\u670d\u52a1\u5546\u6237\u914d\u7f6e\u6210\u529f: xId={}", (Object)request.getXId());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25: xId={}", (Object)request.getXId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u66f4\u65b0\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/update-status"})
    public BaseResponse<String> updateStatus(@RequestBody ServiceMerchantConfigRequest request) {
        try {
            logger.info("\u66f4\u65b0\u670d\u52a1\u5546\u6237\u914d\u7f6e\u72b6\u6001: xId={}, status={}", (Object)request.getXId(), (Object)request.getStatus());
            if (request.getXId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getStatus() == null) {
                return BaseResponse.error((String)"400", (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.serviceMerchantConfigService.updateStatus(request.getXId(), request.getStatus());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u66f4\u65b0\u5931\u8d25\uff0c\u914d\u7f6e\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            logger.info("\u66f4\u65b0\u670d\u52a1\u5546\u6237\u914d\u7f6e\u72b6\u6001\u6210\u529f: xId={}, status={}", (Object)request.getXId(), (Object)request.getStatus());
            return BaseResponse.success((Object)"\u72b6\u6001\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u670d\u52a1\u5546\u6237\u914d\u7f6e\u72b6\u6001\u5931\u8d25: xId={}, status={}", new Object[]{request.getXId(), request.getStatus(), e});
            return BaseResponse.error((String)"500", (String)("\u66f4\u65b0\u670d\u52a1\u5546\u6237\u914d\u7f6e\u72b6\u6001\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/delete"})
    public BaseResponse<String> delete(@RequestBody ServiceMerchantConfigRequest request) {
        try {
            logger.info("\u5220\u9664\u670d\u52a1\u5546\u6237\u914d\u7f6e: xId={}", (Object)request.getXId());
            if (request.getXId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.serviceMerchantConfigService.deleteById(request.getXId());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u5220\u9664\u5931\u8d25\uff0c\u914d\u7f6e\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            logger.info("\u5220\u9664\u670d\u52a1\u5546\u6237\u914d\u7f6e\u6210\u529f: xId={}", (Object)request.getXId());
            return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25: xId={}", (Object)request.getXId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u5220\u9664\u670d\u52a1\u5546\u6237\u914d\u7f6e\u5931\u8d25: " + e.getMessage()));
        }
    }
}

