/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.PatientOrderTodoMapper;
import com.chdu.ai.model.PatientOrderTodo;
import com.chdu.ai.service.PatientOrderTodoService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PatientOrderTodoServiceImpl
implements PatientOrderTodoService {
    @Autowired
    private PatientOrderTodoMapper patientOrderTodoMapper;

    @Transactional
    public PatientOrderTodo create(PatientOrderTodo patientOrderTodo) {
        if (patientOrderTodo.getStatus() == null) {
            patientOrderTodo.setStatus(Integer.valueOf(0));
        }
        if (patientOrderTodo.getCreateTime() == null) {
            patientOrderTodo.setCreateTime(new Date());
        }
        this.patientOrderTodoMapper.insert(patientOrderTodo);
        return this.patientOrderTodoMapper.selectById(patientOrderTodo.getId());
    }

    public PatientOrderTodo getById(Long id) {
        return this.patientOrderTodoMapper.selectById(id);
    }

    public PatientOrderTodo getByOrderTypeAndSourceId(String orderType, String sourceId) {
        return this.patientOrderTodoMapper.selectByOrderTypeAndSourceId(orderType, sourceId);
    }

    public List<PatientOrderTodo> getByPatientId(String patientId) {
        return this.patientOrderTodoMapper.selectByPatientId(patientId);
    }

    public List<PatientOrderTodo> getByPatientIdAndStatus(String patientId, Integer status) {
        return this.patientOrderTodoMapper.selectByPatientIdAndStatus(patientId, status);
    }

    public List<PatientOrderTodo> getByStatus(Integer status) {
        return this.patientOrderTodoMapper.selectByStatus(status);
    }

    public List<PatientOrderTodo> getByCondition(String patientId, Integer status, int page, int size) {
        int offset = page * size;
        return this.patientOrderTodoMapper.selectByCondition(patientId, status, size, offset);
    }

    @Transactional
    public boolean update(PatientOrderTodo patientOrderTodo) {
        return this.patientOrderTodoMapper.update(patientOrderTodo) > 0;
    }

    @Transactional
    public boolean updateStatus(Long id, Integer status) {
        return this.patientOrderTodoMapper.updateStatus(id, status) > 0;
    }

    @Transactional
    public boolean updateStatusByOrderTypeAndSourceId(String orderType, String sourceId, Integer status) {
        return this.patientOrderTodoMapper.updateStatusByOrderTypeAndSourceId(orderType, sourceId, status) > 0;
    }

    @Transactional
    public boolean deleteById(Long id) {
        return this.patientOrderTodoMapper.deleteById(id) > 0;
    }

    @Transactional
    public boolean deleteByOrderTypeAndSourceId(String orderType, String sourceId) {
        return this.patientOrderTodoMapper.deleteByOrderTypeAndSourceId(orderType, sourceId) > 0;
    }

    public long countByCondition(String patientId, Integer status) {
        return this.patientOrderTodoMapper.countByCondition(patientId, status);
    }
}

