/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.ShoppingCartMapper;
import com.chdu.ai.model.Product;
import com.chdu.ai.model.ShoppingCart;
import com.chdu.ai.service.ProductService;
import com.chdu.ai.service.ShoppingCartService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShoppingCartServiceImpl
implements ShoppingCartService {
    @Autowired
    private ShoppingCartMapper shoppingCartMapper;
    @Autowired
    private ProductService productService;

    @Transactional
    public ShoppingCart addToCart(ShoppingCart shoppingCart) {
        Product product = this.productService.getById(shoppingCart.getProductId());
        if (product == null) {
            throw new RuntimeException("\u4ea7\u54c1\u4e0d\u5b58\u5728");
        }
        if (product.getStatus() != 1) {
            throw new RuntimeException("\u4ea7\u54c1\u5df2\u4e0b\u67b6");
        }
        ShoppingCart existingCart = this.shoppingCartMapper.selectByUserIdAndProductId(shoppingCart.getUserId(), shoppingCart.getProductId());
        if (existingCart != null) {
            int newQuantity = existingCart.getQuantity() + shoppingCart.getQuantity();
            if (!this.productService.checkStock(shoppingCart.getProductId(), Integer.valueOf(newQuantity))) {
                throw new RuntimeException("\u5e93\u5b58\u4e0d\u8db3");
            }
            existingCart.setQuantity(Integer.valueOf(newQuantity));
            existingCart.setUpdateTime(new Date());
            this.shoppingCartMapper.update(existingCart);
            return existingCart;
        }
        if (!this.productService.checkStock(shoppingCart.getProductId(), shoppingCart.getQuantity())) {
            throw new RuntimeException("\u5e93\u5b58\u4e0d\u8db3");
        }
        if (shoppingCart.getQuantity() == null || shoppingCart.getQuantity() <= 0) {
            shoppingCart.setQuantity(Integer.valueOf(1));
        }
        if (shoppingCart.getCreateTime() == null) {
            shoppingCart.setCreateTime(new Date());
        }
        if (shoppingCart.getUpdateTime() == null) {
            shoppingCart.setUpdateTime(new Date());
        }
        this.shoppingCartMapper.insert(shoppingCart);
        return this.shoppingCartMapper.selectById(shoppingCart.getId());
    }

    public ShoppingCart getById(Long id) {
        return this.shoppingCartMapper.selectById(id);
    }

    public List<ShoppingCart> getByUserId(String userId) {
        return this.shoppingCartMapper.selectByUserId(userId);
    }

    @Transactional
    public boolean updateQuantity(Long id, Integer quantity) {
        if (quantity == null || quantity <= 0) {
            return false;
        }
        ShoppingCart cart = this.shoppingCartMapper.selectById(id);
        if (cart == null) {
            return false;
        }
        if (!this.productService.checkStock(cart.getProductId(), quantity)) {
            throw new RuntimeException("\u5e93\u5b58\u4e0d\u8db3");
        }
        return this.shoppingCartMapper.updateQuantity(id, quantity) > 0;
    }

    @Transactional
    public boolean deleteById(Long id) {
        return this.shoppingCartMapper.deleteById(id) > 0;
    }

    @Transactional
    public boolean deleteByUserIdAndProductId(String userId, Long productId) {
        return this.shoppingCartMapper.deleteByUserIdAndProductId(userId, productId) > 0;
    }

    @Transactional
    public boolean clearCart(String userId) {
        return this.shoppingCartMapper.deleteByUserId(userId) > 0;
    }

    @Transactional
    public boolean batchDelete(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return false;
        }
        return this.shoppingCartMapper.deleteByIds(ids) > 0;
    }

    @Transactional
    public boolean deleteByUserIdAndProductIds(String userId, List<Long> productIds) {
        if (productIds == null || productIds.isEmpty()) {
            return false;
        }
        return this.shoppingCartMapper.deleteByUserIdAndProductIds(userId, productIds) > 0;
    }
}

