/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.config;

import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="canal")
public class CanalConfig {
    private static final Logger log = LoggerFactory.getLogger(CanalConfig.class);
    private String host = "127.0.0.1";
    private Integer port = 11111;
    private String destination;
    private List<String> destinations;
    private String username = "";
    private String password = "";
    private Integer batchSize = 100;
    private Long timeout = 100L;

    public List<String> getDestinationList() {
        if (this.destinations != null && !this.destinations.isEmpty()) {
            return this.destinations;
        }
        if (this.destination != null && !this.destination.isEmpty()) {
            return Arrays.asList(this.destination);
        }
        return Arrays.asList("health-management");
    }

    public String getFilterByDestination(String destination) {
        if (destination == null) {
            return "";
        }
        switch (destination) {
            case "health-management": {
                return "byh-health-management\\.followup_plan_provide.*|byh-health-management\\.offline_service_appointment|byh-health-management\\.servicepkg_order";
            }
            case "online-outpatient": {
                return "byh-online-outpatient\\.inquiry_order|byh-online-outpatient\\.inquiry_admission";
            }
            case "wisdom-medical": {
                return "byh-wisdom-medical\\.medical_appointment_info";
            }
            case "nursing-care": {
                return "nursing-care\\.orders";
            }
            case "medicalcloud": {
                return "byh_medicalcloud_service\\.mos_drug_main";
            }
        }
        log.warn("\u672a\u627e\u5230destination\u5bf9\u5e94\u7684\u8fc7\u6ee4\u89c4\u5219: {}", (Object)destination);
        return "";
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getDestination() {
        return this.destination;
    }

    public List<String> getDestinations() {
        return this.destinations;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setDestinations(List<String> destinations) {
        this.destinations = destinations;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CanalConfig)) {
            return false;
        }
        CanalConfig other = (CanalConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$batchSize = this.getBatchSize();
        Integer other$batchSize = other.getBatchSize();
        if (this$batchSize == null ? other$batchSize != null : !((Object)this$batchSize).equals(other$batchSize)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        List this$destinations = this.getDestinations();
        List other$destinations = other.getDestinations();
        if (this$destinations == null ? other$destinations != null : !((Object)this$destinations).equals(other$destinations)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CanalConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $batchSize = this.getBatchSize();
        result = result * 59 + ($batchSize == null ? 43 : ((Object)$batchSize).hashCode());
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        List $destinations = this.getDestinations();
        result = result * 59 + ($destinations == null ? 43 : ((Object)$destinations).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "CanalConfig(host=" + this.getHost() + ", port=" + this.getPort() + ", destination=" + this.getDestination() + ", destinations=" + this.getDestinations() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", batchSize=" + this.getBatchSize() + ", timeout=" + this.getTimeout() + ")";
    }
}

