/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.module.verlogin.FramePerInfoControActivity;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.present.PersonInfoPresent;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.PersonInfoBody;
import com.kangxin.common.byh.entity.SelZhicEntity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.entity.v2.HospitalEntityV2;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.Event;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.IPersonInfoView;
import com.kangxin.common.byh.view.IPersonalInfoVerifyView;
import com.kangxin.common.util.StringUtil;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.Nullable;

@Route(path="/verification/PersonInfoActivity")
public class PersonInfoActivity
extends BaseActivity
implements IToolView,
View.OnClickListener,
IPersonInfoView,
IPersonalInfoVerifyView {
    private static final String TAG = "PersonInfoActivity";
    private TextView mYiyuanNameText;
    private TextView mSuozKeshiText;
    private TextView mSelZhicText;
    private TextView mShanChlyText;
    private EditText mRealNameEdt;
    private PersonInfoPresent mPersonInfoPresent;
    private EditText mIdcardEdtView;
    private HospitalEntityV2 mHospitalEntity;
    private String mAreaCode;
    private ByhCommEvent.HosDeptDataEvent mHosDeptData;
    private String mShancArea;
    private SelZhicEntity mDictEntity;
    private String mRealName;

    public void start() {
        this.mPersonInfoPresent = new PersonInfoPresent(this);
        this.vToolTitleTextView.setText(R.string.person_info);
        this.mYiyuanNameText = (TextView)this.findViewById(R.id.yiy_name);
        this.mYiyuanNameText.setOnClickListener((View.OnClickListener)this);
        this.mSuozKeshiText = (TextView)this.findViewById(R.id.suoz_keshi);
        this.mSuozKeshiText.setOnClickListener((View.OnClickListener)this);
        this.mSelZhicText = (TextView)this.findViewById(R.id.sel_zhic);
        this.mSelZhicText.setOnClickListener((View.OnClickListener)this);
        this.mShanChlyText = (TextView)this.findViewById(R.id.shanc_liny);
        this.mShanChlyText.setOnClickListener((View.OnClickListener)this);
        this.mRealNameEdt = (EditText)this.findViewById(R.id.real_name_edt);
        this.mIdcardEdtView = (EditText)this.findViewById(R.id.idcardnum_edt);
    }

    public int getContentLayoutId() {
        return R.layout.person_info_activity;
    }

    public View getVToolView() {
        return this.rootView.findViewById(R.id.tool_bar);
    }

    public void finishCurrentView() {
        this.finish();
    }

    public void onClick(View view) {
        Intent intent = new Intent((Context)this, FramePerInfoControActivity.class);
        int i = view.getId();
        if (i == R.id.yiy_name) {
            intent.putExtra("MSG_JUMP_TYPE", 5382);
        } else if (i == R.id.suoz_keshi) {
            if (this.mHospitalEntity == null) {
                this.showShortToast(this.getString(R.string.psel_suosyy));
                return;
            }
            long hosId = Long.parseLong(this.mHospitalEntity.getHospitalId());
            String appCode = this.mHospitalEntity.getAppCode();
            intent.putExtra("MSG_JUMP_TYPE", 5383);
            intent.putExtra("HOS_APP_CODE", appCode);
            Log.i((String)TAG, (String)("hosId==>" + hosId));
            intent.putExtra("HOSPITAL_ID", hosId);
        } else if (i == R.id.sel_zhic) {
            intent.putExtra("MSG_JUMP_TYPE", 5384);
        } else if (i == R.id.shanc_liny) {
            intent.putExtra("MSG_JUMP_TYPE", 5385);
        }
        this.startActivity(intent);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveHosEntityEvent(ByhCommEvent.HosEntityEvent hosEntityEvent) {
        this.mHospitalEntity = hosEntityEvent.getmHosEntity();
        this.mAreaCode = this.mHospitalEntity.getDistrictCode();
        this.mYiyuanNameText.setText((CharSequence)this.mHospitalEntity.getHospitalName());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveKeshiDataEvent(ByhCommEvent.HosDeptDataEvent hosDeptDataEvent) {
        this.mHosDeptData = hosDeptDataEvent;
        this.mSuozKeshiText.setText((CharSequence)this.mHosDeptData.getStdDeptName());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveEvent(Event.ShancName shancName) {
        this.mShancArea = shancName.getShancDesc();
        String shancArea = StringUtil.changeSubText((String)this.mShancArea, (int)15);
        this.mShanChlyText.setText((CharSequence)shancArea);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveZhicEntity(SelZhicEntity dictEntityListBean) {
        this.mDictEntity = dictEntityListBean;
        this.mSelZhicText.setText((CharSequence)this.mDictEntity.getDicName());
    }

    public void clickSave(View view) {
        this.mRealName = this.mRealNameEdt.getText().toString().trim();
        if (TextUtils.isEmpty((CharSequence)this.mRealName)) {
            this.showShortToast(this.getString(R.string.p_input_realname));
            return;
        }
        if (this.mHospitalEntity == null) {
            this.showShortToast(this.getString(R.string.psel_suosyy));
            return;
        }
        if (this.mHosDeptData == null) {
            this.showShortToast(this.getString(R.string.verlogin_psel_keshiname));
            return;
        }
        String keshiName = this.mSuozKeshiText.getText().toString();
        if (TextUtils.isEmpty((CharSequence)keshiName)) {
            this.showShortToast(this.getString(R.string.verlogin_psel_keshiname));
            return;
        }
        if (this.mDictEntity == null) {
            this.showShortToast(this.getString(R.string.psel_suoznizhic));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mShancArea)) {
            this.showShortToast(this.getString(R.string.please_input_shancly));
            return;
        }
        this.reqSavePersonInfo();
    }

    private void reqSavePersonInfo() {
        String idcardNum = this.mIdcardEdtView.getText().toString().trim();
        String realName = this.mRealNameEdt.getText().toString().trim();
        PersonInfoBody personInfoBody = new PersonInfoBody();
        LoginSuccess loginSuccess = VertifyDataUtil.getInstance((Context)this.getApplicationContext()).getLoginData();
        String accountId = VertifyDataUtil.getInstance((Context)this.getApplicationContext()).getLoginData().getAccountId();
        personInfoBody.setPhone(loginSuccess.getMobileNumber());
        personInfoBody.setAccountId(accountId);
        personInfoBody.setAreaCode(this.mAreaCode);
        personInfoBody.setChannelCode("DOCTOR_ANDROID");
        personInfoBody.setDisplayName(realName);
        personInfoBody.setAppCode(this.mHospitalEntity.getAppCode());
        personInfoBody.setHospitalId(this.mHospitalEntity.getHospitalId());
        personInfoBody.setHospitalCode(this.mHospitalEntity.getOrganCode());
        personInfoBody.setHospitalDeptCode(this.mHosDeptData.getStdDeptId());
        personInfoBody.setHospitalDeptName(this.mHosDeptData.getHosDeptName());
        personInfoBody.setIdCardNo(idcardNum);
        personInfoBody.setProfession(this.mDictEntity.getDicName());
        personInfoBody.setProfessionCode(this.mDictEntity.getDicCode());
        personInfoBody.setRegHospitalName(this.mHospitalEntity.getHospitalName());
        personInfoBody.setSpeciality(this.mShancArea);
        personInfoBody.setStdFristDeptCode(this.mHosDeptData.getStdFirstDeptCode());
        personInfoBody.setStdFristDeptName(this.mHosDeptData.getStdFirstDeptName());
        personInfoBody.setStdSecondDeptCode(this.mHosDeptData.getStdSecondDeptCode());
        personInfoBody.setStdSecondDeptName(this.mHosDeptData.getStdSecondDeptName());
        this.mPersonInfoPresent.savePersonInfo(this.getBaseContext(), personInfoBody);
    }

    public void showErr(String msg) {
        this.showShortToast(msg);
    }

    public void showPersonInfo(LoginSuccess responseBody) {
        ExpertInfoEntity expertInfoEntity = new ExpertInfoEntity();
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = new ExpertInfoEntity.UserInfoVOBean();
        userInfoVOBean.setName(this.mRealName);
        expertInfoEntity.setUserInfoVO(userInfoVOBean);
        VertifyDataUtil.getInstance((Context)this.getBaseContext()).setDocDetailInfo(expertInfoEntity);
        ARouter.getInstance().build("/verification/ProfesCertifyActivity").navigation();
        this.finish();
    }

    public void showVerifyResult(ResponseBody responseBody) {
        this.reqSavePersonInfo();
    }

    public void error(@Nullable String errorMsg) {
        this.showShortToast(errorMsg);
    }
}

