/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin.present;

import android.content.Context;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.intercept.RxLoginCommonObserver;
import com.byh.module.verlogin.module.IVerLoginModule;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.present.PushBindPresenter;
import com.byh.module.verlogin.present.inter.IPushBindPresenter;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.byh.module.verlogin.view.ILoginView;
import com.igexin.sdk.PushManager;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.widget.RxProgressObserver;
import io.reactivex.Observer;

public class VerLoginPresent {
    private static final String TAG = "VerLoginPresent";
    private ILoginView mLoginView;
    private IVerLoginModule mVerLoginModule;
    private IPushBindPresenter pushBindPresenter;
    private String mAuthKey;

    public VerLoginPresent(ILoginView mLoginView) {
        this.mLoginView = mLoginView;
        this.mVerLoginModule = new VerLoginModule();
        this.pushBindPresenter = new PushBindPresenter(mLoginView.injectContext());
    }

    public void loginApp(final Context context, Login login2) {
        this.mVerLoginModule.userLogin(login2).subscribe((Observer)new RxLoginCommonObserver<ResponseBody<LoginSuccess>>(){

            @Override
            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                VertifyDataUtil.getInstance((Context)context).setLoginData((LoginSuccess)loginSuccessResponseBody.getResult());
                VerLoginPresent.this.mLoginView.loginOk(loginSuccessResponseBody);
                VerLoginPresent.this.updateUserInfo(context);
                UpdateVerStatus.getInstance().updateImToken(context);
                super.onReqNext(loginSuccessResponseBody);
            }
        });
    }

    private void updateUserInfo(Context context) {
        UpdateVerStatus.getInstance().updateDocDetailInfo(context, new IUpdateVerStatus.OnUpdateDocDetailInfoCallback(){

            public void updateDocDetailInfoOk() {
                String clientid = PushManager.getInstance().getClientid(VerLoginPresent.this.mLoginView.injectContext());
                boolean empty = StringUtils.isEmpty((CharSequence)clientid);
                if (!empty) {
                    VerLoginPresent.this.pushBindPresenter.bindDeviceInfo(clientid);
                }
            }

            public void updateDocDetailInfoErr(String err) {
                ToastUtils.showShort((CharSequence)err);
            }
        });
    }

    public String getAuthKey() {
        return this.mAuthKey;
    }

    public void sentVerCode(String phoneNum) {
        this.mVerLoginModule.sendSmsAuthCode(phoneNum).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                VerLoginPresent.this.mAuthKey = ((LoginSuccess)loginSuccessResponseBody.getResult()).getAuthKey();
                ToastUtils.showLong((CharSequence)"\u53d1\u9001\u6210\u529f");
            }
        });
    }

    public void setPassword(final Context context, Login login2) {
        this.mVerLoginModule.setPassword(login2).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                LoginSuccess loginSuccess = (LoginSuccess)loginSuccessResponseBody.getResult();
                VertifyDataUtil.getInstance((Context)context).setToken(loginSuccess.getToken());
                VertifyDataUtil.getInstance((Context)context).setAccountStatus(loginSuccess.getAccountStatus());
                VertifyDataUtil.getInstance((Context)context).setAccountId(loginSuccess.getAccountId());
                VerLoginPresent.this.mLoginView.setPwdOk(loginSuccessResponseBody.getMsg());
            }
        });
    }

    public void updatePassword(Login login2) {
        this.mVerLoginModule.updatePassword(login2).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                VerLoginPresent.this.mLoginView.setPwdOk(loginSuccessResponseBody.getMsg());
            }
        });
    }
}

