/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.core.content.res.ResourcesCompat;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.AppUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.AgreementNoticeCountryActivity;
import com.byh.module.verlogin.PwdLoginActivity;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.entity.VerCodeEntity;
import com.byh.module.verlogin.event.vertify.LoginDispatchStatus;
import com.byh.module.verlogin.event.vertify.LoginStatusManager;
import com.byh.module.verlogin.event.vertify.WeChatStatusManager;
import com.byh.module.verlogin.present.LoginByVercodePresent;
import com.byh.module.verlogin.present.VerLoginPresent;
import com.byh.module.verlogin.present.WeixAuthPresent;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.byh.module.verlogin.view.ILoginByCodeOkView;
import com.byh.module.verlogin.view.ILoginView;
import com.byh.module.verlogin.view.IWeixAuthView;
import com.google.gson.Gson;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.entity.MeetingRoomEntity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.present.IUpdatePresenter;
import com.kangxin.common.byh.present.impl.UpdatePresenter;
import com.kangxin.common.byh.service.IMeetingService;
import com.kangxin.common.byh.service.IWeixLoginProvider;
import com.kangxin.common.byh.util.CountDownUtil;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.byh.widget.ZpPhoneEditText;
import com.kangxin.common.util.VerifyUtil;
import ezy.boost.update.UpdateInfo;
import ezy.boost.update.UpdateManager;
import info.cd120.module_push.PushManager;
import org.greenrobot.eventbus.EventBus;

@Route(path="/verification/LoginActivity")
public class LoginActivity
extends BaseActivity
implements ILoginView,
ILoginByCodeOkView,
IWeixAuthView {
    private static final String TAG = "LoginActivity";
    ZpPhoneEditText mPhoneNumEdit;
    ImageView mClosePhoneNumImg;
    TextView mVercodeText;
    Button mLoginButton;
    EditText mVercodeEdt;
    ImageView mBackImg;
    TextView mErrNoticeText;
    private CountDownUtil mCountDownUtil;
    private VerLoginPresent mLoginPresent;
    private LoginByVercodePresent mLoginByVercodePresent;
    private WeixRespReceiver mWeixRespReceiver;
    private WeixAuthPresent mWeixAuthPresent;
    private IUpdatePresenter updatePresenter = new UpdatePresenter();
    private IWeixLoginProvider mWeixLoginProvider = (IWeixLoginProvider)ARouter.getInstance().build("/weix/login/WeixLoginProvider").navigation();
    private String mVerCode;
    private VerCodeEntity mVerCodeEntity;

    @Override
    public void authOk(LoginSuccess loginSuccess) {
        this.updateUserInfo();
        this.receiveStatus(loginSuccess.getAccountStatus(), LoginFlag.WECHAT);
    }

    private void registerWeixRespReceiver() {
        this.mWeixRespReceiver = new WeixRespReceiver();
        IntentFilter intentFilter = new IntentFilter("com.kangxin.doctor.receiver.action.resp");
        this.registerReceiver(this.mWeixRespReceiver, intentFilter);
    }

    private void unRegisterWeixRespReceiver() {
        if (this.mWeixRespReceiver == null) {
            return;
        }
        this.unregisterReceiver(this.mWeixRespReceiver);
        if (this.mWeixLoginProvider != null) {
            this.mWeixLoginProvider.unRegisterWeixBroadCast();
        }
    }

    public void start() {
        TextView login_question = (TextView)this.findViewById(R.id.login_question);
        if (login_question != null) {
            login_question.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ARouter.getInstance().build("/minecontact/ContactUsActivity").navigation();
                }
            });
        }
        this.mLoginPresent = new VerLoginPresent(this);
        this.mLoginByVercodePresent = new LoginByVercodePresent(this);
        this.initViews();
        this.findViewById(R.id.weix_login_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (Build.VERSION.SDK_INT >= 26) {
                    if (LoginActivity.this.mWeixLoginProvider != null) {
                        LoginActivity.this.mWeixLoginProvider.registerWeixBroadCast("com.kangxin.doctor.receiver.action.weixlogin");
                        LoginActivity.this.mWeixLoginProvider.sendWeixLoginBroadCast("com.kangxin.doctor.receiver.action.weixlogin");
                    }
                } else {
                    Intent intent = new Intent("com.kangxin.doctor.receiver.action.weixlogin");
                    LoginActivity.this.sendBroadcast(intent);
                }
            }
        });
        this.registerWeixRespReceiver();
        UpdateManager.create((Context)this).setUrl("https://ihos.ebaiyihui.com//consultation/api/v1/app_version/get/latestbyplatform?platform=android").setChecker((agent, url) -> this.updatePresenter.checkUpdate(agent, AppUtils.getAppVersionCode())).setParser(source -> (UpdateInfo)new Gson().fromJson(source, UpdateInfo.class)).check();
    }

    private void initViews() {
        this.findViewById(R.id.ver_user_xieyi).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Bundle bundle = new Bundle();
                bundle.putString("loadurl", "https://patient.ebaiyihui.com/agreement/legalNotice.html");
                bundle.putString("title", LoginActivity.this.getResources().getString(R.string.user_agreement));
                Intent intent = new Intent((Context)LoginActivity.this, AgreementNoticeCountryActivity.class);
                intent.putExtras(bundle);
                LoginActivity.this.startActivity(intent);
            }
        });
        this.findViewById(R.id.ver_yinsizhc).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Bundle bundle = new Bundle();
                bundle.putString("loadurl", "https://patient.ebaiyihui.com/agreement/doctorAgreement.html");
                bundle.putString("title", LoginActivity.this.getResources().getString(R.string.legal_notice));
                Intent intent = new Intent((Context)LoginActivity.this, AgreementNoticeCountryActivity.class);
                intent.putExtras(bundle);
                LoginActivity.this.startActivity(intent);
            }
        });
        this.mPhoneNumEdit = (ZpPhoneEditText)this.findViewById(R.id.edt_phonenum);
        this.mClosePhoneNumImg = (ImageView)this.findViewById(R.id.clearlogin_img);
        this.mVercodeText = (TextView)this.findViewById(R.id.vercode_txt);
        this.mLoginButton = (Button)this.findViewById(R.id.bt_login);
        this.mVercodeEdt = (EditText)this.findViewById(R.id.edt_vercode);
        this.mBackImg = (ImageView)this.findViewById(R.id.img_back_ver);
        this.mErrNoticeText = (TextView)this.findViewById(R.id.err_notice);
        this.mLoginButton.setClickable(false);
        this.mCountDownUtil = new CountDownUtil(this.mVercodeText).setCountDownMillis(60000L).setCountDownColor(R.color.white, 0x1060000);
        this.isVercodeUsable(false);
        this.mCountDownUtil.setOnDownEndListener(() -> {
            String phoneNum = this.mPhoneNumEdit.getPhoneText();
            if (!TextUtils.isEmpty((CharSequence)phoneNum)) {
                this.isVercodeUsable(true);
            } else {
                this.isVercodeUsable(false);
            }
        });
        this.mClosePhoneNumImg.setOnClickListener(view -> this.mPhoneNumEdit.setText((CharSequence)""));
        this.mVercodeText.setOnClickListener(view -> {
            String phoneNum = this.mPhoneNumEdit.getPhoneText();
            if (TextUtils.isEmpty((CharSequence)phoneNum)) {
                return;
            }
            this.mLoginPresent.sentVerCode(phoneNum);
            this.mCountDownUtil.start();
            this.isVercodeUsable(false);
        });
        this.addEdtChangeListener();
    }

    private void addEdtChangeListener() {
        this.mPhoneNumEdit.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                LoginActivity.this.mErrNoticeText.setVisibility(8);
                if (editable.length() != 0) {
                    LoginActivity.this.mClosePhoneNumImg.setVisibility(0);
                    LoginActivity.this.mBackImg.setImageResource(R.drawable.ic_gray_fanhui);
                } else {
                    LoginActivity.this.mClosePhoneNumImg.setVisibility(8);
                    LoginActivity.this.mBackImg.setImageResource(R.drawable.ic_ver_guanbi);
                }
                String phoneNum = LoginActivity.this.mPhoneNumEdit.getPhoneText();
                if (VerifyUtil.isMobilePhoneNumber((String)phoneNum)) {
                    LoginActivity.this.isVercodeUsable(true);
                } else {
                    LoginActivity.this.isVercodeUsable(false);
                }
            }
        });
        this.mVercodeEdt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @RequiresApi(api=16)
            public void afterTextChanged(Editable editable) {
                LoginActivity.this.mErrNoticeText.setVisibility(8);
                if (editable.length() == 6) {
                    LoginActivity.this.mLoginButton.setClickable(true);
                    LoginActivity.this.mLoginButton.setBackground(ResourcesCompat.getDrawable((Resources)LoginActivity.this.getResources(), (int)R.drawable.vercode_order_bg, null));
                } else {
                    LoginActivity.this.mLoginButton.setClickable(false);
                    LoginActivity.this.mLoginButton.setBackground(ResourcesCompat.getDrawable((Resources)LoginActivity.this.getResources(), (int)R.drawable.bt_gray_order_bg, null));
                }
                if (editable.length() != 0) {
                    LoginActivity.this.mBackImg.setImageResource(R.drawable.ic_gray_fanhui);
                } else {
                    LoginActivity.this.mBackImg.setImageResource(R.drawable.ic_ver_guanbi);
                }
            }
        });
    }

    public int getContentLayoutId() {
        return R.layout.activity_ver_login;
    }

    public void clickLogin(View view) {
        String phoneNum = this.mPhoneNumEdit.getPhoneText();
        String verCode = this.mVercodeEdt.getText().toString().trim();
        if (!VerifyUtil.isMobilePhoneNumber((String)phoneNum)) {
            ToastUtils.showLong((CharSequence)"\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
            return;
        }
        Login login2 = new Login();
        login2.setAccountNo(phoneNum);
        String authKey = this.mLoginPresent.getAuthKey();
        if (TextUtils.isEmpty((CharSequence)authKey)) {
            ToastUtils.showLong((CharSequence)"\u8bf7\u83b7\u53d6\u9a8c\u8bc1\u7801");
            return;
        }
        login2.setAuthKey(authKey);
        login2.setCode(verCode);
        login2.setLoginDeviceNum(PushManager.getDeviceId((Context)this.mContext));
        this.mLoginByVercodePresent.loginByVercode(this.getBaseContext(), login2);
    }

    public void clickPwdLogin(View view) {
        this.startActivity(new Intent((Context)this, PwdLoginActivity.class));
    }

    public void clickBack(View view) {
        String phoneNum = this.mPhoneNumEdit.getPhoneText();
        String verCode = this.mVercodeEdt.getText().toString().trim();
        if (!TextUtils.isEmpty((CharSequence)phoneNum) || !TextUtils.isEmpty((CharSequence)verCode)) {
            this.mPhoneNumEdit.setText((CharSequence)"");
            this.mVercodeEdt.setText((CharSequence)"");
            this.mCountDownUtil.reset();
            this.isVercodeUsable(false);
        } else {
            ARouter.getInstance().build("/home/MainActivity").navigation();
            this.finish();
        }
    }

    public void onBackPressedSupport() {
        ARouter.getInstance().build("/home/MainActivity").navigation();
        this.finish();
    }

    @Override
    public void loginOk(ResponseBody<LoginSuccess> loginSuccess) {
    }

    @Override
    public void reqErr(String err) {
        Log.i((String)TAG, (String)("==reqErr==" + err));
        this.mCountDownUtil.reset();
    }

    @Override
    public void receiveVercode(VerCodeEntity verCode) {
        Log.i((String)TAG, (String)("==verCode==" + verCode));
        if (verCode == null) {
            return;
        }
        this.mVerCode = verCode.getVerifyCode();
        this.mVerCodeEntity = verCode;
    }

    @Override
    public void setPwdOk(String msg) {
    }

    private void isVercodeUsable(boolean isUse) {
        if (isUse) {
            this.mCountDownUtil.setUsable(true);
            this.mVercodeText.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.vercode_order_bg, null));
            this.mVercodeText.setTextColor(this.getResources().getColor(17170443));
            this.mVercodeText.setClickable(true);
            this.mVercodeText.setFocusable(true);
            this.mVercodeText.setText(R.string.ver_getvercode);
        } else {
            this.mCountDownUtil.setUsable(false);
            this.mVercodeText.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.edt_order_bg, null));
            this.mVercodeText.setTextColor(this.getResources().getColor(0x1060000));
            this.mVercodeText.setText(R.string.ver_getvercode);
            this.mVercodeText.setClickable(false);
            this.mVercodeText.setFocusable(false);
        }
    }

    @Override
    public void loginByCodeOk(LoginSuccess loginSuccess, String msg) {
        Log.i((String)TAG, (String)("loginByCodeOk==>" + loginSuccess));
        if (loginSuccess == null) {
            this.showShortToast(msg);
            return;
        }
        this.updateUserInfo();
        this.receiveStatus(loginSuccess.getAccountStatus(), LoginFlag.NORMAL);
    }

    private void updateUserInfo() {
        UpdateVerStatus.getInstance().updateDocDetailInfo(this.getBaseContext(), new IUpdateVerStatus.OnUpdateDocDetailInfoCallback(){

            public void updateDocDetailInfoOk() {
                IMeetingService meetingService;
                if (VertifyDataUtil.getInstance((Context)LoginActivity.this.mContext).hasLogin() && (meetingService = (IMeetingService)ARouter.getInstance().build("/meeting_service/meeting_service").navigation()) != null) {
                    MeetingRoomEntity meetingRoomEntity = new MeetingRoomEntity();
                    if (VertifyDataUtil.getInstance((Context)LoginActivity.this.mContext).getUserInfo() == null) {
                        return;
                    }
                    meetingRoomEntity.setPhone(VertifyDataUtil.getInstance((Context)LoginActivity.this.mContext).getUserInfo().getRegisterMobile().toString());
                    meetingRoomEntity.setPresenterName(VertifyDataUtil.getInstance((Context)LoginActivity.this.mContext).getUserInfo().getName().toString());
                    meetingRoomEntity.setPresenterAvatar(VertifyDataUtil.getInstance((Context)LoginActivity.this.mContext).getUserInfo().getHeadPortrait().toString());
                    meetingService.init(LoginActivity.this.mContext, meetingRoomEntity);
                }
            }

            public void updateDocDetailInfoErr(String err) {
                LoginActivity.this.showShortToast(err);
            }
        });
    }

    public void receiveStatus(int status, LoginFlag loginFlag) {
        Log.i((String)TAG, (String)"===receiveStatus==");
        LoginDispatchStatus loginDispatchStatus = new LoginDispatchStatus();
        if (loginFlag == LoginFlag.WECHAT) {
            loginDispatchStatus.registerStatus(new WeChatStatusManager((Activity)this));
        } else {
            loginDispatchStatus.registerStatus(new LoginStatusManager((Activity)this));
        }
        loginDispatchStatus.dispatchStatus(status);
        EventBus.getDefault().post((Object)new ByhCommEvent.LoginOkEvent());
        UpdateVerStatus.getInstance().updateImToken(this.getBaseContext());
        this.finish();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unRegisterWeixRespReceiver();
    }

    static enum LoginFlag {
        WECHAT,
        NORMAL;

    }

    private class WeixRespReceiver
    extends BroadcastReceiver {
        private WeixRespReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String code = intent.getStringExtra("WEIX_RESP_CODE_KEY");
            Log.i((String)LoginActivity.TAG, (String)("code===>" + code));
            LoginActivity.this.mWeixAuthPresent = new WeixAuthPresent(LoginActivity.this.getBaseContext(), LoginActivity.this);
            LoginActivity.this.mWeixAuthPresent.reqWeixAuth(code);
        }
    }
}

