/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin.fragment;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.byh.module.verlogin.PersonInfoActivity;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.UpHeadIconActivity;
import com.byh.module.verlogin.fragment.CertifyOkFragment;
import com.byh.module.verlogin.present.PersonInfoPresent;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.kangxin.common.Pretty;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.VertifyIDCardEntity;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.entity.response.UpImgEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.present.IVerifyPresenter;
import com.kangxin.common.byh.present.VerifyPresenter;
import com.kangxin.common.byh.present.impl.UpFilePresent;
import com.kangxin.common.byh.util.StringUtil;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.IPersonInfoView;
import com.kangxin.common.byh.view.IUpFileView;
import com.kangxin.common.byh.view.IVerNameByIdcardView;
import com.kangxin.common.byh.widget.UpPicBottomDialog;
import com.kangxin.common.past.AppManager;
import com.kangxin.common.util.FileUtils;
import com.kangxin.common.util.VerifyUtil;
import java.io.File;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import top.zibin.luban.Luban;
import top.zibin.luban.OnCompressListener;

public class ProfesCertifyFragment
extends BaseFragment
implements IToolView,
IUpFileView,
IPersonInfoView,
IVerNameByIdcardView {
    private String TAG = "ProfesCertifyFragment";
    ImageView mUploadPersonPicView;
    ImageView mUploadCardId1View;
    ImageView mUploadCardId2View;
    ImageView mUploadCertifyView;
    private UpFilePresent mUpFilePresent;
    private ByhCommEvent.UploadImg mUpimageEvent;
    private PersonInfoPresent mPersonInfoPresent;
    private EditText mIdCardNumEdtView;
    private IVerifyPresenter mVertifyPresent;
    private EditText mUserNameEdtView;
    private String mDefaultUserName = null;
    private String mHeaderImageUrl;
    private String mIdcardFront;
    private String mIdcardBack;
    private String mBadgeUrl;
    private String mIdcardNo;
    private boolean isUpHeaderIcon = false;
    private boolean isUpIdcard1 = false;
    private boolean isUpIdcard2 = false;
    private boolean isUpVertifyCard = false;

    public static ProfesCertifyFragment getInstance() {
        return new ProfesCertifyFragment();
    }

    private void showUserName() {
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getContext()).getUserInfo();
        if (userInfoVOBean != null) {
            String name = userInfoVOBean.getName();
            if (!TextUtils.isEmpty((CharSequence)name)) {
                this.mUserNameEdtView.setText((CharSequence)StringUtil.subNameToStarName((String)name));
            } else {
                this.mUserNameEdtView.setHint((CharSequence)"***");
            }
        } else {
            this.mUserNameEdtView.setHint((CharSequence)"***");
        }
        this.mDefaultUserName = this.mUserNameEdtView.getText().toString().trim();
    }

    private String getDisplayName() {
        String currName = this.mUserNameEdtView.getText().toString().trim();
        if (this.mDefaultUserName != null && this.mDefaultUserName.equals(currName)) {
            ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getContext()).getUserInfo();
            if (userInfoVOBean != null) {
                return userInfoVOBean.getName();
            }
            return null;
        }
        return currName;
    }

    public void init() {
        this.mVertifyPresent = new VerifyPresenter((IVerNameByIdcardView)this);
        this.mUploadPersonPicView = (ImageView)this.findViewById(this.rootView, R.id.add_per_pic);
        this.mUploadCardId1View = (ImageView)this.findViewById(this.rootView, R.id.add_cardid1);
        this.mUploadCardId2View = (ImageView)this.findViewById(this.rootView, R.id.add_cardid2);
        this.mUploadCertifyView = (ImageView)this.findViewById(this.rootView, R.id.add_certify);
        this.mIdCardNumEdtView = (EditText)this.findViewById(this.rootView, R.id.idcardnum_edt);
        this.mUserNameEdtView = (EditText)this.findViewById(this.rootView, R.id.real_name_edt);
        this.showUserName();
        this.mPersonInfoPresent = new PersonInfoPresent(this);
        this.mUpFilePresent = new UpFilePresent((IUpFileView)this);
        this.vToolTitleTextView.setText(R.string.profes_certify);
        this.vRightTextView.setText(R.string.per_skip);
        this.vRightTextView.setVisibility(0);
        this.vRightTextView.setTextColor(-1);
        this.vRightTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ARouter.getInstance().build("/home/MainActivity").navigation();
            }
        });
        this.mUploadPersonPicView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ProfesCertifyFragment.this.startActivity(new Intent(ProfesCertifyFragment.this.getContext(), UpHeadIconActivity.class));
            }
        });
        this.registerClickUploadImgDialog(R.id.add_cardid1);
        this.registerClickUploadImgDialog(R.id.add_cardid2);
        this.registerClickUploadImgDialog(R.id.add_certify);
        this.findViewById(this.rootView, R.id.ci_certify).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!ProfesCertifyFragment.this.isUpHeaderIcon) {
                    ProfesCertifyFragment.this.showShortToast("\u8bf7\u4e0a\u4f20\u5934\u50cf");
                    return;
                }
                String idcardNum = ProfesCertifyFragment.this.mIdCardNumEdtView.getText().toString().trim();
                String userName = ProfesCertifyFragment.this.getDisplayName();
                boolean idcardIsNull = TextUtils.isEmpty((CharSequence)idcardNum);
                if (!ProfesCertifyFragment.this.isUpVertifyCard && idcardIsNull) {
                    ProfesCertifyFragment.this.showShortToast("\u8bf7\u4e0a\u4f20\u6267\u4e1a\u8bc1\u4e66\u6216\u8005\u586b\u5199\u8eab\u4efd\u8bc1\u53f7");
                    return;
                }
                if (!idcardIsNull) {
                    if (!VerifyUtil.isIdNo((String)(idcardNum = VerifyUtil.changeIdcard((String)idcardNum)))) {
                        ProfesCertifyFragment.this.showShortToast(ProfesCertifyFragment.this.getString(R.string.ver_idcard_err));
                        return;
                    }
                    if (!TextUtils.isEmpty((CharSequence)userName)) {
                        ProfesCertifyFragment.this.mVertifyPresent.verNameByIdcard(ProfesCertifyFragment.this.getContext(), userName, idcardNum);
                    } else {
                        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)ProfesCertifyFragment.this.getContext()).getUserInfo();
                        if (userInfoVOBean != null) {
                            String localUserName = userInfoVOBean.getName();
                            if (!TextUtils.isEmpty((CharSequence)localUserName)) {
                                ProfesCertifyFragment.this.mVertifyPresent.verNameByIdcard(ProfesCertifyFragment.this.getContext(), localUserName, idcardNum);
                            } else {
                                ToastUtils.showLong((CharSequence)"\u8bf7\u586b\u5199\u533b\u751f\u59d3\u540d");
                            }
                        }
                    }
                } else {
                    ReqWebBody reqWebBody = new ReqWebBody();
                    String accountId = VertifyDataUtil.getInstance((Context)ProfesCertifyFragment.this.getContext()).getLoginData().getAccountId();
                    reqWebBody.setAccountId(accountId);
                    if (!TextUtils.isEmpty((CharSequence)userName)) {
                        reqWebBody.setDisplayName(userName);
                    }
                    reqWebBody.setBadgeUrl(ProfesCertifyFragment.this.mBadgeUrl);
                    reqWebBody.setHeadImageUrl(ProfesCertifyFragment.this.mHeaderImageUrl);
                    reqWebBody.setIdCardBack(ProfesCertifyFragment.this.mIdcardBack);
                    reqWebBody.setIdCardFront(ProfesCertifyFragment.this.mIdcardFront);
                    ProfesCertifyFragment.this.mPersonInfoPresent.saveCertifyInfo(ProfesCertifyFragment.this.getContext(), reqWebBody);
                }
            }
        });
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void setImgByPath(ByhCommEvent.UploadImg uploadImgEvent) {
        if (uploadImgEvent.getViewId() != R.id.vUploadImage) {
            this.mUpimageEvent = uploadImgEvent;
            String path = (String)uploadImgEvent.getPhotoInfoList().get(0);
            if (this.getContext() == null) {
                return;
            }
            Luban.with((Context)this.getContext()).load(path).ignoreBy(20).setCompressListener(new OnCompressListener(){

                public void onStart() {
                    Log.i((String)ProfesCertifyFragment.this.TAG, (String)"==onStart====");
                }

                public void onSuccess(File file) {
                    String filePath = file.getAbsolutePath();
                    String fileSize = FileUtils.getAutoFileOrFilesSize((String)filePath);
                    Log.i((String)ProfesCertifyFragment.this.TAG, (String)("==onSuccess====fileSize==" + fileSize));
                    ProfesCertifyFragment.this.mUpFilePresent.upImgFile(filePath);
                }

                public void onError(Throwable e) {
                    Log.i((String)ProfesCertifyFragment.this.TAG, (String)("==onError==" + e.toString()));
                }
            }).launch();
        }
    }

    private void showUploadImg(String path, ImageView imageView) {
        Log.i((String)this.TAG, (String)("==showUploadImg==>" + path));
        Pretty.create().loadImage(path).diskCacheStrategy(DiskCacheStrategy.NONE).into(imageView);
    }

    private void registerClickUploadImgDialog(final int viewId) {
        this.findViewById(this.rootView, viewId).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                new UpPicBottomDialog((Context)ProfesCertifyFragment.this.getActivity(), viewId).show();
            }
        });
    }

    protected int getLayoutId() {
        return R.layout.profes_vertify_fragment;
    }

    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.getActivity().finish();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void showUpHeaderIconEvent(UpImgEntity upImgEntity) {
        this.mHeaderImageUrl = upImgEntity.getUrl();
        this.showUploadImg(this.mHeaderImageUrl, this.mUploadPersonPicView);
        this.isUpHeaderIcon = true;
    }

    public void showUpFileInfo(ResponseBody<UpImgEntity> upImgEntityResponseBody) {
        Log.i((String)this.TAG, (String)("upImgEntityResponseBody==>" + upImgEntityResponseBody.getResult()));
        String imgUrl = ((UpImgEntity)upImgEntityResponseBody.getResult()).getUrl();
        if (this.mUpimageEvent.getViewId() == R.id.add_cardid1) {
            this.mIdcardFront = imgUrl;
            this.showUploadImg(this.mIdcardFront, this.mUploadCardId1View);
            this.isUpIdcard1 = true;
        } else if (this.mUpimageEvent.getViewId() == R.id.add_cardid2) {
            this.mIdcardBack = imgUrl;
            this.showUploadImg(this.mIdcardBack, this.mUploadCardId2View);
            this.isUpIdcard2 = true;
        } else if (this.mUpimageEvent.getViewId() == R.id.add_certify) {
            this.mBadgeUrl = imgUrl;
            this.showUploadImg(this.mBadgeUrl, this.mUploadCertifyView);
            this.isUpVertifyCard = true;
        }
    }

    public void showErr(String msg) {
        this.showShortToast(msg);
    }

    public void showPersonInfo(LoginSuccess responseBody) {
        UpdateVerStatus.getInstance().updateDocDetailInfo(this.getContext(), null);
        this.replaceFragment((ISupportFragment)CertifyOkFragment.getInstance(), false);
        AppManager.getAppManager().finishActivity(PersonInfoActivity.class);
    }

    public void vertifySuccess(VertifyIDCardEntity vertifyIDCardEntity) {
        ReqWebBody reqWebBody = new ReqWebBody();
        String accountId = VertifyDataUtil.getInstance((Context)this.getContext()).getLoginData().getAccountId();
        reqWebBody.setDisplayName(vertifyIDCardEntity.getName());
        reqWebBody.setAccountId(accountId);
        reqWebBody.setBadgeUrl(this.mBadgeUrl);
        reqWebBody.setHeadImageUrl(this.mHeaderImageUrl);
        reqWebBody.setIdCardBack(this.mIdcardBack);
        reqWebBody.setIdCardFront(this.mIdcardFront);
        reqWebBody.setIdCardNo(vertifyIDCardEntity.getIdcard());
        reqWebBody.setCredTypeCode("01");
        this.mPersonInfoPresent.saveCertifyInfo(this.getContext(), reqWebBody);
    }
}

