/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin.present;

import android.content.Context;
import androidx.core.app.ActivityCompat;
import com.blankj.utilcode.util.AppUtils;
import com.blankj.utilcode.util.DeviceUtils;
import com.blankj.utilcode.util.PhoneUtils;
import com.blankj.utilcode.util.ScreenUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.entity.UserDevInfoEntity;
import com.byh.module.verlogin.module.IVerLoginModule;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.present.inter.IPushBindPresenter;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.global.Global;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.SampleObserver;
import io.reactivex.Observer;

public class PushBindPresenter
implements IPushBindPresenter {
    private IVerLoginModule module = new VerLoginModule();
    private Context mContext;

    public PushBindPresenter(Context context) {
        this.mContext = context;
    }

    @Override
    public void bindDeviceInfo(String clientId) {
        int loginUserId = VertifyDataUtil.getInstance((Context)this.mContext).getLoginUserId();
        UserDevInfoEntity userDevInfoEntity = new UserDevInfoEntity();
        userDevInfoEntity.setUserId(loginUserId);
        userDevInfoEntity.setUserType(Global.PUSH_USER_TYPE);
        userDevInfoEntity.setClientId(clientId);
        userDevInfoEntity.setRemark("");
        userDevInfoEntity.setManufacturer(DeviceUtils.getManufacturer());
        userDevInfoEntity.setPlatform("android");
        userDevInfoEntity.setScreenSize(ScreenUtils.getScreenWidth() + "*" + ScreenUtils.getScreenHeight());
        userDevInfoEntity.setModel(DeviceUtils.getModel());
        userDevInfoEntity.setLoginVersion(AppUtils.getAppVersionName());
        if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.READ_PHONE_STATE") != 0) {
            userDevInfoEntity.setMac(DeviceUtils.getMacAddress());
            return;
        }
        userDevInfoEntity.setImei(PhoneUtils.getIMEI());
        this.module.updateUserDeviceInfo(userDevInfoEntity).subscribe((Observer)new SampleObserver<ResponseBody>(){

            public void onNext(ResponseBody t) {
                if (t.getCode() != 200) {
                    ToastUtils.showShort((CharSequence)"\u7ed1\u5b9a\u8bbe\u5907id\u5931\u8d25");
                }
            }
        });
    }
}

