/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.date.DateUtil;
import com.ebaiyihui.his.common.enums.TransNoEnum;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.DeptDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.DeptReqDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.HisHeadDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.DeptResVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.DeptVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.ParentDeptResVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.ParentDeptVO;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.DeptService;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeptServiceImpl
implements DeptService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<DeptResVO>> getDeptList(DeptReqDTO param) {
        param.setOperCode("70019");
        param.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        DeptDTO deptDTO = new DeptDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(TransNoEnum.HIS_DEPARTMENT_INFO.getValue());
        deptDTO.setHeadDTO(headDTO);
        deptDTO.setDeptReqDTO(param);
        String converTomXml = XmlUtil.converTomXml((Object)deptDTO);
        FrontResponse deptVORes = this.hisRemoteService.hisNewRequest(TransNoEnum.HIS_DEPARTMENT_INFO.getValue(), converTomXml, DeptVO.class);
        DeptVO deptVO = (DeptVO)deptVORes.getBody();
        if (null == deptVO) {
            return FrontResponse.error((String)deptVORes.getTransactionId(), (String)"0", (String)deptVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        if (!"1".equals(deptVO.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)deptVORes.getTransactionId(), (String)"0", (String)deptVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        List deptResVOS = deptVO.getDepartmentVO().getDeptResVO();
        return FrontResponse.success((String)deptVORes.getTransactionId(), (Object)deptResVOS);
    }

    public FrontResponse<List<ParentDeptResVO>> getParentDeptList(DeptReqDTO param) {
        param.setOperCode("70019");
        param.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        DeptDTO deptDTO = new DeptDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(TransNoEnum.HIS_PARENT_DEPARTMENT_INFO.getValue());
        deptDTO.setHeadDTO(headDTO);
        deptDTO.setDeptReqDTO(param);
        String converTomXml = XmlUtil.converTomXml((Object)deptDTO);
        FrontResponse parentDeptVORes = this.hisRemoteService.hisNewRequest(TransNoEnum.HIS_PARENT_DEPARTMENT_INFO.getValue(), converTomXml, ParentDeptVO.class);
        ParentDeptVO parentDeptVO = (ParentDeptVO)parentDeptVORes.getBody();
        if (null == parentDeptVO) {
            return FrontResponse.error((String)parentDeptVORes.getTransactionId(), (String)"0", (String)parentDeptVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        if (!"1".equals(parentDeptVO.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)parentDeptVORes.getTransactionId(), (String)"0", (String)parentDeptVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        List parentDeptResVOS = parentDeptVO.getParentDepartmentVO().getParentDeptResVOS();
        return FrontResponse.success((String)parentDeptVORes.getTransactionId(), (Object)parentDeptResVOS);
    }
}

