/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.PayTypeEnums;
import com.ebaiyihui.his.pojo.dto.GetBillResDTO;
import com.ebaiyihui.his.pojo.dto.GetRealTimeHisBillItemResDTO;
import com.ebaiyihui.his.pojo.dto.GetRealTimeHisBillReqDTO;
import com.ebaiyihui.his.pojo.dto.RefundCallBackReqDTO;
import com.ebaiyihui.his.pojo.dto.RefundCallBackResDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.bill.GetHisBillInfoReqVo;
import com.ebaiyihui.his.pojo.vo.bill.GetHisBillInfoRes;
import com.ebaiyihui.his.pojo.vo.bill.GetHisBillInfoResItem;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillReqVo;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackReq;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackRes;
import com.ebaiyihui.his.service.HisBillService;
import com.ebaiyihui.his.service.HisRemoteService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HisBillServiceImpl
implements HisBillService {
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FrontResponse<GetHisBillInfoRes> getHisBillInfo(FrontRequest<GetHisBillInfoReqVo> param) {
        GetHisBillInfoRes getHisBillInfoRes = new GetHisBillInfoRes();
        ArrayList<GetHisBillInfoResItem> getHisBillInfoResItems = new ArrayList<GetHisBillInfoResItem>();
        GetHisBillInfoReqVo getHisBillInfoReqVo = (GetHisBillInfoReqVo)param.getBody();
        if (null == getHisBillInfoReqVo) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GetRealTimeHisBillReqDTO getRealTimeHisBillReqDTO = new GetRealTimeHisBillReqDTO();
        getRealTimeHisBillReqDTO.setTransType(getHisBillInfoReqVo.getTransType());
        getRealTimeHisBillReqDTO.setBegintime(getHisBillInfoReqVo.getBeginTime());
        getRealTimeHisBillReqDTO.setEndtime(getHisBillInfoReqVo.getEndTime());
        HashMap<String, GetRealTimeHisBillReqDTO> getRealTimeHisBillReqMap = new HashMap<String, GetRealTimeHisBillReqDTO>(1);
        getRealTimeHisBillReqMap.put(EntityKeyEnum.BILL_DETAIL_INFO.getValue(), getRealTimeHisBillReqDTO);
        FrontResponse getRealTimeHisBillRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.BILLING_DETAIL_HIS_INQUIRY.getValue(), getRealTimeHisBillReqMap, GetBillResDTO.class);
        GetBillResDTO hisBillResDTO = (GetBillResDTO)getRealTimeHisBillRes.getBody();
        if (null == hisBillResDTO) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)"1", (String)hisBillResDTO.getResultMsg());
        }
        if (!SUCCESS_FLAG.equals(hisBillResDTO.getResultCode())) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)SUCCESS_FLAG, (String)hisBillResDTO.getResultMsg());
        }
        List getRealTimeHisBillItemResDTOList = hisBillResDTO.getBillItemResDTO();
        if (CollectionUtils.isEmpty((Collection)getRealTimeHisBillItemResDTOList)) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)SUCCESS_FLAG, (String)hisBillResDTO.getResultMsg());
        }
        for (GetRealTimeHisBillItemResDTO billItemResDTO : getRealTimeHisBillItemResDTOList) {
            GetHisBillInfoResItem infoResItem = new GetHisBillInfoResItem();
            BeanUtils.copyProperties((Object)billItemResDTO, (Object)infoResItem);
            getHisBillInfoResItems.add(infoResItem);
        }
        getHisBillInfoRes.setItems(getHisBillInfoResItems);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getHisBillInfoRes);
    }

    public FrontResponse<GetHisBillInfoRes> getRealTimeHisBillInfo(FrontRequest<GetRealTimeHisBillReqVo> param) {
        GetHisBillInfoRes getHisBillInfoRes = new GetHisBillInfoRes();
        ArrayList<GetHisBillInfoResItem> getHisBillInfoResItems = new ArrayList<GetHisBillInfoResItem>();
        GetRealTimeHisBillReqVo getRealTimeHisBillReqVo = (GetRealTimeHisBillReqVo)param.getBody();
        if (null == getRealTimeHisBillReqVo) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GetRealTimeHisBillReqDTO getRealTimeHisBillReqDTO = new GetRealTimeHisBillReqDTO();
        getRealTimeHisBillReqDTO.setTransType(getRealTimeHisBillReqVo.getTransType());
        getRealTimeHisBillReqDTO.setOrderId(getRealTimeHisBillReqVo.getOrderid());
        HashMap<String, GetRealTimeHisBillReqDTO> getRealTimeHisBillReqMap = new HashMap<String, GetRealTimeHisBillReqDTO>(1);
        getRealTimeHisBillReqMap.put(EntityKeyEnum.BILL_DETAIL_INFO.getValue(), getRealTimeHisBillReqDTO);
        FrontResponse getRealTimeHisBillRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.BILLING_REAL_TIME_HIS_INQUIRY.getValue(), getRealTimeHisBillReqMap, GetBillResDTO.class);
        GetBillResDTO getBillResDTO = (GetBillResDTO)getRealTimeHisBillRes.getBody();
        if (null == getBillResDTO) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)"1", (String)getBillResDTO.getResultMsg());
        }
        if (!SUCCESS_FLAG.equals(getBillResDTO.getResultCode())) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)SUCCESS_FLAG, (String)getBillResDTO.getResultMsg());
        }
        List getRealTimeHisBillItemResDTOList = getBillResDTO.getBillItemResDTO();
        if (CollectionUtils.isEmpty((Collection)getRealTimeHisBillItemResDTOList)) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)SUCCESS_FLAG, (String)getBillResDTO.getResultMsg());
        }
        for (GetRealTimeHisBillItemResDTO billItemResDTO : getRealTimeHisBillItemResDTOList) {
            GetHisBillInfoResItem infoResItem = new GetHisBillInfoResItem();
            BeanUtils.copyProperties((Object)billItemResDTO, (Object)infoResItem);
            getHisBillInfoResItems.add(infoResItem);
        }
        getHisBillInfoRes.setItems(getHisBillInfoResItems);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getHisBillInfoRes);
    }

    public FrontResponse<RefundCallBackRes> refundCallBack(FrontRequest<RefundCallBackReq> param) {
        RefundCallBackReq paramBody = (RefundCallBackReq)param.getBody();
        RefundCallBackReqDTO refundCallBackReqDTO = new RefundCallBackReqDTO();
        refundCallBackReqDTO.setSerialNo(paramBody.getRefundSerialNo());
        refundCallBackReqDTO.setTradNo(paramBody.getTrandNo());
        refundCallBackReqDTO.setRefundTradNo(paramBody.getRefundTrandNo());
        refundCallBackReqDTO.setRefundTime(paramBody.getRefundTime());
        refundCallBackReqDTO.setPayType(PayTypeEnums.getDisplay((String)paramBody.getPayType()));
        HashMap<String, RefundCallBackReqDTO> refundCallBackMap = new HashMap<String, RefundCallBackReqDTO>(1);
        refundCallBackMap.put(EntityKeyEnum.REFUND_CALLBACK.getValue(), refundCallBackReqDTO);
        FrontResponse callBackRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.REFUND_CALLBACK.getValue(), refundCallBackMap, RefundCallBackResDTO.class);
        RefundCallBackResDTO callBackResBody = (RefundCallBackResDTO)callBackRes.getBody();
        if (null == callBackResBody) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)callBackRes.getMessage());
        }
        if (!SUCCESS_FLAG.equals(callBackResBody.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)callBackResBody.getResultMsg());
        }
        RefundCallBackRes refundCallBackRes = new RefundCallBackRes();
        refundCallBackRes.setState("1");
        refundCallBackRes.setMessage(callBackResBody.getResultMsg());
        return FrontResponse.success((String)param.getTransactionId(), (Object)refundCallBackRes);
    }
}

