/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.utils.medicalInsurance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.utils.medicalInsurance.EasyGmUtils;
import com.ebaiyihui.his.utils.medicalInsurance.SignUtil;
import com.ebaiyihui.his.utils.medicalInsurance.StringUtil;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.util.encoders.Hex;

/*
 * Exception performing whole class analysis ignored.
 */
public class HseEncAndDecUtil {
    private static final String version = "1.0.0";
    private static final String encType = "sm4";
    private static final String signType = "sm2";

    public static String signature(String message, String sm4key, String prvKey) {
        byte[] messageByte;
        try {
            JSONObject jsonObject = JSON.parseObject((String)message);
            HseEncAndDecUtil.removeEmpty((JSONObject)jsonObject);
            messageByte = SignUtil.getSignText((JSONObject)jsonObject, (String)sm4key).getBytes("UTF-8");
        }
        catch (Exception e) {
            messageByte = message.getBytes();
        }
        byte[] chnlSecretByte = sm4key.getBytes();
        byte[] prvkey = Base64.getDecoder().decode(prvKey);
        return Base64.getEncoder().encodeToString(EasyGmUtils.signSm3WithSm2((byte[])messageByte, (byte[])chnlSecretByte, (byte[])prvkey));
    }

    public static boolean verify(String msg, String source, String signData, String sm4key, String pubKey) {
        byte[] msgByte;
        try {
            JSONObject jsonObject = JSON.parseObject((String)msg);
            JSONObject jsonObjects = JSON.parseObject((String)source);
            jsonObjects.remove((Object)"signData");
            jsonObjects.remove((Object)"encData");
            jsonObjects.put("data", (Object)jsonObject);
            HseEncAndDecUtil.removeEmpty((JSONObject)jsonObject);
            String str = SignUtil.getSignText((JSONObject)jsonObjects, (String)sm4key);
            msgByte = str.getBytes("UTF-8");
        }
        catch (Exception e) {
            msgByte = msg.getBytes();
        }
        byte[] signatureByte = Base64.getDecoder().decode(signData);
        byte[] chnlSecretByte = sm4key.getBytes();
        byte[] pubKeyByte = Base64.getDecoder().decode(pubKey);
        return EasyGmUtils.verifySm3WithSm2((byte[])msgByte, (byte[])chnlSecretByte, (byte[])signatureByte, (byte[])pubKeyByte);
    }

    public static String sm4Encrypt(String chnlId, String sm4key, String message) throws Exception {
        byte[] appSecretEncData = EasyGmUtils.sm4Encrypt((byte[])chnlId.substring(0, 16).getBytes("UTF-8"), (byte[])sm4key.getBytes("UTF-8"));
        byte[] secKey = Hex.toHexString((byte[])appSecretEncData).toUpperCase().substring(0, 16).getBytes("UTF-8");
        return Hex.toHexString((byte[])EasyGmUtils.sm4Encrypt((byte[])secKey, (byte[])message.getBytes("UTF-8"))).toUpperCase();
    }

    public static String sm4Decrypt(String chnlId, String sm4key, String message) throws Exception {
        byte[] appSecretEncDataDecode = EasyGmUtils.sm4Encrypt((byte[])chnlId.substring(0, 16).getBytes("UTF-8"), (byte[])sm4key.getBytes("UTF-8"));
        byte[] secKeyDecode = Hex.toHexString((byte[])appSecretEncDataDecode).toUpperCase().substring(0, 16).getBytes("UTF-8");
        return new String(EasyGmUtils.sm4Decrypt((byte[])secKeyDecode, (byte[])Hex.decode((String)message)));
    }

    public static JSONObject buildMsg(String chnlId, String encData, String signData, String transType) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appId", (Object)chnlId);
        jsonObject.put("encData", (Object)encData);
        jsonObject.put("encType", (Object)"sm4");
        jsonObject.put("signData", (Object)signData);
        jsonObject.put("signType", (Object)"sm2");
        jsonObject.put("timestamp", (Object)System.currentTimeMillis());
        jsonObject.put("transType", (Object)transType);
        jsonObject.put("version", (Object)"1.0.0");
        return jsonObject;
    }

    public static JSONObject encryptMsg(String chnlId, String sm4key, String prvkey, String transType, JSONObject body) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appId", (Object)chnlId);
        jsonObject.put("encType", (Object)"sm4");
        jsonObject.put("data", (Object)body);
        jsonObject.put("signType", (Object)"sm2");
        jsonObject.put("timestamp", (Object)System.currentTimeMillis());
        jsonObject.put("transType", (Object)transType);
        jsonObject.put("version", (Object)"1.0.0");
        String encData = HseEncAndDecUtil.sm4Encrypt((String)chnlId, (String)sm4key, (String)body.toJSONString());
        String signData = HseEncAndDecUtil.signature((String)jsonObject.toJSONString(), (String)sm4key, (String)prvkey);
        jsonObject.fluentRemove((Object)"data");
        jsonObject.put("encData", (Object)encData);
        jsonObject.put("signData", (Object)signData);
        return jsonObject;
    }

    public static String decryptMsg(JSONObject jsonObject, String sm4key, String pubKey, String chnlIdSrc) throws Exception {
        String chnlId = (String)jsonObject.get((Object)"appId");
        chnlId = StringUtil.isEmpty((String)chnlId) ? chnlIdSrc : chnlId;
        String msg = (String)jsonObject.get((Object)"encData");
        String message = (String)jsonObject.get((Object)"message");
        String code = (String)jsonObject.get((Object)"code");
        if (!"0".equals(code)) {
            throw new RuntimeException(message);
        }
        String msgS = HseEncAndDecUtil.sm4Decrypt((String)chnlId, (String)sm4key, (String)msg);
        String signData = (String)jsonObject.get((Object)"signData");
        boolean flag = HseEncAndDecUtil.verify((String)msgS, (String)jsonObject.toJSONString(), (String)signData, (String)sm4key, (String)pubKey);
        if (!flag) {
            throw new RuntimeException("\u9a8c\u7b7e\u5931\u8d25\uff01\uff01\uff01");
        }
        return msgS;
    }

    private static void removeEmpty(JSONObject jsonObject) {
        Iterator it = jsonObject.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object value = entry.getValue();
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                if (jsonArray.size() == 0) {
                    it.remove();
                } else {
                    for (Object o : jsonArray) {
                        JSONObject asJsonObject = (JSONObject)o;
                        HseEncAndDecUtil.removeEmpty((JSONObject)asJsonObject);
                    }
                }
            }
            if (value instanceof JSONObject) {
                JSONObject asJsonObject = (JSONObject)value;
                HseEncAndDecUtil.removeEmpty((JSONObject)asJsonObject);
            }
            if (value == null) {
                it.remove();
            }
            if (!(value instanceof String) || !StringUtil.isEmpty(value)) continue;
            it.remove();
        }
    }

    public static void main(String[] args) throws Exception {
        String chnlId = "1GB7LT8LO00176430B0A00001331DF77";
        String encData = "";
        String signData = "";
        String transType = "";
        JSONObject jsonObject = HseEncAndDecUtil.buildMsg((String)chnlId, (String)encData, (String)signData, (String)transType);
        System.out.println(jsonObject.toJSONString());
    }
}

