/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicarecore.util.tool.encryption;

import cn.hutool.core.util.HexUtil;
import com.ebaiyihui.medicarecore.util.tool.encryption.SM2Util;
import com.ebaiyihui.medicarecore.util.tool.encryption.SMUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Base64;
import java.util.List;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import sun.misc.BASE64Decoder;

/*
 * Exception performing whole class analysis ignored.
 */
public class SM2Util {
    private BouncyCastleProvider provider;
    private X9ECParameters parameters;
    private ECParameterSpec ecParameterSpec;
    private KeyFactory keyFactory;
    BASE64Decoder decoder = new BASE64Decoder();

    public SM2Util() {
        try {
            this.provider = new BouncyCastleProvider();
            this.parameters = GMNamedCurves.getByName((String)"sm2p256v1");
            this.ecParameterSpec = new ECParameterSpec(this.parameters.getCurve(), this.parameters.getG(), this.parameters.getN(), this.parameters.getH());
            this.keyFactory = KeyFactory.getInstance("EC", (Provider)this.provider);
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
    }

    public String sign(String plainText, String prvKey) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException, IOException {
        Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)this.provider);
        BigInteger bigInteger = new BigInteger(prvKey, 16);
        BCECPrivateKey privateKey = (BCECPrivateKey)this.keyFactory.generatePrivate((KeySpec)new ECPrivateKeySpec(bigInteger, this.ecParameterSpec));
        signature.initSign((PrivateKey)privateKey);
        signature.update(plainText.getBytes());
        String signStr = Base64.getEncoder().encodeToString(signature.sign());
        signStr = new BigInteger(this.decoder.decodeBuffer(signStr)).toString(16);
        String derStr = SM2SignAsn1.parseSm2SignAsn1Object((String)signStr);
        byte[] hexStr = HexUtil.decodeHex((String)derStr);
        String signData = Base64.getEncoder().encodeToString(hexStr);
        return signData;
    }

    public boolean verify(String plainText, String signatureValue, String pubKey) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)this.provider);
        ECPoint ecPoint = this.parameters.getCurve().decodePoint(Hex.decode((String)pubKey));
        BCECPublicKey key = (BCECPublicKey)this.keyFactory.generatePublic((KeySpec)new ECPublicKeySpec(ecPoint, this.ecParameterSpec));
        signature.initVerify((PublicKey)key);
        signature.update(plainText.getBytes());
        byte[] signDataByte = Base64.getDecoder().decode(signatureValue);
        String sigDataHex = HexUtil.encodeHexStr((byte[])signDataByte);
        List list = SMUtil.getStrList((String)sigDataHex, (int)64, (int)2);
        String sm2SignAsn1 = SM2SignAsn1.buildSm2SignAsn1Object((BigInteger)new BigInteger((String)list.get(0), 16), (BigInteger)new BigInteger((String)list.get(1), 16));
        byte[] sm2SignAsn1Byte = HexUtil.decodeHex((String)sm2SignAsn1);
        String sm2SignAsn1ByteText = Base64.getEncoder().encodeToString(sm2SignAsn1Byte);
        return signature.verify(Base64.getDecoder().decode(sm2SignAsn1ByteText));
    }
}

