/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.filter;

import com.ebaiyihui.gateway.config.AuthorityConfig;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class ResourceAccessFilter
extends ZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(ResourceAccessFilter.class);
    @Autowired
    private AuthorityConfig authorityConfig;

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return -5;
    }

    public boolean shouldFilter() {
        boolean resourceFlag = this.authorityConfig.isResourceFlag();
        log.info("ResourceAccessFilter_resourceFlag:{}", (Object)resourceFlag);
        return resourceFlag;
    }

    public Object run() throws ZuulException {
        String[] pathsToMatch;
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        String requestURI = request.getRequestURI();
        for (String path : pathsToMatch = new String[]{"/druid", "/v2/api-docs", "/swagger-resources", "/swagger-ui.html", "/actuator"}) {
            if (!requestURI.contains(path)) continue;
            ctx.setResponseStatusCode(403);
            ctx.addZuulResponseHeader("Content-Type", "text/plain;charset=UTF-8");
            ctx.setResponseBody("You do not have permission to access this resource.");
            ctx.setSendZuulResponse(false);
            ctx.set("resource_access_filter_flag", (Object)true);
            return null;
        }
        return null;
    }
}

