/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.service;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.gateway.config.AuthorityConfig;
import com.ebaiyihui.gateway.enums.ErrorEnum;
import com.ebaiyihui.gateway.model.AuthRequest;
import com.ebaiyihui.gateway.model.AuthResult;
import com.ebaiyihui.gateway.service.AuthFeignClientAPI;
import com.ebaiyihui.gateway.service.LoginCheck;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationService.class);
    @Autowired
    private AuthorityConfig authorityConfig;
    @Autowired
    private LoginCheck loginCheckToken;
    @Autowired
    private AuthFeignClientAPI authFeignClientAPI;

    public AuthResult authenticate(AuthRequest authRequest) {
        try {
            String[] ipArray;
            log.info("\u5f00\u59cb\u8ba4\u8bc1 - IP: {}, URL: {}", (Object)authRequest.getIpAddress(), (Object)authRequest.getUrl());
            boolean enabled = this.authorityConfig.isEnabled();
            List whiteIpList = this.authorityConfig.getWhiteIpList();
            List whiteUrlList = this.authorityConfig.getIgnoreUrlList();
            log.info("whiteIpList: {}", (Object)whiteIpList);
            log.info("whiteUrlList: {}", (Object)whiteUrlList);
            String ipAddress = authRequest.getIpAddress();
            String urlAddress = authRequest.getUrl();
            String processedIp = ipAddress;
            if (StringUtils.isNotBlank((CharSequence)ipAddress) && (ipArray = ipAddress.split(",")).length > 0) {
                processedIp = ipArray[0].trim();
            }
            if (!enabled) {
                log.info("\u8ba4\u8bc1\u5f00\u5173\u5173\u95ed\uff0c\u8df3\u8fc7\u8ba4\u8bc1");
                return AuthResult.success().withWhitelistReason("\u8ba4\u8bc1\u5f00\u5173\u5173\u95ed");
            }
            if (whiteIpList.contains(processedIp)) {
                log.info("IP\u767d\u540d\u5355\u547d\u4e2d - \u539f\u59cbIP: {}, \u5904\u7406\u540eIP: {}", (Object)ipAddress, (Object)processedIp);
                return AuthResult.success().withWhitelistReason("IP\u767d\u540d\u5355");
            }
            if (whiteUrlList.contains(urlAddress)) {
                log.info("URL\u767d\u540d\u5355\u547d\u4e2d: {}", (Object)urlAddress);
                return AuthResult.success().withWhitelistReason("URL\u767d\u540d\u5355");
            }
            log.info("\u975e\u767d\u540d\u5355\u8bf7\u6c42\uff0c\u8fdb\u884c\u5b8c\u6574\u8ba4\u8bc1 - IP: {}, URL: {}", (Object)processedIp, (Object)urlAddress);
            AuthResult tokenResult = this.validateToken(authRequest);
            if (!tokenResult.isSuccess()) {
                return tokenResult;
            }
            if (!whiteIpList.contains(processedIp)) {
                AuthResult signResult = this.validateSignature(authRequest);
                if (!signResult.isSuccess()) {
                    return signResult;
                }
            } else {
                log.info("IP\u767d\u540d\u5355\u8df3\u8fc7\u7b7e\u540d\u9a8c\u8bc1: {}", (Object)processedIp);
            }
            return AuthResult.success();
        }
        catch (Exception e) {
            log.error("\u8ba4\u8bc1\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return AuthResult.fail((String)"\u8ba4\u8bc1\u5931\u8d25");
        }
    }

    private boolean isInIpWhitelist(String ipAddress) {
        if (StringUtils.isBlank((CharSequence)ipAddress)) {
            return false;
        }
        List whiteIpList = this.authorityConfig.getWhiteIpList();
        String[] ipArray = ipAddress.split(",");
        String realIp = ipAddress;
        if (ipArray.length > 0) {
            realIp = ipArray[0].trim();
        }
        boolean isWhite = whiteIpList.contains(realIp);
        log.info("IP\u767d\u540d\u5355\u68c0\u67e5 - \u539f\u59cbIP: {}, \u5904\u7406\u540eIP: {}, \u767d\u540d\u5355: {}, \u7ed3\u679c: {}", new Object[]{ipAddress, realIp, whiteIpList, isWhite});
        return isWhite;
    }

    private boolean isInUrlWhitelist(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        List ignoreUrlList = this.authorityConfig.getIgnoreUrlList();
        boolean isIgnore = ignoreUrlList.contains(url);
        log.info("URL\u767d\u540d\u5355\u68c0\u67e5 - URL: {}, \u5f53\u524d\u767d\u540d\u5355: {}, \u7ed3\u679c: {}", new Object[]{url, ignoreUrlList, isIgnore});
        return isIgnore;
    }

    private AuthResult validateToken(AuthRequest request) {
        String channelSource = request.getChannelSource();
        String cloudAuth = request.getCloudAuth();
        String token = request.getToken();
        String accessToken = request.getAccessToken();
        String cloud = request.getCloud();
        log.info("Token\u6821\u9a8c\u5f00\u59cb - channelSource: [{}], cloudAuth: [{}], cloud: [{}], token: [{}], accessToken: [{}]", new Object[]{channelSource, cloudAuth, cloud, token, accessToken});
        log.info("LARGE_TERMINAL\u5e38\u91cf\u503c: [{}], channelSource\u6bd4\u8f83\u7ed3\u679c: {}", (Object)"largeTerminal", (Object)"largeTerminal".equalsIgnoreCase(channelSource));
        try {
            if (!StringUtils.isNotBlank((CharSequence)cloud) || !"cloud".equals(cloud)) {
                if (StringUtils.isNotEmpty((CharSequence)cloudAuth) && "cloudAuth".equals(cloudAuth)) {
                    log.info("\u4e91\u7aef\u6821\u9a8c\u8d85\u7ba1,token:[{}]", (Object)token);
                    return this.checkCloudAuth(token);
                }
                if (StringUtils.isNotEmpty((CharSequence)channelSource) && "integratedManagement".equalsIgnoreCase(channelSource)) {
                    log.info("\u8282\u70b9\u6821\u9a8c\u7ba1\u7406\u5458,channelSource:{},token:[{}]", (Object)channelSource, (Object)token);
                    return this.checkNodeAuth(token, true);
                }
                if (StringUtils.isNotEmpty((CharSequence)channelSource) && "largeTerminal".equalsIgnoreCase(channelSource)) {
                    log.info("\u8282\u70b9\u6821\u9a8c\u60a3\u8005,accessToken:[{}]", (Object)accessToken);
                    return this.checkNodeAuth(accessToken != null ? accessToken : token, false);
                }
                log.info("\u4e91\u7aef\u6821\u9a8c\u533b\u751f,token:[{}]", (Object)token);
                return this.checkCloudDoctor(token);
            }
            log.info("\u8ba4\u8bc1\u4e2d\u5fc3\u8d85\u7ba1\u767b\u5f55");
            return AuthResult.success();
        }
        catch (Exception e) {
            log.error("Token\u6821\u9a8c\u5931\u8d25", (Throwable)e);
            return AuthResult.fail((String)"Token\u6821\u9a8c\u5931\u8d25");
        }
    }

    private AuthResult validateSignature(AuthRequest request) {
        String sign = request.getSign();
        String params = request.getParams();
        String appCode = request.getAppCode();
        String channelSource = request.getChannelSource();
        if (StringUtils.isBlank((CharSequence)sign)) {
            return AuthResult.fail((String)"\u6570\u636e\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
        }
        if (StringUtils.isNotBlank((CharSequence)params)) {
            String calculatedSign = "YCRMYY".equals(appCode) && "largeTerminal".equals(channelSource) ? this.md5YC(params) : this.md5(params);
            if (!calculatedSign.equals(sign)) {
                log.info("\u53c2\u6570\u7b7e\u540d\u6821\u9a8c\u5931\u8d25: \u4f20\u53c2->{}, \u8ba1\u7b97sign->{}, \u524d\u7aefsign->{}", new Object[]{params, calculatedSign, sign});
                return AuthResult.fail((String)"\u6570\u636e\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
            }
            log.info("\u53c2\u6570\u7b7e\u540d\u6821\u9a8c\u6210\u529f: sign->{}", (Object)sign);
        }
        return AuthResult.success();
    }

    private AuthResult checkNodeAuth(String accessToken, boolean isManagement) {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.info("\u83b7\u53d6accessToken \u7a7a");
            return AuthResult.fail((String)"\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5,\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        BaseResponse checkResult = this.loginCheckToken.check(accessToken);
        log.info("\u8c03\u7528\u8282\u70b9\u7528\u6237\u4e2d\u5fc3\u6821\u9a8c\u767b\u5f55\u8fd4\u56de\u6570\u636e:{}", (Object)checkResult);
        if (ErrorEnum.FEIGN_FAIL.getErrCode().equals(checkResult.getCode())) {
            log.info("\u8c03\u7528\u7528\u6237\u4e2d\u5fc3token\u5931\u8d25");
            return AuthResult.fail((String)"\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u6821\u9a8cToken\u5f02\u5e38");
        }
        if (!checkResult.isSuccess()) {
            return AuthResult.fail((String)checkResult.getMsg());
        }
        return AuthResult.success((Object)checkResult.getData());
    }

    private AuthResult checkCloudAuth(String cloudToken) {
        if (StringUtils.isBlank((CharSequence)cloudToken)) {
            log.info("\u83b7\u53d6\u8d85\u7ba1\u7aefcloudToken \u7a7a");
            return AuthResult.fail((String)"\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5,\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap param = new LinkedMultiValueMap();
            param.add((Object)"token", (Object)cloudToken);
            HttpEntity paramEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
            BaseResponse authResponse = (BaseResponse)restTemplate.postForObject(this.authorityConfig.getSuperAdminAuthUrl(), (Object)paramEntity, BaseResponse.class, new Object[0]);
            log.info("\u8c03\u7528\u4e91\u4e0a\u6821\u9a8c\u8d85\u7ba1\u767b\u5f55\u8fd4\u56de\u6570\u636e:{}", (Object)authResponse);
            if (Objects.isNull(authResponse) || ErrorEnum.SYSYTEM_UNKNOW.getErrCode().equals(authResponse.getErrCode())) {
                return AuthResult.fail((String)ErrorEnum.SYSYTEM_UNKNOW.getMsg());
            }
            if (ErrorEnum.NO_PERMISSION.getErrCode().equals(authResponse.getErrCode())) {
                return AuthResult.fail((String)authResponse.getMsg());
            }
            return AuthResult.success((Object)authResponse.getData());
        }
        catch (Exception e) {
            log.error("\u4e91\u7aef\u8d85\u7ba1\u8ba4\u8bc1\u5f02\u5e38", (Throwable)e);
            return AuthResult.fail((String)"\u4e91\u7aef\u8d85\u7ba1\u8ba4\u8bc1\u5931\u8d25");
        }
    }

    private AuthResult checkCloudDoctor(String doctorAccessToken) {
        if (StringUtils.isBlank((CharSequence)doctorAccessToken)) {
            log.info("\u83b7\u53d6doctorAccessToken\u5931\u8d25 \u7a7a");
            return AuthResult.fail((String)"\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5,\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            JSONObject param = new JSONObject();
            param.put("token", (Object)doctorAccessToken);
            param.put("customerFlag", (Object)"false");
            param.put("channelCode", (Object)"byh_node_gateWay");
            HttpEntity paramEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
            log.info("\u8c03\u7528\u4e91\u4e0a\u6821\u9a8c\u533b\u751f,\u53d1\u8d77\u8bf7\u6c42Url:" + this.authorityConfig.getCloudDoctorAuthUrl());
            BaseResponse authResponse = (BaseResponse)restTemplate.postForObject(this.authorityConfig.getCloudDoctorAuthUrl(), (Object)paramEntity, BaseResponse.class, new Object[0]);
            log.info("\u8c03\u7528\u4e91\u4e0a\u6821\u9a8c\u533b\u751f\u767b\u5f55\u8fd4\u56de\u6570\u636e:{}", (Object)authResponse);
            if (Objects.isNull(authResponse) || ErrorEnum.SYSYTEM_UNKNOW.getErrCode().equals(authResponse.getErrCode())) {
                return AuthResult.fail((String)ErrorEnum.SYSYTEM_UNKNOW.getMsg());
            }
            if (!authResponse.isSuccess()) {
                return AuthResult.fail((String)authResponse.getMsg());
            }
            return AuthResult.success((Object)authResponse.getData());
        }
        catch (Exception e) {
            log.error("\u4e91\u7aef\u533b\u751f\u8ba4\u8bc1\u5f02\u5e38", (Throwable)e);
            return AuthResult.fail((String)"\u4e91\u7aef\u533b\u751f\u8ba4\u8bc1\u5931\u8d25");
        }
    }

    private String md5(String data) {
        String stringToMD5 = DigestUtils.md5Hex((String)data);
        String md5codeBefore = stringToMD5.substring(0, 12);
        String md5codeRemaining = stringToMD5.substring(12, stringToMD5.length());
        String md5codeAfter = stringToMD5.substring(stringToMD5.length() - 10);
        String md5codeResults = md5codeRemaining.substring(0, md5codeRemaining.length() - 10);
        return DigestUtils.md5Hex((String)(md5codeAfter + md5codeResults + md5codeBefore));
    }

    private String md5YC(String data) {
        log.info("data:" + data);
        String stringToMD5 = DigestUtils.md5Hex((String)data);
        log.info("stringToMD5:" + stringToMD5);
        String md5codeBefore = stringToMD5.substring(0, 12);
        String md5codeRemaining = stringToMD5.substring(12, stringToMD5.length());
        String md5codeAfter = stringToMD5.substring(stringToMD5.length() - 10);
        String md5codeResults = md5codeRemaining.substring(0, md5codeRemaining.length() - 10);
        return DigestUtils.md5Hex((String)(md5codeAfter + md5codeBefore + md5codeResults));
    }
}

