/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.service.Impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.gateway.common.Constants;
import com.ebaiyihui.gateway.config.AuthorityConfig;
import com.ebaiyihui.gateway.dao.IgnoreMapper;
import com.ebaiyihui.gateway.dao.IgnoreVo;
import com.ebaiyihui.gateway.dao.LoginResVo;
import com.ebaiyihui.gateway.service.IgnoreService;
import com.ebaiyihui.gateway.utils.RedisUtil;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IgnoreServiceImpl
implements IgnoreService {
    private static final Logger log = LoggerFactory.getLogger(IgnoreServiceImpl.class);
    @Autowired
    private IgnoreMapper ignoreUrlMapper;
    @Autowired
    private AuthorityConfig authorityConfig;

    public void getAll(Integer status) {
        String appCode = this.authorityConfig.getAppCode();
        List all = this.ignoreUrlMapper.getAll(status, appCode);
        if (status.equals(Constants.TYPE_ONE)) {
            this.authorityConfig.putUrl(all);
            log.info("\u5b8c\u6210\u63a5\u53e3\u767d\u540d\u5355\u52a0\u8f7d,\u5171{}\u6761\u8bb0\u5f55", (Object)all.size());
        }
        if (status.equals(Constants.TYPE_TWO)) {
            this.authorityConfig.putIp(all);
            log.info("\u5b8c\u6210IP\u767d\u540d\u5355\u52a0\u8f7d,\u5171{}\u6761\u8bb0\u5f55", (Object)all.size());
        }
    }

    public List<IgnoreVo> getListByStatus(Integer status) {
        String appCode = this.authorityConfig.getAppCode();
        log.info("appCode==>{}", (Object)appCode);
        return this.ignoreUrlMapper.getListByStatus(status, appCode);
    }

    public BaseResponse delete(Long id) {
        IgnoreVo ignoreVo = this.ignoreUrlMapper.getById(id);
        log.info("ignoreVo==>{}", (Object)JSON.toJSONString((Object)ignoreVo));
        this.ignoreUrlMapper.delete(id);
        this.authorityConfig.del(ignoreVo.getName(), ignoreVo.getStatus());
        return BaseResponse.success();
    }

    public BaseResponse update(Long id, String name) {
        IgnoreVo ignoreVo = this.ignoreUrlMapper.getById(id);
        log.info("ignoreVo==>{}", (Object)JSON.toJSONString((Object)ignoreVo));
        this.ignoreUrlMapper.update(id, name);
        this.authorityConfig.del(ignoreVo.getName(), ignoreVo.getStatus());
        this.authorityConfig.set(name, ignoreVo.getStatus());
        return BaseResponse.success();
    }

    public BaseResponse add(String name, Integer status) {
        String appCode = this.authorityConfig.getAppCode();
        IgnoreVo byName = this.ignoreUrlMapper.getByName(name, appCode);
        if (byName == null) {
            IgnoreVo ignoreVo = new IgnoreVo();
            ignoreVo.setName(name);
            ignoreVo.setStatus(status);
            ignoreVo.setAppCode(appCode);
            this.ignoreUrlMapper.insert(ignoreVo);
            this.authorityConfig.set(name, ignoreVo.getStatus());
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u5df2\u6709\u6570\u636e,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0!");
    }

    public BaseResponse<LoginResVo> login(String userName, String password) {
        if (!Objects.equals("byh", userName) || !Objects.equals("byh@gateway", password)) {
            return BaseResponse.error((String)"\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef");
        }
        String token = String.valueOf(System.currentTimeMillis());
        LoginResVo loginResVo = new LoginResVo();
        loginResVo.setToken(token);
        loginResVo.setUserName("byh");
        RedisUtil.set((String)"byh", (String)token, (long)4L);
        return BaseResponse.success((Object)loginResVo);
    }
}

