/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.config;

import com.ebaiyihui.gateway.config.AuthorityConfig;
import com.ebaiyihui.gateway.config.MultipartConfig;
import com.ebaiyihui.gateway.filter.IErrorFilter;
import com.ebaiyihui.gateway.filter.IgnoreAuthFilter;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
public class FilterAddConfig {
    @Autowired
    private IgnoreAuthFilter ignoreAuthFilter;
    @Autowired
    private AuthorityConfig authorityConfig;
    @Autowired
    private MultipartConfig multipartConfig;

    public CorsFilter createFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedMethod("*");
        source.registerCorsConfiguration("/**", corsConfiguration);
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    public FilterRegistrationBean registerFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)this.ignoreAuthFilter);
        List ignoreAuthUrl = this.authorityConfig.getIgnoreUrlList();
        registration.addUrlPatterns(ignoreAuthUrl.toArray(new String[0]));
        registration.setName(this.ignoreAuthFilter.getClass().getSimpleName());
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public IErrorFilter iErrorFilter() {
        return IErrorFilter.builder().build();
    }

    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(this.multipartConfig.getMaxFileSize());
        factory.setMaxRequestSize(this.multipartConfig.getMaxRequestSize());
        factory.setFileSizeThreshold(this.multipartConfig.getFileSizeThreshold());
        factory.setLocation(this.multipartConfig.getLocation());
        return factory.createMultipartConfig();
    }
}

