/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="websocket")
public class WebSocketProperties {
    private List<String> handlerPaths = new ArrayList();
    private boolean enabled = true;
    private List<String> allowedOrigins = new ArrayList();
    private int bufferSize = 0x100000;
    private long timeout = 300000L;

    public WebSocketProperties() {
        this.handlerPaths.add("/ws/**");
        this.handlerPaths.add("/websocket/**");
        this.allowedOrigins.add("*");
    }

    public String[] getHandlerPathsArray() {
        return this.handlerPaths.toArray(new String[0]);
    }

    public String[] getAllowedOriginsArray() {
        return this.allowedOrigins.toArray(new String[0]);
    }

    public void addHandlerPath(String path) {
        if (path != null && !this.handlerPaths.contains(path)) {
            this.handlerPaths.add(path);
        }
    }

    public void removeHandlerPath(String path) {
        this.handlerPaths.remove(path);
    }

    public void addAllowedOrigin(String origin) {
        if (origin != null && !this.allowedOrigins.contains(origin)) {
            this.allowedOrigins.add(origin);
        }
    }

    public void removeAllowedOrigin(String origin) {
        this.allowedOrigins.remove(origin);
    }

    public List<String> getHandlerPaths() {
        return this.handlerPaths;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setHandlerPaths(List<String> handlerPaths) {
        this.handlerPaths = handlerPaths;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSocketProperties)) {
            return false;
        }
        WebSocketProperties other = (WebSocketProperties)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$handlerPaths = this.getHandlerPaths();
        List other$handlerPaths = other.getHandlerPaths();
        if (this$handlerPaths == null ? other$handlerPaths != null : !((Object)this$handlerPaths).equals(other$handlerPaths)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        List this$allowedOrigins = this.getAllowedOrigins();
        List other$allowedOrigins = other.getAllowedOrigins();
        if (this$allowedOrigins == null ? other$allowedOrigins != null : !((Object)this$allowedOrigins).equals(other$allowedOrigins)) {
            return false;
        }
        if (this.getBufferSize() != other.getBufferSize()) {
            return false;
        }
        return this.getTimeout() == other.getTimeout();
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebSocketProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $handlerPaths = this.getHandlerPaths();
        result = result * 59 + ($handlerPaths == null ? 43 : ((Object)$handlerPaths).hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        List $allowedOrigins = this.getAllowedOrigins();
        result = result * 59 + ($allowedOrigins == null ? 43 : ((Object)$allowedOrigins).hashCode());
        result = result * 59 + this.getBufferSize();
        long $timeout = this.getTimeout();
        result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
        return result;
    }

    public String toString() {
        return "WebSocketProperties(handlerPaths=" + this.getHandlerPaths() + ", enabled=" + this.isEnabled() + ", allowedOrigins=" + this.getAllowedOrigins() + ", bufferSize=" + this.getBufferSize() + ", timeout=" + this.getTimeout() + ")";
    }
}

