/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.service.Impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.common.token.TokenJson;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.gateway.config.RequestWrapper;
import com.ebaiyihui.gateway.filter.AuthorityFilter;
import com.ebaiyihui.gateway.service.LoginCheck;
import com.ebaiyihui.usercenter.client.NodeAccountClient;
import com.netflix.zuul.context.RequestContext;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class LoginCheckToken
implements LoginCheck {
    private static final Logger log = LoggerFactory.getLogger(LoginCheckToken.class);
    @Autowired
    private NodeAccountClient nodeAccountClient;

    public BaseResponse check(String accessToken) {
        return this.nodeAccountClient.validateAccessToken(accessToken);
    }

    @Async
    public void loggingStored(TokenJson tokenJson, RequestContext currentContext, String cloudDoctorAuthUrl) {
        String param;
        HttpServletRequest request = currentContext.getRequest();
        RestTemplate restTemplate = new RestTemplate();
        String cloudUrl = StringUtils.substringBefore((String)cloudDoctorAuthUrl, (String)"cloud");
        String loggingStoredUrl = cloudUrl + "cloud/sysinfocloud/operationlog/insertOperationLog";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, String> map = new HashMap<String, String>();
        String appCode = request.getHeader("appCode");
        String channelSource = request.getHeader("channelSource");
        String cloudAuth = request.getHeader("cloudAuth");
        String ipAddress = AuthorityFilter.getIpAddress((HttpServletRequest)request);
        String urlAddress = request.getRequestURI();
        RequestWrapper requestWrapper = new RequestWrapper(request);
        String body = requestWrapper.getBody();
        String getParam = AuthorityFilter.getParamOfMethodGet((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)getParam)) {
            param = getParam;
        } else {
            param = body;
            if (StringUtils.isNotBlank((CharSequence)request.getContentType()) && request.getContentType().contains("multipart")) {
                param = "";
            }
        }
        map.put("appCode", appCode);
        if (StringUtils.isNotEmpty((CharSequence)channelSource)) {
            map.put("channelSource", channelSource);
        } else if (StringUtils.isNotEmpty((CharSequence)cloudAuth)) {
            map.put("channelSource", cloudAuth);
        } else {
            map.put("channelSource", "appChannel");
        }
        map.put("ip", ipAddress);
        map.put("name", tokenJson.getName());
        map.put("phone", tokenJson.getAccountNo());
        map.put("reqUrl", urlAddress);
        map.put("reqParams", param);
        log.info("httpEntity--->{}", (Object)JSON.toJSONString(map));
        restTemplate.postForObject(loggingStoredUrl, map, String.class, new Object[0]);
    }
}

