/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.utils;

import com.ebaiyihui.physical.utils.DateUtils;
import java.util.Date;
import java.util.UUID;

public class GenSeqUtils {
    public static final String PREFIX_DEAL = "01";
    public static final String PREFIX_BILL = "02";
    public static final String PREFIX_ORDER = "03";
    public static final String PREFIX_PAYLIST = "04";
    public static final String PREFIX_CUSTOMER = "05";
    public static final String PREFIX_BANKCARD_ACCREDIT = "06";
    public static final String PREFIX_AUTHID = "a";
    public static final String PREFIX_CCBPAY_QUERY = "cq";
    public static final String PREFIX_PAYMENT = "pm";
    public static final int DEFAULT_LEN = 4;
    public static final String SIMPLE = "yyMMddhhmmssSSS";
    public static final String SIMPLE_FORMAT = "yyyy-MM-dd";

    public static String genRandomSeq(int length) {
        int len = length < 1 ? 4 : length;
        double dd = (1.0 + Math.random()) * Math.pow(10.0, len);
        return String.valueOf(dd).substring(1, len + 1);
    }

    public static String genRandomSeq() {
        double dd = (1.0 + Math.random()) * Math.pow(10.0, 4.0);
        return String.valueOf(dd).substring(1, 5);
    }

    public static String genCcbPayQuery() {
        String randomSeq = GenSeqUtils.genRandomSeq(4);
        String time = DateUtils.getDate(SIMPLE);
        return PREFIX_CCBPAY_QUERY + randomSeq + time;
    }

    public static String genCustomerSeq(String bizSysOrderSeq) {
        String randomSeq = GenSeqUtils.genRandomSeq(4);
        String time = DateUtils.getDate(SIMPLE);
        return PREFIX_CUSTOMER + bizSysOrderSeq + randomSeq + time;
    }

    public static String genPaylistSeq(String bizSysOrderSeq) {
        String randomSeq = GenSeqUtils.genRandomSeq(4);
        String time = DateUtils.getDate(SIMPLE);
        return PREFIX_PAYLIST + bizSysOrderSeq + randomSeq + time;
    }

    public static String genDealSeq(String bizSysOrderSeq) {
        String randomSeq = GenSeqUtils.genRandomSeq(4);
        String date = DateUtils.dateToString(new Date(), SIMPLE_FORMAT);
        String time = DateUtils.getDate(date);
        return PREFIX_DEAL + bizSysOrderSeq + randomSeq + time;
    }

    public static String genCCBQRCodeDealSeq(String merchantId) {
        String randomSeq = GenSeqUtils.genRandomSeq(4);
        String string = UUID.randomUUID().toString();
        int code = Math.abs(string.hashCode());
        String seq = code + randomSeq;
        return merchantId + seq.substring(0, 12);
    }

    public static String genBillSeq(String bizSysOrderSeq) {
        String randomSeq = GenSeqUtils.genRandomSeq(4);
        String time = DateUtils.getDate(SIMPLE);
        return PREFIX_BILL + bizSysOrderSeq + randomSeq + time;
    }

    public static String genOrderSeq(String bizSysOrderSeq) {
        String randomSeq = GenSeqUtils.genRandomSeq(4);
        String time = DateUtils.getDate(SIMPLE);
        return PREFIX_ORDER + bizSysOrderSeq + randomSeq + time;
    }

    public static String genAccreditSeq(String bizSysOrderSeq) {
        String randomSeq = GenSeqUtils.genRandomSeq(4);
        String time = DateUtils.getDate(SIMPLE);
        return PREFIX_BANKCARD_ACCREDIT + bizSysOrderSeq + randomSeq + time;
    }

    public static String genAuthId(String bizSysSeq) {
        String randomSeq = GenSeqUtils.genRandomSeq(4);
        String time = DateUtils.getDate(SIMPLE);
        return PREFIX_AUTHID + randomSeq + time;
    }

    public static String genPaymentSeq(String merchantSeq) {
        String randomSeq = GenSeqUtils.genRandomSeq(4);
        String time = DateUtils.getDate(SIMPLE);
        return PREFIX_PAYMENT + merchantSeq + randomSeq + time;
    }

    public static String getUniqueNo() {
        return GenSeqUtils.genDealSeq("");
    }

    public static String getCheckCode() {
        return GenSeqUtils.genRandomSeq(4);
    }
}

