/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.utils;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLContext;
import org.apache.http.client.ClientProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int SO_TIMEOUT = 45000;
    private static final int MAX_TOTAL_CONNECTION = 1000;
    static AsyncHttpClient asyncHttpClient;
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private static final String CONTENT_TYPE = "Content-Type";

    public String get(String url, Map<String, String> params, Map<String, String> headers) {
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.prepareGet(url);
        builder.setBodyEncoding(DEFAULT_CHARSET);
        if (params != null && !params.isEmpty()) {
            Set<String> keys = params.keySet();
            keys.forEach(k -> builder.addQueryParam(k, (String)params.get(k)));
            if (headers != null && !headers.isEmpty()) {
                Set<String> headerkeys = headers.keySet();
                headerkeys.forEach(hk -> builder.addHeader(hk, (String)params.get(hk)));
            }
        }
        ListenableFuture f = builder.execute();
        String body = null;
        try {
            body = ((Response)f.get()).getResponseBody(DEFAULT_CHARSET);
        }
        catch (Exception e) {
            log.error("Exception", (Throwable)e);
        }
        return body;
    }

    public String get(String url) throws IOException {
        return this.get(url, null);
    }

    public String get(String url, Map<String, String> params) {
        return this.get(url, params, null);
    }

    public String post(String url, Map<String, String> params) throws IOException {
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.preparePost(url);
        builder.setBodyEncoding(DEFAULT_CHARSET);
        if (params != null && !params.isEmpty()) {
            Set<String> keys = params.keySet();
            for (String key : keys) {
                builder.addQueryParam(key, String.valueOf(params.get(key)));
            }
        }
        ListenableFuture f = builder.execute();
        String body = null;
        try {
            body = ((Response)f.get()).getResponseBody(DEFAULT_CHARSET);
        }
        catch (Exception e) {
            log.error("\u53d1\u751f\u5f02\u5e38,uel ={},e={}", (Object)url, (Object)e);
        }
        return body;
    }

    public String post(String url, String s) throws IOException, ExecutionException, InterruptedException {
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.preparePost(url);
        builder.setHeader(CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
        builder.setBodyEncoding(DEFAULT_CHARSET);
        builder.setBody(s);
        ListenableFuture f = builder.execute();
        return ((Response)f.get()).getResponseBody(DEFAULT_CHARSET);
    }

    public String doPost(String url, String params, String charset, String contentType) throws ClientProtocolException, IOException {
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.preparePost(url);
        builder.setBodyEncoding(charset);
        builder.setBody(params);
        builder.setHeader(CONTENT_TYPE, contentType);
        ListenableFuture f = builder.execute();
        String body = null;
        try {
            body = ((Response)f.get()).getResponseBody(DEFAULT_CHARSET);
        }
        catch (Exception e) {
            log.error("doPost\u8bf7\u6c42 \u53d1\u751f\u5f02\u5e38,uel ={},e={}", (Object)url, (Object)e);
        }
        return body;
    }

    public String doPostBySslsf(String url, String params, String contentType, SSLContext sslContext) throws IOException {
        AsyncHttpClient http = new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setConnectTimeout(45000).setSSLContext(sslContext).build());
        AsyncHttpClient.BoundRequestBuilder builder = http.preparePost(url);
        builder.setBodyEncoding(DEFAULT_CHARSET);
        builder.setBody(params);
        builder.setHeader(CONTENT_TYPE, contentType);
        ListenableFuture f = builder.execute();
        String body = null;
        try {
            body = ((Response)f.get()).getResponseBody(DEFAULT_CHARSET);
        }
        catch (Exception e) {
            log.error("doPostBySslsf\u8bf7\u6c42 \u53d1\u751f\u5f02\u5e38,uel ={},e={}", (Object)url, (Object)e);
        }
        http.close();
        return body;
    }

    public String doPostBySslsf(String url, Map<String, String> params, String contentType, SSLContext sslContext) throws IOException {
        AsyncHttpClient http = new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setConnectTimeout(45000).setSSLContext(sslContext).build());
        AsyncHttpClient.BoundRequestBuilder builder = http.preparePost(url);
        if (params != null && !params.isEmpty()) {
            Set<String> keys = params.keySet();
            for (String key : keys) {
                builder.addQueryParam(key, params.get(key));
            }
        }
        builder.setHeader(CONTENT_TYPE, contentType);
        ListenableFuture f = builder.execute();
        String body = null;
        try {
            body = ((Response)f.get()).getResponseBody(DEFAULT_CHARSET);
        }
        catch (Exception e) {
            log.error("doPostBySslsf\u8bf7\u6c42 \u53d1\u751f\u5f02\u5e38,uel ={},e={}", (Object)url, (Object)e);
        }
        http.close();
        return body;
    }

    public String jsonPost(String url, String bodyJsonStr) throws IOException, ExecutionException, InterruptedException {
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.preparePost(url);
        builder.setHeader(CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
        builder.setBodyEncoding(DEFAULT_CHARSET);
        builder.setBody(bodyJsonStr);
        log.info("\u5f00\u59cb\u8bf7\u6c42\uff0c\u8bf7\u6c42\u5730\u5740:{},\u8bf7\u6c42json\u53c2\u6570:{}", (Object)url, (Object)bodyJsonStr);
        ListenableFuture f = builder.execute();
        String body = ((Response)f.get()).getResponseBody(DEFAULT_CHARSET);
        log.info("\u8bf7\u6c42\u7ed3\u675f,\u54cd\u5e94\u7ed3\u679c:{}", (Object)body);
        return body;
    }

    public HttpUtil() {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setMaxConnections(1000);
        builder.setMaxConnectionsPerHost(2000);
        builder.setRequestTimeout(45000);
        asyncHttpClient = new AsyncHttpClient(builder.build());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpUtil)) {
            return false;
        }
        HttpUtil other = (HttpUtil)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpUtil;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "HttpUtil()";
    }
}

