/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.config;

import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqConfig {
    public static final String DELAYED_DEAL_WITH_ORDER_QUEUE_NAME = "physical.delayed.order.test";
    public static final String DELAYED_DEAL_PUSH_SEND_QUEUE_NAME = "physical.delayed.order.push.name";
    public static final String EXCHANGE_NAME = "physical.delayed_exchange";
    public static final String DELAYED_DEAL_WITH_ORDER_QUEUE_KEY = "physical.delayed_order_routing_key";
    public static final String DELAYED_DEAL_PUSH_SEND_QUEUE_KEY = "physical.delayed.order.push.key";

    @Bean
    public Queue queue() {
        return new Queue(DELAYED_DEAL_WITH_ORDER_QUEUE_NAME);
    }

    @Bean
    public Queue sendQueue() {
        return new Queue(DELAYED_DEAL_PUSH_SEND_QUEUE_NAME);
    }

    @Bean
    CustomExchange customExchange() {
        HashMap<String, String> args = new HashMap<String, String>(1);
        args.put("x-delayed-type", "direct");
        return new CustomExchange(EXCHANGE_NAME, "x-delayed-message", true, false, args);
    }

    @Bean
    Binding bindingOrder() {
        return BindingBuilder.bind((Queue)this.queue()).to((Exchange)this.customExchange()).with(DELAYED_DEAL_WITH_ORDER_QUEUE_KEY).noargs();
    }

    @Bean
    Binding bindingSend() {
        return BindingBuilder.bind((Queue)this.sendQueue()).to((Exchange)this.customExchange()).with(DELAYED_DEAL_PUSH_SEND_QUEUE_KEY).noargs();
    }
}

