/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.mq;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.physical.entity.OrderEntity;
import com.ebaiyihui.physical.enums.OrderStatusEnum;
import com.ebaiyihui.physical.mapper.OrderMapper;
import com.ebaiyihui.physical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.physical.vo.DelayMqEntity;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.Transactional;

@Configuration
public class DelayDealWithOrderStatusMq {
    private static final Logger log = LoggerFactory.getLogger(DelayDealWithOrderStatusMq.class);
    @Autowired
    OrderMapper orderMapper;
    @Autowired
    ScheduleRecordMapper scheduleRecordMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RabbitListener(queues={"physical.delayed.order.test"})
    @RabbitHandler
    @Transactional(rollbackFor={Exception.class})
    public void updateOrderStatus(String strDelayMqEntity) {
        try {
            OrderEntity order;
            DelayMqEntity delayMqEntity = (DelayMqEntity)JSON.parseObject((String)strDelayMqEntity, DelayMqEntity.class);
            log.info("updateOrderStatus->{}", (Object)JSON.toJSONString((Object)delayMqEntity));
            if (delayMqEntity.getType().equals("1") && Objects.nonNull(order = (OrderEntity)this.orderMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)delayMqEntity.getOrderId())))) {
                log.info("\u9700\u8981\u4fee\u6539\u7684\u8ba2\u5355\u4fe1\u606f{}", (Object)order);
                if (Objects.equals(order.getOrderStatus(), OrderStatusEnum.WAIT_SUBMIT_PAY.getCode()) || Objects.equals(order.getOrderStatus(), OrderStatusEnum.WAIT_PAY.getCode())) {
                    if (Objects.equals(order.getOrderStatus(), OrderStatusEnum.WAIT_PAY.getCode())) {
                        this.scheduleRecordMapper.releaseSchedule(Long.valueOf(order.getScheduleRecordId()));
                        log.info("\u53f7\u6e90\u91ca\u653e\u7684ID{}", (Object)order.getScheduleRecordId());
                    }
                    order.setOrderStatus(OrderStatusEnum.EXPIRY.getCode());
                    log.info("\u6d88\u8d39\u540e\u66f4\u65b0\u6d88\u606f\u7684\u72b6\u6001{}", (Object)order);
                    this.orderMapper.updateById((Object)order);
                }
            }
            if (delayMqEntity.getType().equals("2")) {
                order = (OrderEntity)this.orderMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)delayMqEntity.getOrderId()));
                if (BeanUtil.isEmpty((Object)order, (String[])new String[0])) {
                    log.error("\u67e5\u8be2\u5f53\u524d\u8ba2\u5355\u4e3a\u7a7a");
                    return;
                }
                if (!Objects.equals(order.getOrderStatus(), OrderStatusEnum.VISITS.getCode()) && !Objects.equals(order.getOrderStatus(), OrderStatusEnum.VISITS_END.getCode())) return;
                order.setOrderStatus(OrderStatusEnum.MASKED.getCode());
                this.orderMapper.updateById((Object)order);
                return;
            }
            if (!delayMqEntity.getType().equals("3")) return;
        }
        catch (Exception e) {
            log.error("mq\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
        }
    }
}

