/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.dto.UcConfigurationDTO;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.constant.ComponentConstant;
import com.ebaiyihui.physical.exception.BusinessException;
import com.ebaiyihui.physical.utils.HttpUtils;
import com.ebaiyihui.physical.vo.req.PushConfigSignCodeDetailVO;
import com.ebaiyihui.physical.vo.req.PushConfigurationDetailVO;
import com.ebaiyihui.physical.vo.req.UcWxAuthReqVo;
import com.ebaiyihui.physical.vo.res.WxOpenIdResponse;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class PushParamUtil {
    private static final Logger log = LoggerFactory.getLogger(PushParamUtil.class);
    @Resource
    private ComponentConstant componentConstant;

    public String getWxOpenId(String userId, String appCode) {
        UcWxAuthReqVo ucWxAuthReqVo = new UcWxAuthReqVo();
        ucWxAuthReqVo.setUserId(userId);
        ucWxAuthReqVo.setStatus((short)1);
        ucWxAuthReqVo.setUserType((short)0);
        String JsonString = JSONObject.toJSONString((Object)ucWxAuthReqVo);
        String url = StringUtils.join((Object[])new String[]{this.componentConstant.getDomain(), "/", appCode, this.componentConstant.getURL_GETOPENID()});
        try {
            log.info("\u83b7\u53d6openId\u8def\u5f84\uff1a{},\u53c2\u6570\uff1a{}", (Object)url, (Object)JsonString);
            String responseStr = HttpUtils.post((String)url, (String)JsonString);
            log.info("====\u8c03\u7528\u83b7\u53d6openId\u8fd4\u56de{}", (Object)responseStr);
            WxOpenIdResponse wxOpenIdResponse = (WxOpenIdResponse)JSON.parseObject((String)responseStr, WxOpenIdResponse.class);
            if (wxOpenIdResponse != null) {
                String openId = wxOpenIdResponse.getData().getWxOpenid();
                return openId;
            }
        }
        catch (Exception e) {
            log.error("Exception", (Throwable)e);
        }
        return "";
    }

    public PushConfigurationDetailVO getPushConfig(String appCode, String pushType, String userType, String channlType) {
        PushConfigurationDetailVO configurationDetailVO = new PushConfigurationDetailVO();
        String pushConfigUrl = this.componentConstant.getURL_GETCONFIGDETAIL();
        String configuration = this.getConfigurationDetail(appCode, pushType, pushConfigUrl);
        log.info("configuration :{}", (Object)JSON.toJSONString((Object)configuration));
        if (pushType.equals("youmengPush")) {
            List configurationDetailVos = JSONObject.parseArray((String)configuration, PushConfigurationDetailVO.class);
            log.info(" json\u8f6clist ==configurationDetailVos :{}", (Object)JSON.toJSONString((Object)configurationDetailVos));
            for (PushConfigurationDetailVO detailVO : configurationDetailVos) {
                if (!detailVO.getUserType().equals(userType) || !detailVO.getDeviceType().equals(channlType)) continue;
                BeanUtils.copyProperties((Object)detailVO, (Object)configurationDetailVO);
            }
            return configurationDetailVO;
        }
        PushConfigurationDetailVO pushConfigurationDetailVO = (PushConfigurationDetailVO)JSONObject.parseObject((String)configuration, PushConfigurationDetailVO.class);
        log.info(" json\u8f6cobj ==pushConfigurationDetailVO :{}", (Object)JSON.toJSONString((Object)pushConfigurationDetailVO));
        if (pushType.equals("sms")) {
            PushConfigSignCodeDetailVO pushConfigSignCodeDetailVO = (PushConfigSignCodeDetailVO)JSONObject.parseObject((String)pushConfigurationDetailVO.getSignCode(), PushConfigSignCodeDetailVO.class);
            log.info(" json\u8f6cobj ==pushConfigSignCodeDetailVO :{}", (Object)JSON.toJSONString((Object)pushConfigSignCodeDetailVO));
            pushConfigurationDetailVO.setDoctorCode(pushConfigSignCodeDetailVO.getDoctorCode());
            pushConfigurationDetailVO.setPatientCode(pushConfigSignCodeDetailVO.getPatientCode());
        }
        return pushConfigurationDetailVO;
    }

    public String getConfigurationDetail(String appCode, String type) {
        return this.getConfigurationDetail(appCode, type, this.componentConstant.getURL_GETCONFIGDETAIL());
    }

    public String getConfigurationDetail(String appCode, String type, String url) {
        UcConfigurationDTO ucConfigurationDTO = new UcConfigurationDTO();
        ucConfigurationDTO.setType(type);
        ucConfigurationDTO.setAppCode(appCode);
        BaseResponse response = null;
        log.info("getConfigurationDetail\u8def\u5f84:{}\u53c2\u6570\uff1a{}", (Object)url, (Object)JSON.toJSONString((Object)ucConfigurationDTO));
        try {
            String result = HttpUtils.jsonPost((String)url, (String)JSON.toJSONString((Object)ucConfigurationDTO));
            response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), BaseResponse.class);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u63a8\u9001\u63a5\u53e3\u5931\u8d25" + e.getMessage());
        }
        if (response == null) {
            throw new BusinessException("response\u4e3anull");
        }
        log.info("\u83b7\u53d6\u914d\u7f6e\u8be6\u60c5 \u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)response));
        UcConfigurationVO ucConfigurationVO = (UcConfigurationVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), UcConfigurationVO.class);
        log.info("\u83b7\u53d6\u914d\u7f6e\u8be6\u60c5\u770bjson\u89e3\u6790: {}", (Object)JSON.toJSONString((Object)ucConfigurationVO));
        return ucConfigurationVO.getClientCode();
    }
}

