/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hkdhisfront.service.impl;

import com.ebaiyihui.hkdhisfront.appoint.ReponseFeeDetailRecordVo;
import com.ebaiyihui.hkdhisfront.appoint.ReponseInvoiceDetailVo;
import com.ebaiyihui.hkdhisfront.appoint.ReponseInvoiceInfoVo;
import com.ebaiyihui.hkdhisfront.appoint.ReponseItemVo;
import com.ebaiyihui.hkdhisfront.appoint.RequestCardNoVo;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.common.enums.EntityKeyEnum;
import com.ebaiyihui.hkdhisfront.common.enums.MethodCodeEnum;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseFeeDetailRecordDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseInvoiceDetailDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseInvoiceInfoDTO;
import com.ebaiyihui.hkdhisfront.service.HisRemoteService;
import com.ebaiyihui.hkdhisfront.service.InvoiceService;
import java.util.HashMap;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceServiceImpl
implements InvoiceService {
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<ReponseInvoiceInfoVo> invoiceList(FrontRequest<RequestCardNoVo> param) {
        RequestCardNoVo requestCardNoVo = (RequestCardNoVo)param.getBody();
        HashMap<String, RequestCardNoVo> map = new HashMap<String, RequestCardNoVo>(1);
        RequestCardNoVo requestCardNo = RequestCardNoVo.builder().cardNo(requestCardNoVo.getCardNo()).busType(requestCardNoVo.getBusType()).beginDate(requestCardNoVo.getBeginDate() + " 00:00:00").endDate(requestCardNoVo.getEndDate() + " 23:59:59").build();
        map.put(EntityKeyEnum.INVOICE_LIST.getValue(), requestCardNo);
        FrontResponse invoiceList = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.INVOICE_LIST.getValue(), map, ReponseInvoiceInfoDTO.class);
        if (Objects.isNull(invoiceList)) {
            return FrontResponse.error((String)invoiceList.getTransactionId(), (String)"0", null);
        }
        ReponseInvoiceInfoDTO body = (ReponseInvoiceInfoDTO)invoiceList.getBody();
        ReponseInvoiceInfoVo reponseInvoiceInfoVo = new ReponseInvoiceInfoVo();
        BeanUtils.copyProperties((Object)body, (Object)reponseInvoiceInfoVo);
        return FrontResponse.success((String)invoiceList.getTransactionId(), (Object)reponseInvoiceInfoVo);
    }

    public FrontResponse<ReponseInvoiceDetailVo> invoiceDetails(FrontRequest<RequestCardNoVo> param) {
        RequestCardNoVo requestCardNoVo = (RequestCardNoVo)param.getBody();
        HashMap<String, RequestCardNoVo> map = new HashMap<String, RequestCardNoVo>(1);
        RequestCardNoVo requestCardNo = RequestCardNoVo.builder().cardNo(requestCardNoVo.getCardNo()).busType(requestCardNoVo.getBusType()).clinicNo(requestCardNoVo.getClinicNo()).invoiceNo(requestCardNoVo.getInvoiceNo()).isUrl(requestCardNoVo.getIsUrl()).operCode("").build();
        map.put(EntityKeyEnum.INVOICE_DETAILS.getValue(), requestCardNo);
        FrontResponse invoiceDetails = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.INVOICE_DETAILS.getValue(), map, ReponseInvoiceDetailDTO.class);
        if (Objects.isNull(invoiceDetails)) {
            return FrontResponse.error((String)invoiceDetails.getTransactionId(), (String)"0", null);
        }
        ReponseInvoiceDetailDTO body = (ReponseInvoiceDetailDTO)invoiceDetails.getBody();
        ReponseInvoiceDetailVo reponseInvoiceDetailVo = new ReponseInvoiceDetailVo();
        BeanUtils.copyProperties((Object)body, (Object)reponseInvoiceDetailVo);
        return FrontResponse.success((String)invoiceDetails.getTransactionId(), (Object)reponseInvoiceDetailVo);
    }

    public FrontResponse<ReponseFeeDetailRecordVo> priceDisclosure(FrontRequest<ReponseItemVo> param) {
        ReponseItemVo reponseItemVo = (ReponseItemVo)param.getBody();
        HashMap<String, ReponseItemVo> map = new HashMap<String, ReponseItemVo>(1);
        ReponseItemVo ReponseItem = ReponseItemVo.builder().itemType(reponseItemVo.getItemType()).spellCode("").build();
        map.put(EntityKeyEnum.PRICE_DISCLOSURE.getValue(), ReponseItem);
        FrontResponse priceDisclosure = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PRICE_DISCLOSURE.getValue(), map, ReponseFeeDetailRecordDTO.class);
        if (Objects.isNull(priceDisclosure)) {
            return FrontResponse.error((String)priceDisclosure.getTransactionId(), (String)"0", null);
        }
        ReponseFeeDetailRecordDTO body = (ReponseFeeDetailRecordDTO)priceDisclosure.getBody();
        ReponseFeeDetailRecordVo reponseFeeDetailRecordVo = new ReponseFeeDetailRecordVo();
        BeanUtils.copyProperties((Object)body, (Object)reponseFeeDetailRecordVo);
        return FrontResponse.success((String)priceDisclosure.getTransactionId(), (Object)reponseFeeDetailRecordVo);
    }
}

