/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hkdhisfront.payment.utils;

import cn.hutool.core.codec.Base64;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.hkdhisfront.payment.model.BusinessCallRequest;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.digests.MD5Digest;

/*
 * Exception performing whole class analysis ignored.
 */
public class SignUtils {
    private static final String HEXADECIMAL = "0123456789ABCDEF";
    private static final String UTF_8 = "utf-8";

    public static String createSign(Map<String, String> params) {
        String jsonString = JSON.toJSONString(params);
        System.out.println();
        byte[] hexBytes = jsonString.getBytes();
        String printHexBinary = DatatypeConverter.printHexBinary((byte[])hexBytes);
        String md5Hex = DigestUtils.md5Hex((String)printHexBinary);
        return Base64.encode((CharSequence)md5Hex);
    }

    public static String createSignByObject(BusinessCallRequest businessCallRequest) throws UnsupportedEncodingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonString = null;
        try {
            jsonString = objectMapper.writeValueAsString((Object)businessCallRequest);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        try {
            return SignUtils.sign((String)jsonString, (String)"utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String createSign(Map<String, String> params, String partnerKey) {
        params.remove("sign");
        String stringA = SignUtils.packageSign(params, (boolean)false);
        String stringSignTemp = stringA + "&key=" + partnerKey;
        return DigestUtils.md5Hex((String)stringSignTemp).toUpperCase();
    }

    private static String packageSign(Map<String, String> params, boolean urlEncoder) {
        TreeMap<String, String> sortedParams = new TreeMap<String, String>(params);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> param : sortedParams.entrySet()) {
            String value = param.getValue();
            if (StringUtils.isBlank((CharSequence)value)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(param.getKey()).append("=");
            if (urlEncoder) {
                try {
                    value = SignUtils.urlEncode((String)value);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            sb.append(value);
        }
        return sb.toString();
    }

    private static String urlEncode(String src) throws UnsupportedEncodingException {
        return URLEncoder.encode(src, StandardCharsets.UTF_8.name()).replace("+", "%20");
    }

    private static String chargeContent(String content) throws UnsupportedEncodingException {
        char[] chars = "0123456789ABCDEF".toCharArray();
        byte[] con = content.getBytes("utf-8");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < con.length; ++i) {
            int bit = (con[i] & 0xF0) >> 4;
            sb.append(chars[bit]);
            bit = con[i] & 0xF;
            sb.append(chars[bit]);
        }
        return sb.toString();
    }

    public static String sign(String content, String charset) throws Exception {
        String res = null;
        try {
            content = SignUtils.chargeContent((String)content);
            MD5Digest md5Digest = new MD5Digest();
            md5Digest.reset();
            md5Digest.update(content.getBytes(charset), 0, content.length());
            byte[] resByte = new byte[16];
            md5Digest.doFinal(resByte, 0);
            res = new String(java.util.Base64.getEncoder().encode(resByte), charset);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return res;
    }
}

