/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.controller;

import com.ebaiyihui.common.ManagerAuthApi;
import com.ebaiyihui.common.pojo.annotation.AccessCheck;
import com.ebaiyihui.common.pojo.query.UcAccountQuery;
import com.ebaiyihui.common.pojo.systemauthVo.AccountResVo;
import com.ebaiyihui.common.pojo.systemauthVo.ManagerAddReqVo;
import com.ebaiyihui.common.pojo.systemauthVo.ManagerEditReqVo;
import com.ebaiyihui.common.pojo.systemauthVo.MemberCountResVo;
import com.ebaiyihui.common.pojo.systemauthVo.VerifyPasswordReqVo;
import com.ebaiyihui.common.pojo.vo.GetExportListReqVO;
import com.ebaiyihui.framework.model.ExcelData;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.ExcelUtils;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.IManagerAuthService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Api(description="\u7cfb\u7edf\u7ba1\u7406\u6d88\u606f\u4e2a\u4eba\u8bbe\u7f6eAPI")
@AccessCheck(value=AccessCheck.PermissionType.ADMIN_API)
public class ManagerAuthController
extends BaseService
implements ManagerAuthApi {
    private static final Logger log = LoggerFactory.getLogger(ManagerAuthController.class);
    @Autowired
    private IManagerAuthService managerAuthService;

    @ApiOperation(value="\u67e5\u8be2\u6210\u5458\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public BaseResponse<MemberCountResVo> getMemberCount(@RequestParam String appCode) {
        return this.managerAuthService.getMemberCount(appCode);
    }

    @ApiOperation(value="\u6dfb\u52a0\u6210\u5458")
    @ResponseBody
    public BaseResponse<AccountResVo> addMember(@RequestBody ManagerAddReqVo managerAddReqVo) {
        return this.managerAuthService.addMember(managerAddReqVo);
    }

    @ApiOperation(value="\u7f16\u8f91\u6210\u5458,\u4fee\u6539\u57fa\u672c\u4fe1\u606f")
    @ResponseBody
    public BaseResponse<AccountResVo> editMember(@RequestBody ManagerEditReqVo managerEditReqVo) {
        return this.managerAuthService.editMember(managerEditReqVo);
    }

    @ApiOperation(value="\u5220\u9664\u6210\u5458")
    @ResponseBody
    public BaseResponse<Boolean> deleteMember(@RequestParam(value="accountId") String accountId) {
        return this.managerAuthService.deleteMember(accountId);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u5bc6\u7801")
    @ResponseBody
    public BaseResponse<Boolean> verifyPassword(@RequestBody VerifyPasswordReqVo vo) {
        return this.managerAuthService.verifyPassword(vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f")
    @ResponseBody
    public BaseResponse<AccountResVo> getMemberInfo(@RequestParam(value="accountId") String accountId) {
        return this.managerAuthService.getMemberInfo(accountId);
    }

    @ApiOperation(value="\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u6210\u5458\u5217\u8868")
    @ResponseBody
    public BaseResponse<PageResult<AccountResVo>> getMemberList(@RequestBody UcAccountQuery query) {
        return this.managerAuthService.getMemberList(query);
    }

    @ApiOperation(value="\u5bfc\u51fa\u6210\u5458\u5217\u8868")
    public BaseResponse<?> exportListV2(@Validated @RequestBody GetExportListReqVO getExportListReqVO, HttpServletResponse httpServletResponse) throws Exception {
        ExcelData excelData = this.managerAuthService.exportMemberList(getExportListReqVO.getIds());
        ExcelUtils.exportExcel((HttpServletResponse)httpServletResponse, (String)"\u6210\u5458\u4fe1\u606f\u8868", (ExcelData)excelData);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5bfc\u51fa\u6210\u5458\u5217\u8868")
    public BaseResponse<?> exportList(@RequestParam(value="ids") String ids, HttpServletResponse httpServletResponse) throws Exception {
        ExcelData excelData = this.managerAuthService.exportMemberList(ids);
        ExcelUtils.exportExcel((HttpServletResponse)httpServletResponse, (String)"\u6210\u5458\u4fe1\u606f\u8868", (ExcelData)excelData);
        return BaseResponse.success();
    }

    @PostMapping(value={"/getMemberListAntianaphylaxis"})
    @ResponseBody
    public BaseResponse<List<AccountResVo>> getMemberListAntianaphylaxis(@RequestBody UcAccountQuery ucAccountQuery) {
        return this.managerAuthService.getMemberListAntianaphylaxis(ucAccountQuery);
    }
}

