/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpUtils;
import com.ebaiyihui.server.config.SettingConfig;
import com.ebaiyihui.server.pojo.entity.UcWxAppletConfigEntity;
import com.ebaiyihui.server.pojo.vo.GetMiniProgramLinkResVo;
import com.ebaiyihui.server.pojo.vo.GetWxAccessTokenRespVo;
import com.ebaiyihui.server.repository.UcWxAppletConfigMapper;
import com.ebaiyihui.server.service.SysConfigService;
import com.ebaiyihui.server.util.HttpClientUtils;
import com.ebaiyihui.server.util.RedisUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysConfigServiceImpl
implements SysConfigService {
    private static final Logger log = LoggerFactory.getLogger(SysConfigServiceImpl.class);
    @Autowired
    private UcWxAppletConfigMapper ucWxAppletConfigMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    SettingConfig settingConfig;
    private static final String POST_TENCENT_GENERATE_URLLINK = "https://api.weixin.qq.com/wxa/generate_urllink?access_token=";

    public BaseResponse<Object> getMiniProgramLink(GetMiniProgramLinkResVo resVo) {
        log.info("\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u8df3\u8f6c\u94fe\u63a5\u8bf7\u6c42\u53c2\u6570{}", (Object)JSON.toJSONString((Object)resVo));
        if (this.settingConfig.getTestMode().booleanValue()) {
            log.info("\u975e\u751f\u4ea7\u73af\u5883,\u4e0d\u6267\u884c\u771f\u5b9e\u7684\u8c03\u7528");
            return BaseResponse.success();
        }
        try {
            String accessToken = this.getWxAccessToken(resVo.getAppCode());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("path", resVo.getPath());
            if (Objects.nonNull(resVo.getQuery())) {
                params.put("query", resVo.getQuery());
            }
            params.put("expire_type", 1);
            params.put("expire_interval", 30);
            String jsonStr = JSON.toJSONString(params);
            log.info("\u83b7\u53d6\u8df3\u8f6c\u94fe\u63a5,\u8bf7\u6c42\u53c2\u6570{}", (Object)jsonStr);
            String res = HttpClientUtils.simplePostJSONInvoke((String)(POST_TENCENT_GENERATE_URLLINK + accessToken), (JSONObject)JSON.parseObject((String)jsonStr));
            log.info("\u83b7\u53d6\u8df3\u8f6c\u94fe\u63a5,\u8fd4\u56de{}", (Object)res);
            Map resMap = (Map)JSON.parse((String)res);
            if (0 == (Integer)resMap.get("errcode")) {
                return BaseResponse.success(resMap.get("url_link"));
            }
            BaseResponse responseError = BaseResponse.error((String)((String)resMap.get("errmsg")));
            responseError.setErrCode(resMap.get("errcode").toString());
            return responseError;
        }
        catch (Exception e) {
            log.error("\u77ed\u4fe1\u901a\u77e5\u9700\u8981\u83b7\u53d6\u7684\u5c0f\u7a0b\u5e8f\u8df3\u8f6c\u94fe\u63a5\u7684\u7edf\u4e00\u540e\u7aef\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            return BaseResponse.error((String)e.getMessage());
        }
    }

    private String getWxAccessToken(String appCode) {
        Optional ucWxAppletConfigEntity1;
        String accessToken = (String)this.redisUtil.get("wx_access_token_key_" + appCode);
        if (StringUtils.isEmpty((String)accessToken) && (ucWxAppletConfigEntity1 = this.ucWxAppletConfigMapper.selectByAppIdType(appCode)).isPresent()) {
            UcWxAppletConfigEntity ucWxAppletConfigEntity = (UcWxAppletConfigEntity)ucWxAppletConfigEntity1.get();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("grant_type", "client_credential");
            map.put("appid", ucWxAppletConfigEntity.getAppletId());
            map.put("secret", ucWxAppletConfigEntity.getAppletSecret());
            String ret = HttpUtils.get((String)"https://api.weixin.qq.com/cgi-bin/token", map);
            log.info("\u83b7\u53d6\u5fae\u4fe1token\u8fd4\u56de\u7ed3\u679c:{}", (Object)ret);
            if (StringUtils.isEmpty((String)ret)) {
                return accessToken;
            }
            GetWxAccessTokenRespVo getWxAccessTokenRespVo = (GetWxAccessTokenRespVo)JSON.parseObject((String)ret, GetWxAccessTokenRespVo.class);
            if (getWxAccessTokenRespVo.getErrcode() != 0) {
                log.error("\u83b7\u53d6\u5fae\u4fe1token\u5931\u8d25:{}", (Object)getWxAccessTokenRespVo.getErrmsg());
                return accessToken;
            }
            accessToken = getWxAccessTokenRespVo.getAccess_token();
        }
        return accessToken;
    }
}

