/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.model.ExcelData;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.pojo.entity.UcUserServiceLabelEntity;
import com.ebaiyihui.server.pojo.vo.GetUserServiceLabelReqVo;
import com.ebaiyihui.server.pojo.vo.SaveUserServiceLabelReqVo;
import com.ebaiyihui.server.pojo.vo.ServiceLabelReqVo;
import com.ebaiyihui.server.pojo.vo.UserServiceLabelRepVo;
import com.ebaiyihui.server.repository.UcUserServiceLabelMapper;
import com.ebaiyihui.server.service.UcUserServiceLabelService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UcUserServiceLabelServiceImpl
implements UcUserServiceLabelService {
    private static final Logger log = LoggerFactory.getLogger(UcUserServiceLabelServiceImpl.class);
    @Autowired
    private UcUserServiceLabelMapper ucUserServiceLabelMapper;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> saveUserLabelUser(SaveUserServiceLabelReqVo userLabel) {
        List deleteLabelList;
        log.info("\u7528\u6237\u4fdd\u5b58\u7528\u6237\u6807\u7b7e\u7684\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)userLabel));
        String userId = userLabel.getUserId();
        List labelReqList = userLabel.getServiceLabelReqVoList();
        if (CollectionUtils.isEmpty((Collection)labelReqList)) {
            this.ucUserServiceLabelMapper.deleteByUserId(userId);
            return BaseResponse.success((Object)"\u6dfb\u52a0\u6210\u529f");
        }
        List userExistLabelList = this.ucUserServiceLabelMapper.selectUserLabelByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)userExistLabelList)) {
            this.ucUserServiceLabelMapper.batchInsertLabel(userId, labelReqList);
            return BaseResponse.success((Object)"\u6dfb\u52a0\u6210\u529f");
        }
        List existLabels = userExistLabelList.stream().map(ServiceLabelReqVo::getServiceLabelId).distinct().collect(Collectors.toList());
        List intersectionLabelIds = labelReqList.stream().filter(x -> existLabels.contains(x.getServiceLabelId())).map(ServiceLabelReqVo::getServiceLabelId).collect(Collectors.toList());
        List addLabelList = labelReqList.stream().filter(x -> !intersectionLabelIds.contains(x.getServiceLabelId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(addLabelList)) {
            this.ucUserServiceLabelMapper.batchInsertLabel(userId, addLabelList);
        }
        if (!CollectionUtils.isEmpty(deleteLabelList = userExistLabelList.stream().filter(x -> !intersectionLabelIds.contains(x.getServiceLabelId())).map(ServiceLabelReqVo::getServiceLabelId).distinct().collect(Collectors.toList()))) {
            this.ucUserServiceLabelMapper.deleteByUserIdAndLabelList(userId, deleteLabelList);
        }
        return BaseResponse.success((Object)"\u6dfb\u52a0\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public String saveUserLabelUserWeb(SaveUserServiceLabelReqVo saveUserServiceLabelReqVo) {
        log.info("\u7ba1\u7406\u5458\u4fdd\u5b58\u7528\u6237\u6807\u7b7e\u7684\u53c2\u6570\u4e3a:{}", (Object)saveUserServiceLabelReqVo.toString());
        this.ucUserServiceLabelMapper.deleteByUserId(saveUserServiceLabelReqVo.getUserId());
        for (ServiceLabelReqVo serviceLabelReqVo : saveUserServiceLabelReqVo.getServiceLabelReqVoList()) {
            UcUserServiceLabelEntity ucUserServiceLabelEntity = new UcUserServiceLabelEntity();
            ucUserServiceLabelEntity.setUserId(saveUserServiceLabelReqVo.getUserId());
            ucUserServiceLabelEntity.setServiceLabelId(serviceLabelReqVo.getServiceLabelId());
            ucUserServiceLabelEntity.setServiceLabelName(serviceLabelReqVo.getServiceLabelName());
            this.ucUserServiceLabelMapper.insertSelective(ucUserServiceLabelEntity);
        }
        return "\u6807\u7b7e\u5df2\u6dfb\u52a0\u6210\u529f";
    }

    public PageResult<UserServiceLabelRepVo> getUserServiceLabel(GetUserServiceLabelReqVo userLabelReqVo) {
        log.info("\u83b7\u53d6\u6240\u6709\u7528\u6237\u6807\u7b7e\u7ed1\u5b9a\u5173\u7cfb\u5217\u8868\u7684\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)userLabelReqVo));
        List<UserServiceLabelRepVo> userLabelRepVoList = null;
        if (StringUtils.isNotBlank((CharSequence)userLabelReqVo.getSearch())) {
            List userIdList = this.ucUserServiceLabelMapper.selectUserIdBySearch(userLabelReqVo.getSearch(), userLabelReqVo.getAppCode());
            if (!CollectionUtils.isEmpty((Collection)userIdList)) {
                userLabelRepVoList = this.ucUserServiceLabelMapper.selectUserLabelByUserIds(userIdList);
            }
        } else {
            userLabelRepVoList = this.ucUserServiceLabelMapper.selectUserLabel(userLabelReqVo.getAppCode());
        }
        if (userLabelRepVoList != null) {
            int total = userLabelRepVoList.stream().collect(Collectors.counting()).intValue();
            long offset = (long)(userLabelReqVo.getPageNum() - 1) * (long)userLabelReqVo.getPageSize();
            userLabelRepVoList = userLabelRepVoList.stream().skip(offset).limit(userLabelReqVo.getPageSize()).sorted(Comparator.comparing(UserServiceLabelRepVo::getLastLoginTime).reversed()).collect(Collectors.toList());
            userLabelRepVoList.forEach(label -> {
                label.setLabelCount(Integer.valueOf(label.getLabelList().size()));
                if (CollectionUtils.isEmpty((Collection)label.getLabelList())) {
                    label.setLabelCount(Integer.valueOf(0));
                }
            });
            PageResult pageResult = new PageResult();
            pageResult.setContent(userLabelRepVoList);
            pageResult.setPageNum(userLabelReqVo.getPageNum());
            pageResult.setPageSize(userLabelReqVo.getPageSize());
            pageResult.setTotal(total);
            return pageResult;
        }
        return new PageResult();
    }

    public List<ServiceLabelReqVo> getUserLabelByUserId(String userId) {
        log.info("\u83b7\u53d6\u7528\u6237\u7ed1\u5b9a\u7684\u6807\u7b7e\u96c6\u5408\u7684\u53c2\u6570\u4e3a:{}", (Object)userId);
        return this.ucUserServiceLabelMapper.selectUserLabelByUserId(userId);
    }

    public ExcelData exportUserServiceLabel(List<String> userIdList) {
        log.info("\u5bfc\u51fa\u7528\u6237\u4fe1\u606f\u7684\u53c2\u6570\u4e3a:{}", (Object)userIdList.toString());
        List userServiceLabelRepVoList = this.ucUserServiceLabelMapper.selectUserLabelByUserIds(userIdList);
        ExcelData excelData = new ExcelData();
        excelData.setName("\u7528\u6237\u5217\u8868\u4fe1\u606f");
        excelData.setTitles(this.getTitle());
        List collect = userServiceLabelRepVoList.stream().map(arg_0 -> this.getRow(arg_0)).collect(Collectors.toList());
        excelData.setRows(collect);
        log.info("\u5bfc\u51fa\u7528\u6237\u4fe1\u606f\u7684\u8fd4\u56de\u503c\u4e3a:{}", (Object)excelData.toString());
        return excelData;
    }

    private List<Object> getRow(UserServiceLabelRepVo userServiceLabelRepVo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(userServiceLabelRepVo.getAccountId());
        list.add(sdf.format(userServiceLabelRepVo.getLastLoginTime() == null ? new Date() : userServiceLabelRepVo.getLastLoginTime()));
        list.add(userServiceLabelRepVo.getPhone());
        list.add(userServiceLabelRepVo.getLabelCount());
        List serviceLabelReqVoList = this.ucUserServiceLabelMapper.selectUserLabelByUserId(userServiceLabelRepVo.getUserId());
        String labelName = serviceLabelReqVoList.stream().map(ServiceLabelReqVo::getServiceLabelName).collect(Collectors.joining(","));
        list.add(labelName);
        return list;
    }

    private List<String> getTitle() {
        return Arrays.asList("\u7528\u6237ID", "\u6700\u8fd1\u4e00\u6b21\u767b\u5f55\u65f6\u95f4", "\u624b\u673a\u53f7", "\u7528\u6237\u6807\u7b7e\u6570", "\u7528\u6237\u6807\u7b7e");
    }
}

