/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.framework.utils.ByhHttpUtil;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.vo.IdCardValidateResponseVo;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AliCloudIdCardUtil {
    private static final Logger log = LoggerFactory.getLogger(AliCloudIdCardUtil.class);
    private static final String requestMethod = "GET";
    private static final String old_host = "http://idcard3.market.alicloudapi.com";
    private static final String old_path = "/idcardAudit";
    private static final String old_appcode = "61b187e71f744004a3e54141f9f7f95b";
    private static final String new_host = "https://idcert.market.alicloudapi.com";
    private static final String new_path = "/idcard";
    private static final String new_appcode = "61b187e71f744004a3e54141f9f7f95b";
    private static final String zk_appcode = "24971ba9dc9a4189b7fb61554e7c04e9";

    public String verifyIdWithName(String idCard, String name) {
        log.info("==============\u5f00\u59cb\u8fdb\u5165\u8eab\u4efd\u8bc1\u6821\u9a8c==================");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "APPCODE 61b187e71f744004a3e54141f9f7f95b");
        HashMap<String, String> querys = new HashMap<String, String>();
        querys.put("idcard", idCard);
        querys.put("name", name);
        try {
            HttpResponse response = ByhHttpUtil.doGet((String)old_host, (String)old_path, (String)requestMethod, headers, querys);
            String entityString = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u8eab\u4efd\u8bc1\u6821\u9a8c\u5b8c\u6210:" + entityString);
            return entityString;
        }
        catch (Exception e) {
            log.info("\u8eab\u4efd\u8bc1\u6821\u9a8c\u51fa\u9519{}", (Throwable)e);
            return null;
        }
    }

    public IdCardValidateResponseVo verifyIdWithNameV2(String idCard, String name) {
        log.info("==============\u5f00\u59cb\u8fdb\u5165V2\u8eab\u4efd\u8bc1\u6821\u9a8c==================,\u53c2\u6570idCard:{}, name:{}", (Object)idCard, (Object)name);
        if (StringUtils.isEmpty((String)idCard) || StringUtils.isEmpty((String)name)) {
            throw new UserCenterRuntimeException(ErrorEnum.MISSING_PARAMETER, "\u53c2\u6570\u5f02\u5e38: idCard:[" + idCard + "], name:[" + name + "]");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>(2);
        queryParams.put("idCard", idCard);
        queryParams.put("name", name);
        HashMap<String, String> headers = new HashMap<String, String>(5);
        headers.put("Authorization", "APPCODE 61b187e71f744004a3e54141f9f7f95b");
        IdCardValidateResponseVo idCardValidateResponseEntity = new IdCardValidateResponseVo();
        try {
            HttpResponse httpResponse = ByhHttpUtil.doGet((String)new_host, (String)new_path, (String)requestMethod, headers, queryParams);
            String jsonString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            if (jsonString != null) {
                log.info("\u8fd4\u56de\u503cjsonString:" + jsonString);
                idCardValidateResponseEntity = (IdCardValidateResponseVo)JSONObject.parseObject((String)jsonString, IdCardValidateResponseVo.class);
            }
            log.info("\u8c03\u7528\u8fd4\u56de\u503c\u4e3a:jsonString:" + jsonString + ",idCardValidateResponseEntity:" + idCardValidateResponseEntity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return idCardValidateResponseEntity;
    }

    public IdCardValidateResponseVo zkVerifyIdWithNameV2(String idCard, String name) {
        log.info("==============\u5f00\u59cb\u8fdb\u5165V2\u8eab\u4efd\u8bc1\u6821\u9a8c==================,\u53c2\u6570idCard:{}, name:{}", (Object)idCard, (Object)name);
        if (StringUtils.isEmpty((String)idCard) || StringUtils.isEmpty((String)name)) {
            throw new UserCenterRuntimeException(ErrorEnum.MISSING_PARAMETER, "\u53c2\u6570\u5f02\u5e38: idCard:[" + idCard + "], name:[" + name + "]");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>(2);
        queryParams.put("idCard", idCard);
        queryParams.put("name", name);
        HashMap<String, String> headers = new HashMap<String, String>(5);
        headers.put("Authorization", "APPCODE 24971ba9dc9a4189b7fb61554e7c04e9");
        IdCardValidateResponseVo idCardValidateResponseEntity = new IdCardValidateResponseVo();
        try {
            HttpResponse httpResponse = ByhHttpUtil.doGet((String)new_host, (String)new_path, (String)requestMethod, headers, queryParams);
            String jsonString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            if (jsonString != null) {
                log.info("\u8fd4\u56de\u503cjsonString:{}", (Object)jsonString);
                idCardValidateResponseEntity = (IdCardValidateResponseVo)JSONObject.parseObject((String)jsonString, IdCardValidateResponseVo.class);
            }
            log.info("idCardValidateResponseEntity:{}", (Object)JSON.toJSONString((Object)idCardValidateResponseEntity));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return idCardValidateResponseEntity;
    }
}

